/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;

public class AutoAcknowledger
implements Acknowledger {
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final SQSSession session;

    public AutoAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient, SQSSession session) {
        this.amazonSQSClient = amazonSQSClient;
        this.session = session;
    }

    @Override
    public void acknowledge(SQSMessage message) throws JMSException {
        this.session.checkClosed();
        this.amazonSQSClient.deleteMessage((DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(message.getQueueUrl()).receiptHandle(message.getReceiptHandle()).build());
    }

    @Override
    public void notifyMessageReceived(SQSMessage message) throws JMSException {
        this.acknowledge(message);
    }

    @Override
    public List<SQSMessageIdentifier> getUnAckMessages() {
        return Collections.emptyList();
    }

    @Override
    public void forgetUnAckMessages() {
    }
}

