/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;

public class SQSQueueDestination
implements Destination,
Queue {
    private final String queueName;
    private final String queueUrl;
    private final boolean isFifo;

    SQSQueueDestination(String queueName, String queueUrl) {
        this.queueName = queueName;
        this.queueUrl = queueUrl;
        this.isFifo = this.queueName.endsWith(".fifo");
    }

    public String getQueueName() throws JMSException {
        return this.queueName;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public boolean isFifo() {
        return this.isFifo;
    }

    public String toString() {
        return "SQSDestination [queueName=" + this.queueName + ", queueUrl=" + this.queueUrl + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.queueUrl == null ? 0 : this.queueUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQSQueueDestination other = (SQSQueueDestination)obj;
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        return !(this.queueUrl == null ? other.queueUrl != null : !this.queueUrl.equals(other.queueUrl));
    }
}

