/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.message;

import com.amazon.sqs.javamessaging.SQSQueueDestination;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SQSMessage
implements Message {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String BYTE_MESSAGE_TYPE = "byte";
    public static final String OBJECT_MESSAGE_TYPE = "object";
    public static final String TEXT_MESSAGE_TYPE = "text";
    public static final String JMS_SQS_MESSAGE_TYPE = "JMS_SQSMessageType";
    public static final String JMS_SQS_REPLY_TO_QUEUE_NAME = "JMS_SQSReplyToQueueName";
    public static final String JMS_SQS_REPLY_TO_QUEUE_URL = "JMS_SQSReplyToQueueURL";
    public static final String JMS_SQS_CORRELATION_ID = "JMS_SQSCorrelationID";
    private int deliveryMode = 2;
    private int priority = 4;
    private long timestamp;
    private boolean redelivered;
    private String correlationID;
    private long expiration = 0L;
    private long deliveryTime = 0L;
    private String messageID;
    private String type;
    private SQSQueueDestination replyTo;
    private Destination destination;
    private final Map<String, JMSMessagePropertyValue> properties = new HashMap<String, JMSMessagePropertyValue>();
    private boolean writePermissionsForProperties;
    private boolean writePermissionsForBody;
    private Acknowledger acknowledger;
    private String sqsMessageID;
    private String queueUrl;
    private String receiptHandle;

    SQSMessage(Acknowledger acknowledger, String queueUrl, com.amazonaws.services.sqs.model.Message sqsMessage) throws JMSException {
        this.acknowledger = acknowledger;
        this.queueUrl = queueUrl;
        this.receiptHandle = sqsMessage.getReceiptHandle();
        this.setSQSMessageId(sqsMessage.getMessageId());
        Map systemAttributes = sqsMessage.getAttributes();
        int receiveCount = Integer.parseInt((String)systemAttributes.get("ApproximateReceiveCount"));
        this.properties.put("JMSXDeliveryCount", new JMSMessagePropertyValue(receiveCount, "Number.int"));
        if (receiveCount > 1) {
            this.setJMSRedelivered(true);
        }
        if (sqsMessage.getMessageAttributes() != null) {
            this.addMessageAttributes(sqsMessage);
        }
        this.mapSystemAttributeToJmsMessageProperty(systemAttributes, "SequenceNumber", "JMS_SQS_SequenceNumber");
        this.mapSystemAttributeToJmsMessageProperty(systemAttributes, "MessageDeduplicationId", "JMS_SQS_DeduplicationId");
        this.mapSystemAttributeToJmsMessageProperty(systemAttributes, "MessageGroupId", "JMSXGroupID");
        this.writePermissionsForBody = false;
        this.writePermissionsForProperties = false;
    }

    private void mapSystemAttributeToJmsMessageProperty(Map<String, String> systemAttributes, String systemAttributeName, String jmsMessagePropertyName) throws JMSException {
        String systemAttributeValue = systemAttributes.get(systemAttributeName);
        if (systemAttributeValue != null) {
            this.properties.put(jmsMessagePropertyName, new JMSMessagePropertyValue(systemAttributeValue, "String"));
        }
    }

    SQSMessage() {
        this.writePermissionsForBody = true;
        this.writePermissionsForProperties = true;
    }

    private void addMessageAttributes(com.amazonaws.services.sqs.model.Message sqsMessage) throws JMSException {
        for (Map.Entry entry : sqsMessage.getMessageAttributes().entrySet()) {
            this.properties.put((String)entry.getKey(), new JMSMessagePropertyValue(((MessageAttributeValue)entry.getValue()).getStringValue(), ((MessageAttributeValue)entry.getValue()).getDataType()));
        }
    }

    protected void checkPropertyWritePermissions() throws JMSException {
        if (!this.writePermissionsForProperties) {
            throw new MessageNotWriteableException("Message properties are not writable");
        }
    }

    protected void checkBodyWritePermissions() throws JMSException {
        if (!this.writePermissionsForBody) {
            throw new MessageNotWriteableException("Message body is not writable");
        }
    }

    protected static JMSException convertExceptionToJMSException(Exception e) {
        JMSException ex = new JMSException(e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }

    protected static MessageFormatException convertExceptionToMessageFormatException(Exception e) {
        MessageFormatException ex = new MessageFormatException(e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }

    protected void setBodyWritePermissions(boolean enable) {
        this.writePermissionsForBody = enable;
    }

    public String getSQSMessageGroupId() throws JMSException {
        return this.getStringProperty("JMSXGroupID");
    }

    public String getSQSMessageDeduplicationId() throws JMSException {
        return this.getStringProperty("JMS_SQS_DeduplicationId");
    }

    public String getSQSMessageSequenceNumber() throws JMSException {
        return this.getStringProperty("JMS_SQS_SequenceNumber");
    }

    public String getSQSMessageId() {
        return this.sqsMessageID;
    }

    public void setSQSMessageId(String sqsMessageID) throws JMSException {
        this.sqsMessageID = sqsMessageID;
        this.setJMSMessageID(String.format("ID:%s", sqsMessageID));
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageID;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.messageID = id;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.correlationID != null ? this.correlationID.getBytes(DEFAULT_CHARSET) : null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            this.correlationID = correlationID != null ? new String(correlationID, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException(e.getMessage());
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.correlationID = correlationID;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        if (replyTo != null && !(replyTo instanceof SQSQueueDestination)) {
            throw new IllegalArgumentException("The replyTo Destination must be a SQSQueueDestination");
        }
        this.replyTo = (SQSQueueDestination)replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this.type;
    }

    public void setJMSType(String type) throws JMSException {
        this.type = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.deliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.deliveryTime = deliveryTime;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void clearProperties() throws JMSException {
        this.properties.clear();
        this.writePermissionsForProperties = true;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.properties.containsKey(name);
    }

    <T> T getPrimitiveProperty(String property, Class<T> type) throws JMSException {
        if (property == null) {
            throw new NullPointerException("Property name is null");
        }
        Object value = this.getObjectProperty(property);
        if (value == null) {
            return this.handleNullPropertyValue(property, type);
        }
        T convertedValue = TypeConversionSupport.convert(value, type);
        if (convertedValue == null) {
            throw new MessageFormatException("Property " + property + " was " + value.getClass().getName() + " and cannot be read as " + type.getName());
        }
        return convertedValue;
    }

    private <T> T handleNullPropertyValue(String name, Class<T> clazz) {
        if (clazz == String.class) {
            return null;
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (clazz == Double.class || clazz == Float.class) {
            throw new NullPointerException("Value of property with name " + name + " is null.");
        }
        throw new NumberFormatException("Value of property with name " + name + " is null.");
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Boolean.class);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Byte.class);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Short.class);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Integer.class);
    }

    public long getLongProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Long.class);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Float.class).floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, Double.class);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.getPrimitiveProperty(name, String.class);
    }

    public Object getObjectProperty(String name) throws JMSException {
        JMSMessagePropertyValue propertyValue = this.getJMSMessagePropertyValue(name);
        if (propertyValue != null) {
            return propertyValue.getValue();
        }
        return null;
    }

    public JMSMessagePropertyValue getJMSMessagePropertyValue(String name) throws JMSException {
        return this.properties.get(name);
    }

    public Enumeration<String> getPropertyNames() throws JMSException {
        return new PropertyEnum(this.properties.keySet().iterator());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property name can not be null or empty.");
        }
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Property value can not be null or empty.");
        }
        if (!this.isValidPropertyValueType(value)) {
            throw new MessageFormatException("Value of property with name " + name + " has incorrect type " + value.getClass().getName() + ".");
        }
        this.checkPropertyWritePermissions();
        this.properties.put(name, new JMSMessagePropertyValue(value));
    }

    public void acknowledge() throws JMSException {
        if (this.acknowledger != null) {
            this.acknowledger.acknowledge(this);
        }
    }

    public void clearBody() throws JMSException {
        throw new JMSException("SQSMessage does not have any body");
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        throw new JMSException("Could not get SQSMessage body in " + c.getSimpleName());
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        throw new JMSException("SQSMessage body is not assignable to " + c.getSimpleName());
    }

    private boolean isValidPropertyValueType(Object value) {
        return value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String;
    }

    public void setSequenceNumber(String sequenceNumber) throws JMSException {
        if (sequenceNumber == null || sequenceNumber.isEmpty()) {
            this.properties.remove("JMS_SQS_SequenceNumber");
        } else {
            this.properties.put("JMS_SQS_SequenceNumber", new JMSMessagePropertyValue(sequenceNumber));
        }
    }

    void setWritePermissionsForProperties(boolean writePermissionsForProperties) {
        this.writePermissionsForProperties = writePermissionsForProperties;
    }

    public static class JMSMessagePropertyValue {
        private final Object value;
        private final String type;
        private final String stringMessageAttributeValue;

        public JMSMessagePropertyValue(String stringValue, String type) throws JMSException {
            this.type = type;
            this.value = JMSMessagePropertyValue.getObjectValue(stringValue, type);
            this.stringMessageAttributeValue = stringValue;
        }

        public JMSMessagePropertyValue(Object value) throws JMSException {
            this.type = JMSMessagePropertyValue.getType(value);
            this.value = value;
            this.stringMessageAttributeValue = "Number.Boolean".equals(this.type) ? (((Boolean)value).booleanValue() ? "1" : "0") : value.toString();
        }

        public JMSMessagePropertyValue(Object value, String type) throws JMSException {
            this.value = value;
            this.type = type;
            this.stringMessageAttributeValue = "Number.Boolean".equals(type) ? (((Boolean)value).booleanValue() ? "1" : "0") : value.toString();
        }

        private static String getType(Object value) throws JMSException {
            if (value instanceof String) {
                return "String";
            }
            if (value instanceof Integer) {
                return "Number.int";
            }
            if (value instanceof Long) {
                return "Number.long";
            }
            if (value instanceof Boolean) {
                return "Number.Boolean";
            }
            if (value instanceof Byte) {
                return "Number.byte";
            }
            if (value instanceof Double) {
                return "Number.double";
            }
            if (value instanceof Float) {
                return "Number.float";
            }
            if (value instanceof Short) {
                return "Number.short";
            }
            throw new JMSException("Not a supported JMS property type");
        }

        private static Object getObjectValue(String value, String type) throws JMSException {
            if ("Number.int".equals(type)) {
                return Integer.valueOf(value);
            }
            if ("Number.long".equals(type)) {
                return Long.valueOf(value);
            }
            if ("Number.Boolean".equals(type)) {
                if ("1".equals(value)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("Number.byte".equals(type)) {
                return Byte.valueOf(value);
            }
            if ("Number.double".equals(type)) {
                return Double.valueOf(value);
            }
            if ("Number.float".equals(type)) {
                return Float.valueOf(value);
            }
            if ("Number.short".equals(type)) {
                return Short.valueOf(value);
            }
            if (type != null && (type.startsWith("String") || type.startsWith("Number"))) {
                return value;
            }
            throw new JMSException(type + " is not a supported JMS property type");
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String getStringMessageAttributeValue() {
            return this.stringMessageAttributeValue;
        }
    }

    public static class TypeConversionSupport {
        private static final Map<ConversionKey, Converter> CONVERSION_MAP = new HashMap<ConversionKey, Converter>();

        public static <T> T convert(Object value, Class<T> clazz) {
            assert (value != null && clazz != null);
            if (value.getClass() == clazz) {
                return (T)value;
            }
            Converter c = CONVERSION_MAP.get(new ConversionKey(value.getClass(), clazz));
            if (c == null) {
                return null;
            }
            return (T)c.convert(value);
        }

        static {
            Converter toStringConverter = Object::toString;
            CONVERSION_MAP.put(new ConversionKey(Boolean.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Byte.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Short.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Integer.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Long.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Float.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(Double.class, String.class), toStringConverter);
            CONVERSION_MAP.put(new ConversionKey(String.class, Boolean.class), value -> {
                String stringValue = (String)value;
                if (Boolean.parseBoolean(stringValue) || "1".equals(value)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
            CONVERSION_MAP.put(new ConversionKey(String.class, Byte.class), value -> Byte.valueOf((String)value));
            CONVERSION_MAP.put(new ConversionKey(String.class, Short.class), value -> Short.valueOf((String)value));
            CONVERSION_MAP.put(new ConversionKey(String.class, Integer.class), value -> Integer.valueOf((String)value));
            CONVERSION_MAP.put(new ConversionKey(String.class, Long.class), value -> Long.valueOf((String)value));
            CONVERSION_MAP.put(new ConversionKey(String.class, Float.class), value -> Float.valueOf((String)value));
            CONVERSION_MAP.put(new ConversionKey(String.class, Double.class), value -> Double.valueOf((String)value));
            Converter longConverter = value -> ((Number)value).longValue();
            CONVERSION_MAP.put(new ConversionKey(Byte.class, Long.class), longConverter);
            CONVERSION_MAP.put(new ConversionKey(Short.class, Long.class), longConverter);
            CONVERSION_MAP.put(new ConversionKey(Integer.class, Long.class), longConverter);
            CONVERSION_MAP.put(new ConversionKey(Date.class, Long.class), value -> ((Date)value).getTime());
            Converter intConverter = value -> ((Number)value).intValue();
            CONVERSION_MAP.put(new ConversionKey(Byte.class, Integer.class), intConverter);
            CONVERSION_MAP.put(new ConversionKey(Short.class, Integer.class), intConverter);
            CONVERSION_MAP.put(new ConversionKey(Byte.class, Short.class), value -> ((Number)value).shortValue());
            CONVERSION_MAP.put(new ConversionKey(Float.class, Double.class), value -> ((Number)value).doubleValue());
        }

        record ConversionKey(Class<?> from, Class<?> to) {
            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ConversionKey other = (ConversionKey)obj;
                if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                    return false;
                }
                if (this.to == null) {
                    return other.to == null;
                }
                return this.to.equals(other.to);
            }
        }

        static interface Converter {
            public Object convert(Object var1);
        }
    }

    private record PropertyEnum(Iterator<String> propertyItr) implements Enumeration<String>
    {
        @Override
        public boolean hasMoreElements() {
            return this.propertyItr.hasNext();
        }

        @Override
        public String nextElement() {
            return this.propertyItr.next();
        }
    }
}

