/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSMessagingClientConstants;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.acknowledge.AcknowledgeMode;
import com.amazonaws.services.sqs.AmazonSQS;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSConnection
implements Connection,
QueueConnection {
    private static final Log LOG = LogFactory.getLog(SQSConnection.class);
    private ExceptionListener exceptionListener;
    private String clientID;
    private final Object stateLock = new Object();
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final int numberOfMessagesToPrefetch;
    private volatile boolean closed = false;
    private volatile boolean closing = false;
    private volatile boolean running = false;
    private volatile boolean actionOnConnectionTaken = false;
    private final Set<Session> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    SQSConnection(AmazonSQSMessagingClientWrapper amazonSQSClientJMSWrapper, int numberOfMessagesToPrefetch) {
        this.amazonSQSClient = amazonSQSClientJMSWrapper;
        this.numberOfMessagesToPrefetch = numberOfMessagesToPrefetch;
    }

    public AmazonSQS getAmazonSQSClient() {
        return this.amazonSQSClient.getAmazonSQSClient();
    }

    public AmazonSQSMessagingClientWrapper getWrappedAmazonSQSClient() {
        return this.amazonSQSClient;
    }

    int getNumberOfMessagesToPrefetch() {
        return this.numberOfMessagesToPrefetch;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, acknowledgeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        SQSSession sqsSession;
        this.checkClosed();
        this.actionOnConnectionTaken = true;
        if (transacted || acknowledgeMode == 0) {
            throw new JMSException("SQSSession does not support transacted");
        }
        if (acknowledgeMode == 1) {
            sqsSession = new SQSSession(this, AcknowledgeMode.ACK_AUTO.withOriginalAcknowledgeMode(acknowledgeMode));
        } else if (acknowledgeMode == 2 || acknowledgeMode == 3) {
            sqsSession = new SQSSession(this, AcknowledgeMode.ACK_RANGE.withOriginalAcknowledgeMode(acknowledgeMode));
        } else if (acknowledgeMode == 100) {
            sqsSession = new SQSSession(this, AcknowledgeMode.ACK_UNORDERED.withOriginalAcknowledgeMode(acknowledgeMode));
        } else {
            LOG.error((Object)"Unrecognized acknowledgeMode. Cannot create Session.");
            throw new JMSException("Unrecognized acknowledgeMode. Cannot create Session.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.closing) {
                sqsSession.close();
                throw new IllegalStateException("Connection is closed or closing");
            }
            this.sessions.add(sqsSession);
            if (this.running) {
                sqsSession.start();
            }
        }
        return sqsSession;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosing();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosing();
        this.actionOnConnectionTaken = true;
        this.exceptionListener = listener;
    }

    public void checkClosing() throws IllegalStateException {
        if (this.closing) {
            throw new IllegalStateException("Connection is closed or closing");
        }
    }

    public void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        this.actionOnConnectionTaken = true;
        if (this.running) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            if (!this.running) {
                try {
                    for (Session session : this.sessions) {
                        SQSSession sqsSession = (SQSSession)session;
                        sqsSession.start();
                    }
                }
                finally {
                    this.running = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.checkClosed();
        if (!this.running) {
            return;
        }
        this.actionOnConnectionTaken = true;
        if (SQSSession.SESSION_THREAD_FACTORY.wasThreadCreatedWithThisThreadGroup(Thread.currentThread())) {
            throw new IllegalStateException("MessageListener must not attempt to stop its own Connection to prevent potential deadlock issues");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkClosing();
            if (this.running) {
                try {
                    for (Session session : this.sessions) {
                        SQSSession sqsSession = (SQSSession)session;
                        sqsSession.stop();
                    }
                }
                finally {
                    this.running = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (SQSSession.SESSION_THREAD_FACTORY.wasThreadCreatedWithThisThreadGroup(Thread.currentThread())) {
            throw new IllegalStateException("MessageListener must not attempt to close its own Connection to prevent potential deadlock issues");
        }
        boolean shouldClose = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.closing) {
                shouldClose = true;
                this.closing = true;
            }
        }
        if (shouldClose) {
            object = this.stateLock;
            synchronized (object) {
                try {
                    for (Session session : this.sessions) {
                        SQSSession sqsSession = (SQSSession)session;
                        sqsSession.close();
                    }
                    this.sessions.clear();
                }
                finally {
                    this.closed = true;
                    this.stateLock.notifyAll();
                }
            }
        }
        object = this.stateLock;
        synchronized (object) {
            while (!this.closed) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Interrupted while waiting the session to close.", (Throwable)e);
                }
            }
        }
    }

    void removeSession(Session session) throws JMSException {
        this.sessions.remove(session);
    }

    public String getClientID() throws JMSException {
        this.checkClosing();
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkClosing();
        if (clientID == null || clientID.isEmpty()) {
            throw new InvalidClientIDException("ClientID is empty");
        }
        if (this.clientID != null) {
            throw new IllegalStateException("ClientID is already set");
        }
        if (this.actionOnConnectionTaken) {
            throw new IllegalStateException("Client ID cannot be set after any action on the connection is taken");
        }
        this.clientID = clientID;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosing();
        return SQSMessagingClientConstants.CONNECTION_METADATA;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setClosing(boolean closing) {
        this.closing = closing;
    }

    void setRunning(boolean running) {
        this.running = running;
    }

    boolean isRunning() {
        return this.running;
    }

    void setActionOnConnectionTaken(boolean actionOnConnectionTaken) {
        this.actionOnConnectionTaken = actionOnConnectionTaken;
    }

    boolean isActionOnConnectionTaken() {
        return this.actionOnConnectionTaken;
    }

    Set<Session> getSessions() {
        return this.sessions;
    }

    Object getStateLock() {
        return this.stateLock;
    }
}

