/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class UnorderedAcknowledger
implements Acknowledger {
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final SQSSession session;
    private final Map<String, SQSMessageIdentifier> unAckMessages;

    public UnorderedAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient, SQSSession session) {
        this.amazonSQSClient = amazonSQSClient;
        this.session = session;
        this.unAckMessages = new HashMap<String, SQSMessageIdentifier>();
    }

    @Override
    public void acknowledge(SQSMessage message) throws JMSException {
        this.session.checkClosed();
        this.amazonSQSClient.deleteMessage(new DeleteMessageRequest(message.getQueueUrl(), message.getReceiptHandle()));
        this.unAckMessages.remove(message.getReceiptHandle());
    }

    @Override
    public void notifyMessageReceived(SQSMessage message) throws JMSException {
        SQSMessageIdentifier messageIdentifier = new SQSMessageIdentifier(message.getQueueUrl(), message.getReceiptHandle(), message.getSQSMessageId());
        this.unAckMessages.put(message.getReceiptHandle(), messageIdentifier);
    }

    @Override
    public List<SQSMessageIdentifier> getUnAckMessages() {
        return new ArrayList<SQSMessageIdentifier>(this.unAckMessages.values());
    }

    @Override
    public void forgetUnAckMessages() {
        this.unAckMessages.clear();
    }
}

