/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSMessagingClientConstants;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class SQSConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory {
    private final ClientConfiguration clientConfig;
    private final Region region;
    private final String endpoint;
    private final String signerRegionOverride;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final int numberOfMessagesToPrefetch;

    private SQSConnectionFactory(Builder builder) {
        this.region = builder.region;
        this.endpoint = builder.endpoint;
        this.signerRegionOverride = builder.signerRegionOverride;
        this.clientConfig = builder.clientConfiguration;
        this.awsCredentialsProvider = builder.awsCredentialsProvider;
        this.numberOfMessagesToPrefetch = builder.numberOfMessagesToPrefetch;
    }

    public SQSConnection createConnection() throws JMSException {
        if (this.awsCredentialsProvider == null) {
            throw new JMSSecurityException("AWS credentials cannot be null");
        }
        return this.createConnection(this.awsCredentialsProvider);
    }

    public SQSConnection createConnection(String awsAccessKeyId, String awsSecretKey) throws JMSException {
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretKey);
        return this.createConnection((AWSCredentials)basicAWSCredentials);
    }

    public SQSConnection createConnection(AWSCredentials awsCredentials) throws JMSException {
        AmazonSQSClient amazonSQSClient = new AmazonSQSClient(awsCredentials, this.clientConfig);
        this.configureClient(amazonSQSClient);
        AmazonSQSMessagingClientWrapper amazonSQSClientJMSWrapper = new AmazonSQSMessagingClientWrapper((AmazonSQS)amazonSQSClient);
        return new SQSConnection(amazonSQSClientJMSWrapper, this.numberOfMessagesToPrefetch);
    }

    public SQSConnection createConnection(AWSCredentialsProvider awsCredentialsProvider) throws JMSException {
        AmazonSQSClient amazonSQSClient = new AmazonSQSClient(awsCredentialsProvider, this.clientConfig);
        this.configureClient(amazonSQSClient);
        AmazonSQSMessagingClientWrapper amazonSQSClientJMSWrapper = new AmazonSQSMessagingClientWrapper((AmazonSQS)amazonSQSClient);
        return new SQSConnection(amazonSQSClientJMSWrapper, this.numberOfMessagesToPrefetch);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void configureClient(AmazonSQSClient client) throws JMSException {
        try {
            if (this.region != null) {
                client.setRegion(this.region);
            }
            if (this.endpoint != null) {
                client.setEndpoint(this.endpoint);
            }
            if (this.signerRegionOverride != null) {
                client.setSignerRegionOverride(this.signerRegionOverride);
            }
        }
        catch (IllegalArgumentException e) {
            throw (JMSException)new JMSException("Bad endpoint configuration: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    public static class Builder {
        private Region region;
        private String endpoint;
        private String signerRegionOverride;
        private ClientConfiguration clientConfiguration;
        private int numberOfMessagesToPrefetch;
        private AWSCredentialsProvider awsCredentialsProvider = new DefaultAWSCredentialsProviderChain();

        public Builder(Region region) {
            this();
            this.region = region;
        }

        public Builder(String region) {
            this(Region.getRegion((Regions)Regions.fromName((String)region)));
        }

        public Builder() {
            this.clientConfiguration = new ClientConfiguration();
            this.clientConfiguration.setUserAgent(this.clientConfiguration.getUserAgent() + SQSMessagingClientConstants.APPENDED_USER_AGENT_HEADER_VERSION);
            this.numberOfMessagesToPrefetch = 1;
        }

        public Builder withRegion(Region region) {
            this.setRegion(region);
            return this;
        }

        public Builder withRegionName(String regionName) throws IllegalArgumentException {
            this.setRegion(Region.getRegion((Regions)Regions.fromName((String)regionName)));
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.setEndpoint(endpoint);
            return this;
        }

        public Builder withSignerRegionOverride(String signerRegionOverride) {
            this.setSignerRegionOverride(signerRegionOverride);
            return this;
        }

        public Builder withAWSCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this.setAwsCredentialsProvider(awsCredentialsProvider);
            return this;
        }

        public Builder withClientConfiguration(ClientConfiguration clientConfig) {
            this.setClientConfiguration(clientConfig);
            return this;
        }

        public Builder withNumberOfMessagesToPrefetch(int numberOfMessagesToPrefetch) {
            this.setNumberOfMessagesToPrefetch(numberOfMessagesToPrefetch);
            return this;
        }

        public SQSConnectionFactory build() {
            return new SQSConnectionFactory(this);
        }

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
            this.endpoint = null;
        }

        public void setRegionName(String regionName) {
            this.setRegion(Region.getRegion((Regions)Regions.fromName((String)regionName)));
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.region = null;
        }

        public String getSignerRegionOverride() {
            return this.signerRegionOverride;
        }

        public void setSignerRegionOverride(String signerRegionOverride) {
            this.signerRegionOverride = signerRegionOverride;
        }

        public ClientConfiguration getClientConfiguration() {
            return this.clientConfiguration;
        }

        public void setClientConfiguration(ClientConfiguration clientConfig) {
            this.clientConfiguration = new ClientConfiguration(clientConfig);
            if (clientConfig.getUserAgent() == null || clientConfig.getUserAgent().isEmpty()) {
                clientConfig.setUserAgent(ClientConfiguration.DEFAULT_USER_AGENT);
            }
            this.clientConfiguration.setUserAgent(clientConfig.getUserAgent() + SQSMessagingClientConstants.APPENDED_USER_AGENT_HEADER_VERSION);
        }

        public int getNumberOfMessagesToPrefetch() {
            return this.numberOfMessagesToPrefetch;
        }

        public void setNumberOfMessagesToPrefetch(int numberOfMessagesToPrefetch) {
            if (numberOfMessagesToPrefetch <= 0) {
                throw new IllegalArgumentException("Invalid prefetch size.");
            }
            this.numberOfMessagesToPrefetch = numberOfMessagesToPrefetch;
        }

        public AWSCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        public void setAwsCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
        }
    }
}

