/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.util.StringUtils;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.payloadoffloading.PayloadStorageConfiguration;

@NotThreadSafe
public class ExtendedClientConfiguration
extends PayloadStorageConfiguration {
    private static final Log LOG = LogFactory.getLog(ExtendedClientConfiguration.class);
    private static final int UUID_LENGTH = 36;
    private static final int MAX_S3_KEY_LENGTH = 1024;
    private static final int MAX_S3_KEY_PREFIX_LENGTH = 988;
    private static final Pattern INVALID_S3_PREFIX_KEY_CHARACTERS_PATTERN = Pattern.compile("[^a-zA-Z0-9./_-]");
    private boolean cleanupS3Payload = true;
    private boolean useLegacyReservedAttributeName = true;
    private boolean ignorePayloadNotFound = false;
    private String s3KeyPrefix = "";

    public ExtendedClientConfiguration() {
        this.setPayloadSizeThreshold(262144);
    }

    public ExtendedClientConfiguration(ExtendedClientConfiguration other) {
        super((PayloadStorageConfiguration)other);
        this.cleanupS3Payload = other.doesCleanupS3Payload();
        this.useLegacyReservedAttributeName = other.usesLegacyReservedAttributeName();
        this.ignorePayloadNotFound = other.ignoresPayloadNotFound();
        this.s3KeyPrefix = other.getS3KeyPrefix();
    }

    public void setPayloadSupportEnabled(AmazonS3 s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        this.cleanupS3Payload = cleanupS3Payload;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(AmazonS3 s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName, cleanupS3Payload);
        return this;
    }

    public void setLegacyReservedAttributeNameDisabled() {
        this.useLegacyReservedAttributeName = false;
    }

    public ExtendedClientConfiguration withLegacyReservedAttributeNameDisabled() {
        this.setLegacyReservedAttributeNameDisabled();
        return this;
    }

    public void setIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.ignorePayloadNotFound = ignorePayloadNotFound;
    }

    public ExtendedClientConfiguration withIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.setIgnorePayloadNotFound(ignorePayloadNotFound);
        return this;
    }

    public boolean doesCleanupS3Payload() {
        return this.cleanupS3Payload;
    }

    public boolean usesLegacyReservedAttributeName() {
        return this.useLegacyReservedAttributeName;
    }

    public boolean ignoresPayloadNotFound() {
        return this.ignorePayloadNotFound;
    }

    public void setS3KeyPrefix(String s3KeyPrefix) {
        String trimmedPrefix = StringUtils.trim((String)s3KeyPrefix);
        if (trimmedPrefix == null) {
            this.s3KeyPrefix = "";
            return;
        }
        if (trimmedPrefix.length() > 988) {
            String errorMessage = "The S3 key prefix length must not be greater than 988";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (trimmedPrefix.startsWith(".") || trimmedPrefix.startsWith("/")) {
            String errorMessage = "The S3 key prefix must not starts with '.' or '/'";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (trimmedPrefix.contains("..")) {
            String errorMessage = "The S3 key prefix must not contains the string '..'";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (INVALID_S3_PREFIX_KEY_CHARACTERS_PATTERN.matcher(trimmedPrefix).find()) {
            String errorMessage = "The S3 key prefix contain invalid characters. The allowed characters are: letters, digits, '/', '_', '-', and '.'";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        this.s3KeyPrefix = trimmedPrefix;
    }

    public ExtendedClientConfiguration withS3KeyPrefix(String s3KeyPrefix) {
        this.setS3KeyPrefix(s3KeyPrefix);
        return this;
    }

    public String getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public ExtendedClientConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public ExtendedClientConfiguration withSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sseAwsKeyManagementParams) {
        this.setSSEAwsKeyManagementParams(sseAwsKeyManagementParams);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public ExtendedClientConfiguration withCannedAccessControlList(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAccessControlList(cannedAccessControlList);
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setLargePayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportDisabled() {
        this.setLargePayloadSupportDisabled();
        return this;
    }

    @Deprecated
    public boolean isLargePayloadSupportEnabled() {
        return this.isPayloadSupportEnabled();
    }

    @Deprecated
    public void setMessageSizeThreshold(int messageSizeThreshold) {
        this.setPayloadSizeThreshold(messageSizeThreshold);
    }

    @Deprecated
    public ExtendedClientConfiguration withMessageSizeThreshold(int messageSizeThreshold) {
        this.setMessageSizeThreshold(messageSizeThreshold);
        return this;
    }

    @Deprecated
    public int getMessageSizeThreshold() {
        return this.getPayloadSizeThreshold();
    }
}

