/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.Checkpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisDataFetcher;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.StreamConfig;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class InitializeTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(InitializeTask.class);
    private static final String RECORD_PROCESSOR_INITIALIZE_METRIC = "RecordProcessor.initialize";
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final KinesisDataFetcher dataFetcher;
    private final TaskType taskType = TaskType.INITIALIZE;
    private final ICheckpoint checkpoint;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final long backoffTimeMillis;
    private final StreamConfig streamConfig;

    InitializeTask(ShardInfo shardInfo, IRecordProcessor recordProcessor, ICheckpoint checkpoint, RecordProcessorCheckpointer recordProcessorCheckpointer, KinesisDataFetcher dataFetcher, long backoffTimeMillis, StreamConfig streamConfig) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.checkpoint = checkpoint;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.dataFetcher = dataFetcher;
        this.backoffTimeMillis = backoffTimeMillis;
        this.streamConfig = streamConfig;
    }

    @Override
    public TaskResult call() {
        boolean applicationException = false;
        Exception exception = null;
        try {
            LOG.debug((Object)("Initializing ShardId " + this.shardInfo.getShardId()));
            Checkpoint initialCheckpointObject = this.checkpoint.getCheckpointObject(this.shardInfo.getShardId());
            ExtendedSequenceNumber initialCheckpoint = initialCheckpointObject.getCheckpoint();
            this.dataFetcher.initialize(initialCheckpoint.getSequenceNumber(), this.streamConfig.getInitialPositionInStream());
            this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue(initialCheckpoint);
            this.recordProcessorCheckpointer.setInitialCheckpointValue(initialCheckpoint);
            LOG.debug((Object)"Calling the record processor initialize().");
            InitializationInput initializationInput = new InitializationInput().withShardId(this.shardInfo.getShardId()).withExtendedSequenceNumber(initialCheckpoint).withPendingCheckpointSequenceNumber(initialCheckpointObject.getPendingCheckpoint());
            long recordProcessorStartTimeMillis = System.currentTimeMillis();
            try {
                this.recordProcessor.initialize(initializationInput);
                LOG.debug((Object)"Record processor initialize() completed.");
            }
            catch (Exception e) {
                applicationException = true;
                throw e;
            }
            finally {
                MetricsHelper.addLatency(RECORD_PROCESSOR_INITIALIZE_METRIC, recordProcessorStartTimeMillis, MetricsLevel.SUMMARY);
            }
            return new TaskResult(null);
        }
        catch (Exception e) {
            if (applicationException) {
                LOG.error((Object)"Application initialize() threw exception: ", (Throwable)e);
            } else {
                LOG.error((Object)"Caught exception: ", (Throwable)e);
            }
            exception = e;
            try {
                Thread.sleep(this.backoffTimeMillis);
            }
            catch (InterruptedException ie) {
                LOG.debug((Object)"Interrupted sleep", (Throwable)ie);
            }
            return new TaskResult(exception);
        }
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }
}

