/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.clientlibrary.config.IPropertyValueDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AWSCredentialsProviderPropertyValueDecoder
implements IPropertyValueDecoder<AWSCredentialsProvider> {
    private static final Log LOG = LogFactory.getLog(AWSCredentialsProviderPropertyValueDecoder.class);
    private static final String AUTH_PREFIX = "com.amazonaws.auth.";
    private static final String LIST_DELIMITER = ",";

    AWSCredentialsProviderPropertyValueDecoder() {
    }

    @Override
    public AWSCredentialsProvider decodeValue(String value) {
        if (value != null) {
            List<String> providerNames = AWSCredentialsProviderPropertyValueDecoder.getProviderNames(value);
            List<AWSCredentialsProvider> providers = AWSCredentialsProviderPropertyValueDecoder.getValidCredentialsProviders(providerNames);
            AWSCredentialsProvider[] ps = new AWSCredentialsProvider[providers.size()];
            providers.toArray(ps);
            return new AWSCredentialsProviderChain(ps);
        }
        throw new IllegalArgumentException("Property AWSCredentialsProvider is missing.");
    }

    @Override
    public List<Class<AWSCredentialsProvider>> getSupportedTypes() {
        return Arrays.asList(AWSCredentialsProvider.class);
    }

    private static List<AWSCredentialsProvider> getValidCredentialsProviders(List<String> providerNames) {
        ArrayList<AWSCredentialsProvider> credentialsProviders = new ArrayList<AWSCredentialsProvider>();
        for (String providerName : providerNames) {
            try {
                Class<?> className = Class.forName(providerName);
                credentialsProviders.add((AWSCredentialsProvider)className.newInstance());
            }
            catch (Exception e) {
                LOG.debug((Object)("Can't find any credentials provider matching " + providerName + "."));
            }
        }
        return credentialsProviders;
    }

    private static List<String> getProviderNames(String property) {
        String[] elements = property.split(LIST_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            String string = elements[i].trim();
            if (string.isEmpty()) continue;
            result.addAll(AWSCredentialsProviderPropertyValueDecoder.getPossibleFullClassNames(string));
        }
        return result;
    }

    private static List<String> getPossibleFullClassNames(String s) {
        return Arrays.asList(s, AUTH_PREFIX + s);
    }
}

