/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;

class MetricsCollectingTaskDecorator
implements ITask {
    private final ITask other;
    private IMetricsFactory factory;

    public MetricsCollectingTaskDecorator(ITask other, IMetricsFactory factory) {
        this.other = other;
        this.factory = factory;
    }

    @Override
    public TaskResult call() {
        String taskName = this.other.getClass().getSimpleName();
        MetricsHelper.startScope(this.factory, taskName);
        long startTimeMillis = System.currentTimeMillis();
        TaskResult result = this.other.call();
        MetricsHelper.addSuccessAndLatency(null, startTimeMillis, result.getException() == null);
        MetricsHelper.endScope();
        return result;
    }

    @Override
    public TaskType getTaskType() {
        return this.other.getTaskType();
    }
}

