/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.Driver;
import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.CachedQuery;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.ParameterList;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandlerBase;
import com.amazon.redshift.core.SqlCommand;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.jdbc.BatchResultHandler;
import com.amazon.redshift.jdbc.PreferQueryMode;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.jdbc.RedshiftResultSet;
import com.amazon.redshift.jdbc.RedshiftWarningWrapper;
import com.amazon.redshift.jdbc.ResultWrapper;
import com.amazon.redshift.jdbc.StatementCancelState;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class RedshiftStatementImpl
implements Statement,
BaseStatement {
    private static final String[] NO_RETURNING_COLUMNS = new String[0];
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS = Boolean.getBoolean("com.amazon.redshift.forceBinary");
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS;
    protected ArrayList<Query> batchStatements = null;
    protected ArrayList<ParameterList> batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    private final int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    protected int autoGeneratedKeys = 2;
    private volatile TimerTask cancelTimerTask = null;
    private static final AtomicReferenceFieldUpdater<RedshiftStatementImpl, TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RedshiftStatementImpl.class, TimerTask.class, "cancelTimerTask");
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private static final AtomicReferenceFieldUpdater<RedshiftStatementImpl, StatementCancelState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RedshiftStatementImpl.class, StatementCancelState.class, "statementState");
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected final BaseConnection connection;
    protected volatile RedshiftWarningWrapper warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected long timeout = 0L;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected volatile ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper generatedKeys = null;
    protected int mPrepareThreshold;
    protected int maxFieldSize = 0;
    private volatile boolean isClosed = false;

    RedshiftStatementImpl(RedshiftConnectionImpl c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.connection = c;
        this.forceBinaryTransfers |= c.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(c.getDefaultFetchSize());
        this.setPrepareThreshold(c.getPrepareThreshold());
        this.rsHoldability = rsHoldability;
    }

    @Override
    public ResultSet createResultSet(Query originalQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) throws SQLException {
        RedshiftResultSet newResult = new RedshiftResultSet(originalQuery, this, fields, tuples, cursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability(), queueTuples, rowCount, ringBufferThread);
        newResult.setFetchSize(this.getFetchSize());
        newResult.setFetchDirection(this.getFetchDirection());
        return newResult;
    }

    public BaseConnection getRedshiftConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    public void updateStatementCancleState(StatementCancelState oldState, StatementCancelState newState) {
        STATE_UPDATER.compareAndSet(this, oldState, newState);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql);
        }
        if (!this.executeWithFlags(sql, 0)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getSingleResultSet();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getSingleResultSet() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result.getNext() != null) {
                throw new RedshiftException(GT.tr("Multiple ResultSets were returned by the query.", new Object[0]), RedshiftState.TOO_MANY_RESULTS);
            }
            return this.result.getResultSet();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql);
        }
        this.executeWithFlags(sql, 4);
        this.checkNoResultUpdate();
        int rc = this.getUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkNoResultUpdate() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.autoGeneratedKeys == 2) {
                for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
                    if (iter.getResultSet() == null) continue;
                    throw new RedshiftException(GT.tr("A result was returned when none was expected.", new Object[0]), RedshiftState.TOO_MANY_RESULTS);
                }
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql);
        }
        boolean rc = this.executeWithFlags(sql, 0);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
        return rc;
    }

    @Override
    public boolean executeWithFlags(String sql, int flags) throws SQLException {
        return this.executeCachedSql(sql, flags, NO_RETURNING_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCachedSql(String sql, int flags, String[] columnNames) throws SQLException {
        boolean res;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        boolean shouldUseParameterized = false;
        QueryExecutor queryExecutor = this.connection.getQueryExecutor();
        Object key = queryExecutor.createQueryKey(sql, this.replaceProcessingEnabled, shouldUseParameterized, columnNames);
        boolean shouldCache = preferQueryMode == PreferQueryMode.EXTENDED_CACHE_EVERYTHING;
        CachedQuery cachedQuery = shouldCache ? queryExecutor.borrowQueryByKey(key) : queryExecutor.createQueryByKey(key);
        if (this.wantsGeneratedKeysOnce) {
            SqlCommand sqlCommand = cachedQuery.query.getSqlCommand();
            this.wantsGeneratedKeysOnce = sqlCommand != null && sqlCommand.isReturningKeywordPresent();
        }
        try {
            res = this.executeWithFlags(cachedQuery, flags);
        }
        finally {
            if (shouldCache) {
                queryExecutor.releaseQuery(cachedQuery);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(CachedQuery simpleQuery, int flags) throws SQLException {
        this.checkClosed();
        if (this.connection.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) < 0) {
            flags |= 0x400;
        }
        this.execute(simpleQuery, null, flags);
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            return this.result != null && this.result.getResultSet() != null;
        }
    }

    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        throw new RedshiftException(GT.tr("Can''t use executeWithFlags(int) on a Statement.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            while (this.firstUnclosedResult != null) {
                RedshiftResultSet rs = (RedshiftResultSet)this.firstUnclosedResult.getResultSet();
                if (rs != null) {
                    rs.closeInternally();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            this.result = null;
            if (this.generatedKeys != null) {
                if (this.generatedKeys.getResultSet() != null) {
                    this.generatedKeys.getResultSet().close();
                }
                this.generatedKeys = null;
            }
        }
    }

    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            return true;
        }
        cachedQuery.increaseExecuteCount();
        return (this.mPrepareThreshold == 0 || cachedQuery.getExecuteCount() < this.mPrepareThreshold) && !this.getForceBinaryTransfer();
    }

    protected final void execute(CachedQuery cachedQuery, ParameterList queryParameters, int flags) throws SQLException {
        try {
            this.executeInternal(cachedQuery, queryParameters, flags);
        }
        catch (SQLException e) {
            if (cachedQuery.query.getSubqueries() != null || !this.connection.getQueryExecutor().willHealOnRetry(e)) {
                throw e;
            }
            cachedQuery.query.close();
            this.executeInternal(cachedQuery, queryParameters, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(CachedQuery cachedQuery, ParameterList queryParameters, int flags) throws SQLException {
        Query queryToExecute;
        this.closeForNextExecution();
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            flags |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((flags |= 0x40) & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        if (this.isOneShotQuery(cachedQuery)) {
            flags |= 1;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (this.connection.hintReadOnly()) {
            flags |= 0x800;
        }
        if (this.concurrency != 1007) {
            flags |= 0x100;
        }
        if ((queryToExecute = cachedQuery.query).isEmpty()) {
            flags |= 0x10;
        }
        if (!queryToExecute.isStatementDescribed() && this.forceBinaryTransfers && (flags & 0x400) == 0) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler(this);
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        StatementResultHandler handler = new StatementResultHandler(this);
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.result = null;
        }
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask(this.connection.getQueryExecutor().isRingBufferThreadRunning());
        }
        redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            this.result = this.firstUnclosedResult = handler.getResults();
            if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
                if (this.result.getNext() != null) {
                    this.generatedKeys = this.result;
                    this.result = this.result.getNext();
                } else {
                    this.generatedKeys = null;
                }
                if (this.wantsGeneratedKeysOnce) {
                    this.wantsGeneratedKeysOnce = false;
                }
            }
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result == null || this.result.getResultSet() != null) {
                return -1;
            }
            long count = this.result.getUpdateCount();
            int n = count > Integer.MAX_VALUE ? -2 : (int)count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result == null) {
                return false;
            }
            this.result = this.result.getNext();
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            return this.result != null && this.result.getResultSet() != null;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, max);
        }
        this.checkClosed();
        if (max < 0) {
            throw new RedshiftException(GT.tr("Maximum number of rows must be a value grater than or equal to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, enable);
        }
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        long seconds = this.timeout / 1000L;
        if (seconds >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, seconds);
        }
        this.setQueryTimeoutMs((long)seconds * 1000L);
    }

    public long getQueryTimeoutMs() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeoutMs(long millis) throws SQLException {
        this.checkClosed();
        if (millis < 0L) {
            throw new RedshiftException(GT.tr("Query timeout must be a value greater than or equals to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = millis;
    }

    public void addWarning(SQLWarning warn) {
        RedshiftWarningWrapper warnWrap = this.warnings;
        if (warnWrap == null) {
            this.warnings = new RedshiftWarningWrapper(warn);
        } else {
            warnWrap.addWarning(warn);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        RedshiftWarningWrapper warnWrap = this.warnings;
        return warnWrap != null ? warnWrap.getFirstWarning() : null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, max);
        }
        this.checkClosed();
        if (max < 0) {
            throw new RedshiftException(GT.tr("The maximum field size must be a value greater than or equal to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.maxFieldSize = max;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result == null) {
                return null;
            }
            return this.result.getResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            if (this.isClosed) {
                if (RedshiftLogger.isEnable()) {
                    this.connection.getLogger().logFunction(false, new Object[0]);
                }
                return;
            }
            this.isClosed = true;
        }
        this.cancel();
        this.closeForNextExecution();
        this.closeImpl();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
            this.connection.getLogger().flush();
        }
    }

    protected void closeImpl() throws SQLException {
        this.connection.getQueryExecutor().closeStatementAndPortal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastOID() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result == null) {
                return 0L;
            }
            return this.result.getInsertOID();
        }
    }

    @Override
    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            this.forceBinaryTransfers = true;
            newThreshold = 1;
        }
        this.mPrepareThreshold = newThreshold;
    }

    @Override
    public int getPrepareThreshold() {
        return this.mPrepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    @Override
    public boolean isUseServerPrepare() {
        return false;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new RedshiftException(GT.tr("This statement has been closed.", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql);
        }
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        boolean shouldUseParameterized = false;
        CachedQuery cachedQuery = this.connection.createQuery(sql, this.replaceProcessingEnabled, shouldUseParameterized, new String[0]);
        this.batchStatements.add(cachedQuery.query);
        this.batchParameters.add(null);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new BatchResultHandler(this, queries, parameterLists, this.wantsGeneratedKeysAlways);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchResultHandler internalExecuteBatch() throws SQLException {
        boolean sameQueryAhead;
        this.transformQueriesAndParameters();
        Query[] queries = this.batchStatements.toArray(new Query[0]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[0]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        boolean preDescribe = false;
        int flags = this.wantsGeneratedKeysAlways ? 320 : 4;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        if (preferQueryMode == PreferQueryMode.SIMPLE || preferQueryMode == PreferQueryMode.EXTENDED_FOR_PREPARED && parameterLists[0] == null) {
            flags |= 0x400;
        }
        boolean bl = sameQueryAhead = queries.length > 1 && queries[0] == queries[1];
        if (!sameQueryAhead || this.isOneShotQuery(null)) {
            flags |= 1;
        } else {
            preDescribe = (this.wantsGeneratedKeysAlways || sameQueryAhead) && !queries[0].isStatementDescribed();
            flags |= 0x200;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (this.connection.hintReadOnly()) {
            flags |= 0x800;
        }
        BatchResultHandler handler = this.createBatchHandler(queries, parameterLists);
        if ((preDescribe || this.forceBinaryTransfers) && (flags & 0x400) == 0) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler(this);
            try {
                this.connection.getQueryExecutor().execute(queries[0], parameterLists[0], handler2, 0, 0, flags2);
            }
            catch (SQLException e) {
                handler.handleError(e);
                handler.handleCompletion();
            }
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.result = null;
        }
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queries, parameterLists, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask(this.connection.getQueryExecutor().isRingBufferThreadRunning());
            redshiftStatementImpl = this;
            synchronized (redshiftStatementImpl) {
                this.checkClosed();
                if (this.wantsGeneratedKeysAlways) {
                    this.generatedKeys = new ResultWrapper(handler.getGeneratedKeys());
                }
            }
        }
        return handler;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        this.closeForNextExecution();
        int[] rc = this.batchStatements == null || this.batchStatements.isEmpty() ? new int[]{} : this.internalExecuteBatch().getUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[]{rc});
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        if (this.statementState == StatementCancelState.IDLE) {
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logError("statementState is StatementCancelState.IDLE", new Object[0]);
                this.connection.getLogger().logFunction(false, new Object[0]);
            }
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logError("statementState is not StatementCancelState.IN_QUERY", new Object[0]);
                this.connection.getLogger().logFunction(false, new Object[0]);
            }
            return;
        }
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.connection.cancelQuery();
            }
            finally {
                STATE_UPDATER.set(this, StatementCancelState.CANCELLED);
                this.connection.notifyAll();
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultsettype;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, direction);
        }
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new RedshiftException(GT.tr("Invalid fetch direction constant: {0}.", direction), RedshiftState.INVALID_PARAMETER_VALUE);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, rows);
        }
        this.checkClosed();
        if (rows < 0) {
            throw new RedshiftException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    private void startTimer() {
        this.cleanupTimer();
        STATE_UPDATER.set(this, StatementCancelState.IN_QUERY);
        if (this.timeout == 0L) {
            return;
        }
        TimerTask cancelTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!CANCEL_TIMER_UPDATER.compareAndSet(RedshiftStatementImpl.this, this, null)) {
                        return;
                    }
                    RedshiftStatementImpl.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        CANCEL_TIMER_UPDATER.set(this, cancelTask);
        this.connection.addTimerTask(cancelTask, this.timeout);
    }

    private boolean cleanupTimer() {
        TimerTask timerTask = CANCEL_TIMER_UPDATER.get(this);
        if (timerTask == null) {
            return this.timeout == 0L;
        }
        if (!CANCEL_TIMER_UPDATER.compareAndSet(this, timerTask, null)) {
            return false;
        }
        timerTask.cancel();
        this.connection.purgeTimerTasks();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask(boolean isRingBufferThreadRunning) {
        boolean timerTaskIsClear = this.cleanupTimer();
        if (timerTaskIsClear && isRingBufferThreadRunning) {
            return;
        }
        if (timerTaskIsClear && STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
            return;
        }
        if (timerTaskIsClear && STATE_UPDATER.get(this) == StatementCancelState.IDLE) {
            return;
        }
        boolean interrupted = false;
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            while (!STATE_UPDATER.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
                try {
                    this.connection.wait(10L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean getForceBinaryTransfer() {
        return this.forceBinaryTransfers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.result == null || this.result.getResultSet() != null) {
                return -1L;
            }
            return this.result.getUpdateCount();
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        this.closeForNextExecution();
        long[] rc = this.batchStatements == null || this.batchStatements.isEmpty() ? new long[]{} : this.internalExecuteBatch().getLargeUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[]{rc});
        }
        return rc;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql);
        }
        this.executeWithFlags(sql, 4);
        this.checkNoResultUpdate();
        long rc = this.getLargeUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, autoGeneratedKeys);
        }
        this.autoGeneratedKeys = autoGeneratedKeys;
        long rc = autoGeneratedKeys == 2 ? this.executeLargeUpdate(sql) : this.executeLargeUpdate(sql, (String[])null);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnIndexes);
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            long rc = this.executeLargeUpdate(sql);
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logFunction(false, rc);
            }
            return rc;
        }
        throw new RedshiftException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long rc;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnNames);
        }
        if (columnNames == null || columnNames.length == 0) {
            if (this.autoGeneratedKeys == 1) {
                this.wantsGeneratedKeysOnce = true;
            }
            rc = this.executeLargeUpdate(sql);
        } else {
            this.wantsGeneratedKeysOnce = true;
            if (!this.executeCachedSql(sql, 0, columnNames)) {
                // empty if block
            }
            rc = this.getLargeUpdateCount();
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, poolable);
        }
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        this.closeOnCompletion = true;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() throws SQLException {
        if (!this.closeOnCompletion) {
            return;
        }
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            for (ResultWrapper result = this.firstUnclosedResult; result != null; result = result.getNext()) {
                if (result.getResultSet() == null || result.getResultSet().isClosed()) continue;
                return;
            }
        }
        this.closeOnCompletion = false;
        try {
            this.close();
        }
        finally {
            this.closeOnCompletion = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (current == 1 && this.result != null && this.result.getResultSet() != null) {
                this.result.getResultSet().close();
            }
            if (this.result != null) {
                this.result = this.result.getNext();
            }
            if (current == 3) {
                while (this.firstUnclosedResult != this.result) {
                    if (this.firstUnclosedResult.getResultSet() != null) {
                        this.firstUnclosedResult.getResultSet().close();
                    }
                    this.firstUnclosedResult = this.firstUnclosedResult.getNext();
                }
            }
            return this.result != null && this.result.getResultSet() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        RedshiftStatementImpl redshiftStatementImpl = this;
        synchronized (redshiftStatementImpl) {
            this.checkClosed();
            if (this.generatedKeys == null || this.generatedKeys.getResultSet() == null) {
                return this.createDriverResultSet(new Field[0], new ArrayList<Tuple>());
            }
            return this.generatedKeys.getResultSet();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, autoGeneratedKeys);
        }
        this.autoGeneratedKeys = autoGeneratedKeys;
        int rc = autoGeneratedKeys == 2 ? this.executeUpdate(sql) : this.executeUpdate(sql, (String[])null);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnIndexes);
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            int rc = this.executeUpdate(sql);
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logFunction(false, rc);
            }
            return rc;
        }
        throw new RedshiftException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int rc;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnNames);
        }
        if (columnNames == null || columnNames.length == 0) {
            if (this.autoGeneratedKeys == 1) {
                this.wantsGeneratedKeysOnce = true;
            }
            rc = this.executeUpdate(sql);
        } else {
            this.wantsGeneratedKeysOnce = true;
            if (!this.executeCachedSql(sql, 0, columnNames)) {
                // empty if block
            }
            rc = this.getUpdateCount();
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, autoGeneratedKeys);
        }
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        return this.execute(sql, (String[])null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnIndexes);
        }
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new RedshiftException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), RedshiftState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean rc;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, sql, columnNames);
        }
        if (columnNames == null || columnNames.length == 0) {
            rc = this.execute(sql);
        } else {
            this.wantsGeneratedKeysOnce = true;
            rc = this.executeCachedSql(sql, 0, columnNames);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public ResultSet createDriverResultSet(Field[] fields, List<Tuple> tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null, null, null, null);
    }

    protected void transformQueriesAndParameters() throws SQLException {
    }

    public class StatementResultHandler
    extends ResultHandlerBase {
        private ResultWrapper results;
        private ResultWrapper lastResult;
        private Statement stmt;

        public StatementResultHandler(Statement stmt) {
            this.stmt = stmt;
        }

        @Override
        public void setStatementStateIdleFromInQuery() {
            ((RedshiftStatementImpl)this.stmt).updateStatementCancleState(StatementCancelState.IN_QUERY, StatementCancelState.IDLE);
        }

        @Override
        public void setStatementStateInQueryFromIdle() {
            ((RedshiftStatementImpl)this.stmt).updateStatementCancleState(StatementCancelState.IDLE, StatementCancelState.IN_QUERY);
        }

        @Override
        public boolean wantsScrollableResultSet() {
            return RedshiftStatementImpl.this.wantsScrollableResultSet();
        }

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.lastResult = this.results = newResult;
            } else {
                this.lastResult.append(newResult);
            }
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
            try {
                ResultSet rs = RedshiftStatementImpl.this.createResultSet(fromQuery, fields, tuples, cursor, queueTuples, rowCount, ringBufferThread);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        @Override
        public void handleCommandStatus(String status, long updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            RedshiftStatementImpl.this.addWarning(warning);
        }
    }
}

