/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.DriverInfo;
import com.amazon.redshift.util.ExpressionProperties;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.IniFile;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.SharedTimer;
import com.amazon.redshift.util.URLCoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Driver
implements java.sql.Driver {
    private static Driver registeredDriver;
    private static SharedTimer sharedTimer;
    private static final String DEFAULT_PORT = "5439";
    private static final String URL_PREFIX = "jdbc:redshift:";
    private static final Pattern URL_PATTERN;
    private static final Pattern HOST_PATTERN;
    private static final Pattern SERVERLESS_HOST_PATTERN;
    private static RedshiftLogger logger;
    private static final String DEFAULT_INI_FILE = "rsjdbc.ini";
    private static final String DEFAULT_DRIVER_SECTION = "DRIVER";
    private Properties defaultProperties;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            RedshiftProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            return merged;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("com/amazon/redshift/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith(URL_PREFIX)) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new RedshiftException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, RedshiftState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        String iniFileName = this.getJdbcIniFile(props);
        if (iniFileName != null) {
            props = this.readJdbcIniFile(iniFileName, props);
        }
        RedshiftLogger connLogger = null;
        try {
            long timeout;
            connLogger = this.getLogger(props);
            if (RedshiftLogger.isEnable()) {
                String temp = RedshiftLogger.maskSecureInfoInUrl(url);
                logger.log(LogLevel.DEBUG, "===================================", new Object[0]);
                logger.log(LogLevel.DEBUG, "Connecting with URL: {0}", temp);
                connLogger.log(LogLevel.DEBUG, "===================================", new Object[0]);
                connLogger.logFunction(true, temp, RedshiftLogger.maskSecureInfoInProps(info));
                connLogger.log(LogLevel.DEBUG, "Connecting with URL: {0}", temp);
                if (iniFileName != null) {
                    connLogger.log(LogLevel.DEBUG, "JDBC INI FileName {0}", iniFileName);
                }
            }
            if ((timeout = Driver.timeout(props)) <= 0L) {
                Connection conn = Driver.makeConnection(url, props, connLogger);
                if (RedshiftLogger.isEnable()) {
                    connLogger.logFunction(false, conn);
                }
                return conn;
            }
            ConnectThread ct = new ConnectThread(url, props, connLogger);
            Thread thread = new Thread((Runnable)ct, "Redshift JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            Connection conn = ct.getResult(timeout);
            if (RedshiftLogger.isEnable()) {
                connLogger.logFunction(false, conn);
            }
            return conn;
        }
        catch (RedshiftException ex1) {
            if (RedshiftLogger.isEnable()) {
                connLogger.logError(ex1);
            }
            throw ex1.getSQLException();
        }
        catch (AccessControlException ace) {
            if (RedshiftLogger.isEnable()) {
                connLogger.logError(ace);
            }
            throw new RedshiftException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            if (RedshiftLogger.isEnable()) {
                connLogger.logError(ex2);
            }
            throw new RedshiftException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private RedshiftLogger getLogger(Properties props) {
        String logLevel = RedshiftProperty.LOGGER_LEVEL.get(props);
        String alias1LogLevel = RedshiftProperty.LOG_LEVEL.get(props);
        String alias2LogLevel = RedshiftProperty.DSI_LOG_LEVEL.get(props);
        String driverLogLevel = logLevel != null ? logLevel : (alias1LogLevel != null ? LogLevel.getLogLevel(alias1LogLevel).toString() : (alias2LogLevel != null ? LogLevel.getLogLevel(alias2LogLevel).toString() : null));
        ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
        String logFile = RedshiftProperty.LOGGER_FILE.get(exprProps);
        String logPath = RedshiftProperty.LOG_PATH.get(exprProps);
        String driverLogFile = logFile != null ? logFile : RedshiftLogger.getLogFileUsingPath(driverLogLevel, logPath);
        String maxLogFileSize = RedshiftProperty.MAX_LOG_FILE_SIZE.get(exprProps);
        String maxLogFileCount = RedshiftProperty.MAX_LOG_FILE_COUNT.get(exprProps);
        if (logger == null) {
            logger = new RedshiftLogger(driverLogFile, driverLogLevel, true, maxLogFileSize, maxLogFileCount);
        }
        RedshiftLogger connLogger = new RedshiftLogger(driverLogFile, driverLogLevel, false, maxLogFileSize, maxLogFileCount);
        return connLogger;
    }

    private static Connection makeConnection(String url, Properties props, RedshiftLogger logger) throws SQLException {
        return new RedshiftConnectionImpl(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url, logger);
    }

    @Override
    public boolean acceptsURL(String url) {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        RedshiftProperty[] knownProperties = RedshiftProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return DriverInfo.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return DriverInfo.MINOR_VERSION;
    }

    @Deprecated
    public static String getVersion() {
        return DriverInfo.DRIVER_FULL_NAME;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static Properties parseURL(String url, Properties defaults) {
        String[] args;
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        boolean iamAuth = false;
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        } else {
            qPos = url.indexOf(59);
            if (qPos != -1) {
                urlServer = url.substring(0, qPos);
                urlArgs = url.substring(qPos + 1);
            }
        }
        if (!urlServer.startsWith(URL_PREFIX)) {
            return null;
        }
        if ((urlServer = urlServer.substring(URL_PREFIX.length())).startsWith("iam:")) {
            String subname = urlServer;
            Matcher matcher = URL_PATTERN.matcher(subname);
            if (!matcher.matches()) {
                return null;
            }
            iamAuth = matcher.group(1) != null;
            String host = matcher.group(2);
            String port = matcher.group(4);
            String[] schema = matcher.group(6);
            String queryString = matcher.group(8);
            urlProps.setProperty(RedshiftProperty.IAM_AUTH.getName(), String.valueOf(iamAuth));
            if (null != port && !port.matches("\\d*")) {
                urlProps.setProperty(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), host);
                urlProps.setProperty(RedshiftProperty.AWS_REGION.getName(), port);
            } else {
                urlProps.setProperty(RedshiftProperty.HOST.getName(), host);
                if (null == port || port.isEmpty()) {
                    port = DEFAULT_PORT;
                }
                urlProps.setProperty(RedshiftProperty.PORT.getName(), port);
                Matcher m = HOST_PATTERN.matcher(host);
                if (m.matches()) {
                    urlProps.setProperty(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), m.group(1));
                    urlProps.setProperty(RedshiftProperty.AWS_REGION.getName(), m.group(3));
                } else {
                    Matcher m2 = SERVERLESS_HOST_PATTERN.matcher(host);
                    if (m2.matches()) {
                        String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), urlProps);
                        String acctId = m2.group(1);
                        String region = m2.group(2);
                        if (awsRegion == null || awsRegion.length() == 0) {
                            urlProps.setProperty(RedshiftProperty.AWS_REGION.getName(), region);
                        }
                        urlProps.setProperty("isServerless", "true");
                        urlProps.setProperty("serverlessAcctId", acctId);
                    }
                }
            }
            if (null != schema) {
                urlProps.setProperty(RedshiftProperty.DBNAME.getName(), URLCoder.decode((String)schema));
            }
            if (queryString != null) {
                urlArgs = queryString;
            }
        } else {
            urlProps.setProperty(RedshiftProperty.IAM_AUTH.getName(), String.valueOf(iamAuth));
            if (urlServer.startsWith("//")) {
                int slash = (urlServer = urlServer.substring(2)).indexOf(47);
                if (slash == -1) {
                    return null;
                }
                urlProps.setProperty("DBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
                String[] addresses = urlServer.substring(0, slash).split(",");
                StringBuilder hosts = new StringBuilder();
                StringBuilder ports = new StringBuilder();
                for (String address : addresses) {
                    int portIdx = address.lastIndexOf(58);
                    if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                        String portStr = address.substring(portIdx + 1);
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                return null;
                            }
                        }
                        catch (NumberFormatException ignore) {
                            return null;
                        }
                        ports.append(portStr);
                        hosts.append(address.subSequence(0, portIdx));
                    } else {
                        ports.append(DEFAULT_PORT);
                        hosts.append(address);
                    }
                    ports.append(',');
                    hosts.append(',');
                }
                ports.setLength(ports.length() - 1);
                hosts.setLength(hosts.length() - 1);
                urlProps.setProperty("PORT", ports.toString());
                urlProps.setProperty("HOST", hosts.toString());
            } else {
                if (defaults == null || !defaults.containsKey("PORT")) {
                    urlProps.setProperty("PORT", DEFAULT_PORT);
                }
                if (defaults == null || !defaults.containsKey("HOST")) {
                    urlProps.setProperty("HOST", "localhost");
                }
                if (defaults == null || !defaults.containsKey("DBNAME")) {
                    urlProps.setProperty("DBNAME", URLCoder.decode(urlServer));
                }
            }
        }
        for (String token : args = urlArgs.split("[;&]")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), URLCoder.decode(token.substring(pos + 1)));
        }
        return urlProps;
    }

    public static HostSpec[] hostSpecs(Properties props) {
        HostSpec[] hostSpecs = null;
        String hostProp = props.getProperty("HOST");
        String portProp = props.getProperty("PORT");
        if (hostProp != null && portProp != null) {
            String[] hosts = hostProp.split(",");
            String[] ports = portProp.split(",");
            hostSpecs = new HostSpec[hosts.length];
            for (int i = 0; i < hostSpecs.length; ++i) {
                hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
            }
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        String user = props.getProperty("user");
        if (user == null) {
            user = props.getProperty("UID", "");
        }
        return user;
    }

    private static String database(Properties props) {
        return props.getProperty("DBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = RedshiftProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), RedshiftState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used");
    }

    public static SharedTimer getSharedTimer() {
        return sharedTimer;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    private String getJdbcIniFile(Properties props) throws RedshiftException {
        String fileName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.INI_FILE.getName(), props);
        if (!this.isFileExist(fileName, true) && !this.isFileExist(fileName = System.getenv("AMAZON_REDSHIFT_JDBC_INI_FILE"), true)) {
            String filePath = Driver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            fileName = this.getIniFullFileName(filePath = filePath.substring(0, filePath.lastIndexOf("/")));
            if (!(this.isFileExist(fileName, false) || this.isFileExist(fileName = this.getIniFullFileName(filePath = System.getProperty("user.home")), false) || this.isFileExist(fileName = this.getIniFullFileName(filePath = System.getProperty("java.io.tmpdir")), false))) {
                fileName = null;
            }
        }
        return fileName;
    }

    private String getIniFullFileName(String filePath) {
        String fileName = null;
        if (filePath != null && filePath.length() > 0) {
            fileName = filePath + File.separator + DEFAULT_INI_FILE;
        }
        return fileName;
    }

    private boolean isFileExist(String fileName, boolean fileMustExist) throws RedshiftException {
        boolean fileExist = false;
        if (fileName != null && fileName.length() > 0) {
            File file = new File(fileName);
            if (!file.exists()) {
                if (fileMustExist) {
                    throw new RedshiftException(GT.tr("JDBC INI file doesn't exist: ", new Object[0]) + fileName, RedshiftState.UNEXPECTED_ERROR);
                }
            } else {
                fileExist = true;
            }
        }
        return fileExist;
    }

    private Properties readJdbcIniFile(String fileName, Properties props) throws RedshiftException {
        String connectionSectionName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.INI_SECTION.getName(), props);
        String driverSectionName = DEFAULT_DRIVER_SECTION;
        try {
            IniFile iniFile = new IniFile(fileName);
            Properties driverSectionProps = null;
            Properties connectionSectionProps = null;
            Map<String, String> kv = iniFile.getAllKeyVals(driverSectionName);
            if (kv != null) {
                driverSectionProps = new Properties();
                driverSectionProps.putAll(kv);
            }
            if (connectionSectionName != null) {
                kv = iniFile.getAllKeyVals(connectionSectionName);
                if (kv != null) {
                    connectionSectionProps = new Properties();
                    connectionSectionProps.putAll(kv);
                } else {
                    throw new RedshiftException(GT.tr("User specified section " + connectionSectionName + " not found in the JDBC INI file " + fileName, new Object[0]), RedshiftState.UNEXPECTED_ERROR);
                }
            }
            if (driverSectionProps != null || connectionSectionProps != null) {
                Properties iniProps = new Properties(props);
                if (driverSectionProps != null) {
                    iniProps.putAll((Map<?, ?>)driverSectionProps);
                }
                if (connectionSectionProps != null) {
                    iniProps.putAll((Map<?, ?>)connectionSectionProps);
                }
                iniProps.putAll((Map<?, ?>)props);
                props = iniProps;
            }
        }
        catch (IOException e) {
            throw new RedshiftException(GT.tr("Error loading JDBC INI file: ", new Object[0]) + fileName, RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
        }
        return props;
    }

    static {
        sharedTimer = new SharedTimer();
        URL_PATTERN = Pattern.compile("(iam:)?//([^:/?]+)(:([^/?]*))?(/([^?;]*))?([?;](.*))?");
        HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift(-dev)?\\.amazonaws\\.com(.)*");
        SERVERLESS_HOST_PATTERN = Pattern.compile("(.+)\\.(.+).redshift-serverless(-dev)?\\.amazonaws\\.com(.)*");
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;
        private RedshiftLogger connLogger;

        ConnectThread(String url, Properties props, RedshiftLogger connLogger) {
            this.url = url;
            this.props = props;
            this.connLogger = connLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props, this.connLogger);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new RedshiftException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new RedshiftException(GT.tr("Connection attempt timed out.", new Object[0]), RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

