/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.Portal;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RedshiftRowsBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = -7903933977591709194L;
    private int fetchSize;
    private long fetchRingBufferSizeCapacity;
    private boolean limitByBufSize;
    private AtomicLong totalFetchRingBufferSize;
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();
    private boolean closed = false;
    private boolean endOfResultAdded = false;
    private SQLException handlerException = null;
    private boolean skipRows = false;
    private int currentRow = -1;
    private RedshiftLogger logger;
    private Portal currentSuspendedPortal;

    public RedshiftRowsBlockingQueue(int capacity) {
        super(capacity);
        this.init(capacity, 0L, null);
    }

    public RedshiftRowsBlockingQueue(int fetchSize, long fetchRingBufferSize, RedshiftLogger logger) {
        super(fetchSize != 0 && fetchRingBufferSize == 0L ? fetchSize : Integer.MAX_VALUE);
        this.init(fetchSize, fetchRingBufferSize, logger);
    }

    private void init(int fetchSize, long fetchRingBufferSize, RedshiftLogger logger) {
        this.fetchSize = fetchSize;
        this.fetchRingBufferSizeCapacity = fetchRingBufferSize;
        this.logger = logger;
        this.limitByBufSize = fetchRingBufferSize != 0L;
        this.totalFetchRingBufferSize = new AtomicLong();
        if (RedshiftLogger.isEnable() && logger != null) {
            logger.log(LogLevel.DEBUG, "init(): limitByBufSize={0} , totalFetchRingBufferSize={1}, fetchRingBufferSizeCapacity = {2}, fetchSize = {3}", this.limitByBufSize, this.totalFetchRingBufferSize.get(), this.fetchRingBufferSizeCapacity, fetchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (this.skipRows) {
            return;
        }
        if (this.limitByBufSize) {
            if (e == null) return;
            if (this.totalFetchRingBufferSize.get() >= this.fetchRingBufferSizeCapacity) {
                ReentrantLock putLock = this.putLock;
                putLock.lockInterruptibly();
                try {
                    Tuple row = (Tuple)e;
                    if (RedshiftLogger.isEnable() && this.logger != null) {
                        this.logger.log(LogLevel.DEBUG, "put(): Buffer full. Waiting for application to read rows and make space", new Object[0]);
                    }
                    while (this.totalFetchRingBufferSize.get() >= this.fetchRingBufferSizeCapacity) {
                        this.notFull.await(1L, TimeUnit.SECONDS);
                    }
                    if (RedshiftLogger.isEnable() && this.logger != null) {
                        this.logger.log(LogLevel.DEBUG, "put(): Buffer state change from full to having some space. Now adding a new row.", new Object[0]);
                    }
                    super.put(e);
                    long currentBufSize = this.totalFetchRingBufferSize.addAndGet(row.length());
                    if (currentBufSize >= this.fetchRingBufferSizeCapacity) return;
                    this.notFull.signal();
                    return;
                }
                finally {
                    putLock.unlock();
                }
            } else {
                super.put(e);
                this.totalFetchRingBufferSize.addAndGet(((Tuple)e).length());
            }
            return;
        } else {
            super.put(e);
        }
    }

    @Override
    public E take() throws InterruptedException {
        ++this.currentRow;
        Object e = super.take();
        if (this.limitByBufSize) {
            Tuple row = (Tuple)e;
            boolean bufWasFull = this.totalFetchRingBufferSize.get() >= this.fetchRingBufferSizeCapacity;
            long currentBufSize = this.totalFetchRingBufferSize.addAndGet(-row.length());
            if (bufWasFull && currentBufSize < this.fetchRingBufferSizeCapacity) {
                this.signalNotFull();
            }
        }
        return e;
    }

    public int getCurrentRowIndex() {
        return this.currentRow;
    }

    public boolean endOfResult() {
        return this.endOfResultAdded;
    }

    public void setHandlerException(SQLException ex) {
        this.handlerException = ex;
    }

    public SQLException getHandlerException() {
        SQLException ex = this.handlerException;
        this.handlerException = null;
        return ex;
    }

    public void close() {
        this.closed = true;
        super.clear();
        try {
            this.addEndOfRowsIndicator();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.totalFetchRingBufferSize.set(0L);
    }

    public void setSkipRows() {
        this.skipRows = true;
    }

    public void addEndOfRowsIndicator() throws InterruptedException {
        this.put(new Tuple(0));
    }

    public void checkAndAddEndOfRowsIndicator() throws InterruptedException {
        if (!this.endOfResultAdded) {
            this.addEndOfRowsIndicator();
            this.endOfResultAdded = true;
        }
    }

    public void checkAndAddEndOfRowsIndicator(Portal currentSuspendedPortal) throws InterruptedException {
        this.currentSuspendedPortal = currentSuspendedPortal;
        this.checkAndAddEndOfRowsIndicator();
    }

    public Portal getSuspendedPortal() {
        return this.currentSuspendedPortal;
    }

    public boolean isSuspendedPortal() {
        return this.currentSuspendedPortal != null;
    }

    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }
}

