/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.core.NativeQuery;
import com.amazon.redshift.core.ParameterList;
import com.amazon.redshift.core.v3.SimpleQuery;
import com.amazon.redshift.core.v3.TypeTransferModeRegistry;
import com.amazon.redshift.logger.RedshiftLogger;

public class BatchedQuery
extends SimpleQuery {
    private String sql;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;
    private final int batchSize;
    private BatchedQuery[] blocks;

    public BatchedQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, int valuesBraceOpenPosition, int valuesBraceClosePosition, boolean sanitiserDisabled, RedshiftLogger logger) {
        super(query, transferModeRegistry, sanitiserDisabled, logger);
        this.valuesBraceOpenPosition = valuesBraceOpenPosition;
        this.valuesBraceClosePosition = valuesBraceClosePosition;
        this.batchSize = 1;
    }

    private BatchedQuery(BatchedQuery src, int batchSize, RedshiftLogger logger) {
        super(src, logger);
        this.valuesBraceOpenPosition = src.valuesBraceOpenPosition;
        this.valuesBraceClosePosition = src.valuesBraceClosePosition;
        this.batchSize = batchSize;
    }

    public BatchedQuery deriveForMultiBatch(int valueBlock, int maxBlockCount, RedshiftLogger logger) {
        BatchedQuery bq;
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (valueBlock == 1) {
            return this;
        }
        int index = Integer.numberOfTrailingZeros(valueBlock) - 1;
        if (valueBlock > maxBlockCount || valueBlock != 1 << index + 1) {
            throw new IllegalArgumentException("Expected value block should be a power of 2 smaller or equal to " + maxBlockCount + ". Actual block is " + valueBlock);
        }
        if (this.blocks == null) {
            int maxBase2Exponent = (int)(Math.log(maxBlockCount) / Math.log(2.0));
            logger.logDebug("maxBase2Exponent=" + maxBase2Exponent, new Object[0]);
            this.blocks = new BatchedQuery[maxBase2Exponent];
        }
        if ((bq = this.blocks[index]) == null) {
            this.blocks[index] = bq = new BatchedQuery(this, valueBlock, logger);
        }
        return bq;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getNativeSql() {
        if (this.sql != null) {
            return this.sql;
        }
        this.sql = this.buildNativeSql(null);
        return this.sql;
    }

    private String buildNativeSql(ParameterList params) {
        int pos;
        String sql = null;
        String nativeSql = super.getNativeSql();
        int batchSize = this.getBatchSize();
        if (batchSize < 2) {
            sql = nativeSql;
            return sql;
        }
        if (nativeSql == null) {
            sql = "";
            return sql;
        }
        int valuesBlockCharCount = 0;
        int[] bindPositions = this.getNativeQuery().bindPositions;
        int[] chunkStart = new int[1 + bindPositions.length];
        int[] chunkEnd = new int[1 + bindPositions.length];
        chunkStart[0] = this.valuesBraceOpenPosition;
        if (bindPositions.length == 0) {
            valuesBlockCharCount = this.valuesBraceClosePosition - this.valuesBraceOpenPosition + 1;
            chunkEnd[0] = this.valuesBraceClosePosition + 1;
        } else {
            chunkEnd[0] = bindPositions[0];
            valuesBlockCharCount += chunkEnd[0] - chunkStart[0];
            for (int i = 0; i < bindPositions.length; ++i) {
                int startIndex;
                int endIndex;
                int n = endIndex = i < bindPositions.length - 1 ? bindPositions[i + 1] : this.valuesBraceClosePosition + 1;
                for (startIndex = bindPositions[i] + 2; startIndex < endIndex && Character.isDigit(nativeSql.charAt(startIndex)); ++startIndex) {
                }
                chunkStart[i + 1] = startIndex;
                chunkEnd[i + 1] = endIndex;
                valuesBlockCharCount += chunkEnd[i + 1] - chunkStart[i + 1];
            }
        }
        int length = nativeSql.length();
        length += NativeQuery.calculateBindLength(bindPositions.length * batchSize);
        length -= NativeQuery.calculateBindLength(bindPositions.length);
        StringBuilder s = new StringBuilder(length += (valuesBlockCharCount + 1) * (batchSize - 1));
        if (bindPositions.length > 0 && params == null) {
            s.append(nativeSql, 0, this.valuesBraceClosePosition + 1);
            pos = bindPositions.length + 1;
        } else {
            pos = 1;
            ++batchSize;
            s.append(nativeSql, 0, this.valuesBraceOpenPosition);
        }
        for (int i = 2; i <= batchSize; ++i) {
            if (i > 2 || pos != 1) {
                s.append(',');
            }
            s.append(nativeSql, chunkStart[0], chunkEnd[0]);
            for (int j = 1; j < chunkStart.length; ++j) {
                if (params == null) {
                    NativeQuery.appendBindName(s, pos++);
                } else {
                    s.append(params.toString(pos++, true));
                }
                s.append(nativeSql, chunkStart[j], chunkEnd[j]);
            }
        }
        s.append(nativeSql, this.valuesBraceClosePosition + 1, nativeSql.length());
        sql = s.toString();
        assert (params != null || s.length() == length) : "Predicted length != actual: " + length + " !=" + s.length();
        return sql;
    }

    @Override
    public String toString(ParameterList params) {
        if (this.getBatchSize() < 2) {
            return super.toString(params);
        }
        return this.buildNativeSql(params);
    }
}

