/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.Driver;
import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.TypeInfo;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.jdbc.TypeInfoCache;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ByteConverter;
import com.amazon.redshift.util.DriverInfo;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.JdbcBlackHole;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RedshiftDatabaseMetaData
implements DatabaseMetaData {
    private final int NO_SCHEMA_UNIVERSAL_QUERY = 0;
    private final int LOCAL_SCHEMA_QUERY = 1;
    private final int EXTERNAL_SCHEMA_QUERY = 2;
    private String keywords;
    protected final RedshiftConnectionImpl connection;
    private int nameDataLength = 0;
    private int indexMaxKeys = 0;
    private static final Map<String, Map<String, String>> tableTypeClauses = new HashMap<String, Map<String, String>>();

    public RedshiftDatabaseMetaData(RedshiftConnectionImpl conn) {
        this.connection = conn;
    }

    protected int getMaxIndexKeys() throws SQLException {
        if (this.indexMaxKeys == 0) {
            this.indexMaxKeys = 32;
        }
        return this.indexMaxKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxNameLength() throws SQLException {
        if (this.nameDataLength == 0) {
            String sql = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    throw new RedshiftException(GT.tr("Unable to find name datatype in the system catalogs.", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
                }
                this.nameDataLength = rs.getInt("typlen");
            }
            finally {
                JdbcBlackHole.close(rs);
                JdbcBlackHole.close(stmt);
            }
        }
        return this.nameDataLength - 1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Redshift";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDBVersionNumber();
    }

    @Override
    public String getDriverName() {
        return "Redshift JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return DriverInfo.DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return DriverInfo.MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return DriverInfo.MINOR_VERSION;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        String keywords = "abort,access,aggregate,also,analyse,analyze,backward,bit,cache,checkpoint,class,cluster,comment,concurrently,connection,conversion,copy,csv,database,delimiter,delimiters,disable,do,enable,encoding,encrypted,exclusive,explain,force,forward,freeze,greatest,handler,header,if,ilike,immutable,implicit,index,indexes,inherit,inherits,instead,isnull,least,limit,listen,load,location,lock,mode,move,nothing,notify,notnull,nowait,off,offset,oids,operator,owned,owner,password,prepared,procedural,quote,reassign,recheck,reindex,rename,replace,reset,restrict,returning,rule,setof,share,show,stable,statistics,stdin,stdout,storage,strict,sysid,tablespace,temp,template,truncate,trusted,unencrypted,unlisten,until,vacuum,valid,validator,verbose,volatile";
        return keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,random,round,sign,sin,sqrt,tan,truncate";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String funcs = "ascii,char,char_length,character_length,concat,lcase,left,length,ltrim,octet_length,position,repeat,right,rtrim,space,substring,ucase";
        funcs = funcs + ",replace";
        return funcs;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String timeDateFuncs = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
        timeDateFuncs = timeDateFuncs + ",timestampadd";
        return timeDateFuncs;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected String escapeQuotes(String s) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(this.connection.escapeString(s));
        sb.append("'");
        return sb.toString();
    }

    protected String escapeOnlyQuotes(String s) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(this.connection.escapeOnlyQuotesString(s));
        sb.append("'");
        return sb.toString();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, procedureNamePattern);
        }
        String sql = "SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS,  CASE   WHEN p.prokind='f' or p.proargmodes is not null THEN 2  WHEN p.prokind='p' THEN 1  ELSE 0  END AS PROCEDURE_TYPE,  p.proname || '_' || p.prooid AS SPECIFIC_NAME  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc_info p  LEFT JOIN pg_catalog.pg_description d ON (p.prooid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        sql = schemaPattern != null && !schemaPattern.isEmpty() ? sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern) : sql + "and pg_function_is_visible(p.prooid)";
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            sql = sql + " AND p.proname LIKE " + this.escapeQuotes(procedureNamePattern);
        }
        if (this.connection.getHideUnprivilegedObjects()) {
            sql = sql + " AND has_function_privilege(p.prooid,'EXECUTE')";
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.prooid::text ";
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String unknownColumnSize = "2147483647";
        StringBuilder procedureColQuery = new StringBuilder();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        procedureColQuery.append("SELECT PROCEDURE_CAT , PROCEDURE_SCHEM , PROCEDURE_NAME, COLUMN_NAME,  COLUMN_TYPE, DATA_TYPE, TYPE_NAME, COLUMN_SIZE AS PRECISION, LENGTH , DECIMAL_DIGITS AS SCALE,   NUM_PREC_RADIX AS RADIX, NULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB,  CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SPECIFIC_NAME   FROM (");
        procedureColQuery.append("SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(CASE ((array_upper(proargnames, 0) - array_lower(proargnames, 0)) > 0)  WHEN 't' THEN proargnames[array_upper(proargnames, 1)]  ELSE ''  END AS VARCHAR(256)) AS COLUMN_NAME,  CAST(CASE p.proretset  WHEN 't' THEN 3  ELSE 0  END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN 1 WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 10  WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 29  WHEN 'timestamp without time zone' THEN 29  WHEN 'timestamptz' THEN 35  WHEN 'timestamp with time zone' THEN 35  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  ELSE 2147483647 END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 35  WHEN 'timestamp with time zone' THEN 35  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  END AS LENGTH,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'smallint' THEN 0  WHEN 'int2' THEN 0  WHEN 'integer' THEN 0  WHEN 'int' THEN 0  WHEN 'int4' THEN 0  WHEN 'bigint' THEN 0  WHEN 'int8' THEN 0  WHEN 'decimal' THEN 0  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float' THEN 17  WHEN 'float8' THEN 17  WHEN 'time' THEN 6  WHEN 'time without time zone' THEN 6  WHEN 'timetz' THEN 6  WHEN 'time with time zone' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  ELSE NULL END AS SMALLINT) AS DECIMAL_DIGITS,  10 AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST('' AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF,  CAST(CASE  pg_catalog.format_type(p.prorettype, NULL) WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN 1 WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST('' AS VARCHAR(256)) AS IS_NULLABLE,  p.proname || '_' || p.prooid AS SPECIFIC_NAME,  p.prooid as PROOID,  -1 AS PROARGINDEX  FROM pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  WHERE pg_catalog.format_type(p.prorettype, NULL) != 'void' ");
        procedureColQuery.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            procedureColQuery.append(" AND n.nspname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            procedureColQuery.append(" AND proname LIKE " + this.escapeQuotes(procedureNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            procedureColQuery.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        procedureColQuery.append(" UNION ALL ");
        procedureColQuery.append(" SELECT DISTINCT current_database() AS PROCEDURE_CAT,  PROCEDURE_SCHEM,  PROCEDURE_NAME, CAST(CASE (char_length(COLUMN_NAME) > 0) WHEN 't' THEN COLUMN_NAME ELSE '' END AS VARCHAR(256)) AS COLUMN_NAME,  CAST( CASE COLUMN_TYPE  WHEN 105 THEN 1  WHEN 98 THEN 2  WHEN 111 THEN 4  ELSE 0 END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE DATA_TYPE  WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN  1  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  TYPE_NAME,  CASE COLUMN_SIZE  WHEN 'text' THEN COLUMN_BYTES  WHEN 'varchar' THEN COLUMN_BYTES  WHEN 'character varying' THEN COLUMN_BYTES  WHEN '\"char\"' THEN COLUMN_BYTES  WHEN 'character' THEN COLUMN_BYTES  WHEN 'nchar' THEN COLUMN_BYTES  WHEN 'bpchar' THEN COLUMN_BYTES  WHEN 'nvarchar' THEN COLUMN_BYTES  WHEN 'date' THEN 10  WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 35  WHEN 'timestamp with time zone' THEN 35  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  WHEN 'numeric' THEN NUMERIC_PRECISION  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  ELSE 2147483647 END AS COLUMN_SIZE,  CASE LENGTH  WHEN 'text' THEN COLUMN_BYTES  WHEN 'varchar' THEN COLUMN_BYTES  WHEN 'character varying' THEN COLUMN_BYTES  WHEN '\"char\"' THEN COLUMN_BYTES  WHEN 'character' THEN COLUMN_BYTES  WHEN 'nchar' THEN COLUMN_BYTES  WHEN 'bpchar' THEN COLUMN_BYTES  WHEN 'nvarchar' THEN COLUMN_BYTES  WHEN 'date' THEN 6  WHEN 'time' THEN 6  WHEN 'time without time zone' THEN 6  WHEN 'timetz' THEN 6  WHEN 'time with time zone' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  END AS LENGTH,  CAST(CASE DECIMAL_DIGITS  WHEN 'smallint' THEN 0  WHEN 'int2' THEN 0  WHEN 'integer' THEN 0  WHEN 'int' THEN 0  WHEN 'int4' THEN 0  WHEN 'bigint' THEN 0  WHEN 'int8' THEN 0  WHEN 'decimal' THEN 0  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float' THEN 17  WHEN 'float8' THEN 17  WHEN 'numeric' THEN NUMERIC_SCALE  WHEN 'time' THEN 6  WHEN 'time without time zone' THEN 6  WHEN 'timetz' THEN 6  WHEN 'time with time zone' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  ELSE NULL END AS SMALLINT) AS DECIMAL_DIGITS,  10 AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF, CAST( CASE SQL_DATA_TYPE WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN  1  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  PROARGINDEX AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  SPECIFIC_NAME, PROOID, PROARGINDEX  FROM (  SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CASE WHEN (proallargtypes is NULL) THEN proargnames[pos+1]  ELSE proargnames[pos] END AS COLUMN_NAME, CASE WHEN proargmodes is NULL THEN 105  ELSE CAST(proargmodes[pos] AS INT) END AS COLUMN_TYPE,  CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DATA_TYPE, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL)  ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS TYPE_NAME, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS COLUMN_SIZE, CASE  WHEN (proallargtypes IS NOT NULL) and prokind='p' AND proallargtypes[pos] IN (1042, 1700, 1043) \t\t\t\tTHEN (string_to_array(textin(byteaout(substring(probin from 1 for length(probin)-3))),','))[pos]::integer  \t\t\tWHEN (proallargtypes IS NULL) AND prokind='p' AND proargtypes[pos] IN (1042,1700,1043) \t\t\t\tTHEN (string_to_array(textin(byteaout(substring(probin FROM 1 FOR length(probin)-3))), ',')) [pos+1]::integer  END AS PROBIN_BYTES,  CASE    WHEN (PROBIN_BYTES IS NOT NULL)  \t\t\t\tAND (proallargtypes[pos] IN (1042, 1043) or proargtypes[pos] in (1042,1043)) \t\tTHEN PROBIN_BYTES-4  END AS COLUMN_BYTES,  CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS LENGTH, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DECIMAL_DIGITS, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS RADIX, CAST(2 AS SMALLINT) AS NULLABLE, CAST(''AS VARCHAR(256)) AS REMARKS, CAST(NULL AS SMALLINT) AS COLUMN_DEF, pg_catalog.format_type(proargtypes[pos], NULL) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, pg_catalog.format_type(proargtypes[pos], NULL) AS CHAR_OCTET_LENGTH, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS ORDINAL_POSITION, CAST('' AS VARCHAR(256)) AS IS_NULLABLE, p.prooid AS PROOID, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN prokind = 'f' AND pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS PROARGINDEX,  CASE WHEN (proallargtypes IS NULL AND proargtypes[pos] = 1700 AND prokind='p') OR (proallargtypes IS NOT NULL AND proallargtypes[pos] = 1700 AND prokind='p' AND proallargtypes[pos] = 1700) THEN (PROBIN_BYTES-4)/65536 END as NUMERIC_PRECISION,  CASE WHEN (proallargtypes IS NULL AND proargtypes[pos] = 1700 AND prokind='p') OR (proallargtypes IS NOT NULL AND proallargtypes[pos] = 1700 AND prokind='p' AND proallargtypes[pos] = 1700) THEN (((PROBIN_BYTES::numeric-4)/65536 - (PROBIN_BYTES-4)/65536) *  65536)::INT END as NUMERIC_SCALE,  p.proname || '_' || p.prooid AS SPECIFIC_NAME  FROM (pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace) LEFT JOIN (SELECT  CASE WHEN (proallargtypes IS NULL)  THEN generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1))-1 ELSE generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1)+1)-1  END AS pos FROM pg_catalog.pg_proc_info p ) AS s ON (pos >= 0)");
        procedureColQuery.append(" WHERE true ");
        procedureColQuery.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            procedureColQuery.append(" AND n.nspname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            procedureColQuery.append(" AND proname LIKE " + this.escapeQuotes(procedureNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            procedureColQuery.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        procedureColQuery.append(" ) AS INPUT_PARAM_TABLE WHERE ORDINAL_POSITION IS NOT NULL ) AS RESULT_SET WHERE (DATA_TYPE != 1111 OR (TYPE_NAME IS NOT NULL AND TYPE_NAME != '-')) ORDER BY PROCEDURE_CAT ,PROCEDURE_SCHEM, PROCEDURE_NAME, PROOID, PROARGINDEX, COLUMN_TYPE DESC");
        String sql = procedureColQuery.toString();
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sql = null;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, tableNamePattern, types);
        }
        int schemaPatternType = this.getExtSchemaPatternMatch(schemaPattern);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logInfo("schemaPatternType = {0}", schemaPatternType);
        }
        if (schemaPatternType == 1) {
            sql = this.buildLocalSchemaTablesQuery(catalog, schemaPattern, tableNamePattern, types);
        } else if (schemaPatternType == 0) {
            sql = this.isSingleDatabaseMetaData() ? this.buildUniversalSchemaTablesQuery(catalog, schemaPattern, tableNamePattern, types) : this.buildUniversalAllSchemaTablesQuery(catalog, schemaPattern, tableNamePattern, types);
        } else if (schemaPatternType == 2) {
            sql = this.buildExternalSchemaTablesQuery(catalog, schemaPattern, tableNamePattern, types);
        }
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    private String buildLocalSchemaTablesQuery(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String select = "SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname ~ '^pg_' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'p' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   WHEN 'S' THEN 'TEMPORARY SEQUENCE'   WHEN 'v' THEN 'TEMPORARY VIEW'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'p' THEN 'PARTITIONED TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  WHEN 'c' THEN 'TYPE'  WHEN 'f' THEN 'FOREIGN TABLE'  WHEN 'm' THEN 'MATERIALIZED VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS,  '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN pg_catalog.pg_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid ";
        String filterClause = this.getTableFilterClause(catalog, schemaPattern, tableNamePattern, types, 1, true, null);
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        return select + filterClause + orderby;
    }

    private String getTableFilterClause(String catalog, String schemaPattern, String tableNamePattern, String[] types, int schemaPatternType, boolean apiSupportedOnlyForConnectedDatabase, String databaseColName) throws SQLException {
        String filterClause = "";
        String useSchemas = "SCHEMAS";
        filterClause = filterClause + this.getCatalogFilterCondition(catalog, apiSupportedOnlyForConnectedDatabase, databaseColName);
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            filterClause = filterClause + " AND TABLE_SCHEM LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            filterClause = filterClause + " AND TABLE_NAME LIKE " + this.escapeQuotes(tableNamePattern);
        }
        if (types != null) {
            if (schemaPatternType == 1) {
                filterClause = filterClause + " AND (false ";
                StringBuilder orclause = new StringBuilder();
                for (String type : types) {
                    Map<String, String> clauses = tableTypeClauses.get(type);
                    if (clauses == null) continue;
                    String clause = clauses.get(useSchemas);
                    orclause.append(" OR ( ").append(clause).append(" ) ");
                }
                filterClause = filterClause + orclause.toString() + ") ";
            } else if (schemaPatternType == 0 || schemaPatternType == 2) {
                filterClause = filterClause + " AND TABLE_TYPE IN ( ";
                int len = types.length;
                for (String type : types) {
                    filterClause = filterClause + this.escapeQuotes(type);
                    if (--len <= 0) continue;
                    filterClause = filterClause + ", ";
                }
                filterClause = filterClause + ") ";
            }
        }
        if (schemaPatternType == 1 && this.connection.getHideUnprivilegedObjects()) {
            filterClause = filterClause + " AND has_table_privilege(c.oid,  'SELECT, INSERT, UPDATE, DELETE, RULE, REFERENCES, TRIGGER')";
        }
        return filterClause;
    }

    private String buildUniversalSchemaTablesQuery(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder tableQuery = new StringBuilder(2048);
        tableQuery.append("SELECT * FROM (SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, table_schema AS TABLE_SCHEM, table_name AS TABLE_NAME, CAST( CASE table_type WHEN 'BASE TABLE' THEN CASE WHEN table_schema = 'pg_catalog' OR table_schema = 'information_schema' THEN 'SYSTEM TABLE' WHEN table_schema = 'pg_toast' THEN 'SYSTEM TOAST TABLE' WHEN table_schema ~ '^pg_' AND table_schema != 'pg_toast' THEN 'TEMPORARY TABLE' ELSE 'TABLE' END WHEN 'VIEW' THEN CASE WHEN table_schema = 'pg_catalog' OR table_schema = 'information_schema' THEN 'SYSTEM VIEW' WHEN table_schema = 'pg_toast' THEN NULL WHEN table_schema ~ '^pg_' AND table_schema != 'pg_toast' THEN 'TEMPORARY VIEW' ELSE 'VIEW' END WHEN 'EXTERNAL TABLE' THEN 'EXTERNAL TABLE' END AS VARCHAR(124)) AS TABLE_TYPE, REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME,  '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM svv_tables)");
        tableQuery.append(" WHERE true ");
        String filterClause = this.getTableFilterClause(catalog, schemaPattern, tableNamePattern, types, 0, true, null);
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        tableQuery.append(filterClause);
        tableQuery.append(orderby);
        return tableQuery.toString();
    }

    private String buildUniversalAllSchemaTablesQuery(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder tableQuery = new StringBuilder(2048);
        tableQuery.append("SELECT * FROM (SELECT CAST(DATABASE_NAME AS VARCHAR(124)) AS TABLE_CAT, SCHEMA_NAME AS TABLE_SCHEM, TABLE_NAME  AS TABLE_NAME, CAST( CASE  WHEN SCHEMA_NAME='information_schema'     AND TABLE_TYPE='TABLE' THEN 'SYSTEM TABLE'  WHEN SCHEMA_NAME='information_schema'     AND TABLE_TYPE='VIEW' THEN 'SYSTEM VIEW'  ELSE TABLE_TYPE  END  AS VARCHAR(124)) AS TABLE_TYPE, REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME,  '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM PG_CATALOG.SVV_ALL_TABLES)");
        tableQuery.append(" WHERE true ");
        String filterClause = this.getTableFilterClause(catalog, schemaPattern, tableNamePattern, types, 0, false, "TABLE_CAT");
        String orderby = " ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME ";
        tableQuery.append(filterClause);
        tableQuery.append(orderby);
        return tableQuery.toString();
    }

    private String buildExternalSchemaTablesQuery(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder tableQuery = new StringBuilder(2048);
        tableQuery.append("SELECT * FROM (SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, schemaname AS table_schem, tablename AS TABLE_NAME, 'EXTERNAL TABLE' AS TABLE_TYPE, NULL AS REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME,  '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM svv_external_tables)");
        tableQuery.append(" WHERE true ");
        String filterClause = this.getTableFilterClause(catalog, schemaPattern, tableNamePattern, types, 2, true, null);
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        tableQuery.append(filterClause);
        tableQuery.append(orderby);
        return tableQuery.toString();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String sql;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern);
        }
        if (this.isSingleDatabaseMetaData()) {
            sql = "SELECT nspname AS TABLE_SCHEM, current_database() AS TABLE_CATALOG FROM pg_catalog.pg_namespace  WHERE nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_'  OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_'  OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_')) ";
            sql = sql + this.getCatalogFilterCondition(catalog);
            if (schemaPattern != null && !schemaPattern.isEmpty()) {
                sql = sql + " AND nspname LIKE " + this.escapeQuotes(schemaPattern);
            }
            if (this.connection.getHideUnprivilegedObjects()) {
                sql = sql + " AND has_schema_privilege(nspname, 'USAGE, CREATE')";
            }
            sql = sql + " ORDER BY TABLE_SCHEM";
        } else {
            sql = "SELECT CAST(schema_name AS varchar(124)) AS TABLE_SCHEM,  CAST(database_name AS varchar(124)) AS TABLE_CATALOG  FROM PG_CATALOG.SVV_ALL_SCHEMAS  WHERE TRUE ";
            sql = sql + this.getCatalogFilterCondition(catalog, false, null);
            if (schemaPattern != null && !schemaPattern.isEmpty()) {
                sql = sql + " AND schema_name LIKE " + this.escapeQuotes(schemaPattern);
            }
            sql = sql + " ORDER BY TABLE_CATALOG, TABLE_SCHEM";
        }
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        if (this.isSingleDatabaseMetaData()) {
            Field[] f = new Field[1];
            ArrayList<Tuple> v = new ArrayList<Tuple>();
            f[0] = new Field("TABLE_CAT", 1043);
            byte[][] tuple = new byte[][]{this.connection.encodeString(this.connection.getCatalog())};
            v.add(new Tuple(tuple));
            return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
        }
        String sql = "SELECT CAST(database_name AS varchar(124)) AS TABLE_CAT FROM PG_CATALOG.SVV_REDSHIFT_DATABASES ";
        sql = sql + " ORDER BY TABLE_CAT";
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Object[] types = tableTypeClauses.keySet().toArray(new String[0]);
        Arrays.sort(types);
        Field[] f = new Field[1];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("TABLE_TYPE", 1043);
        for (Object type : types) {
            byte[][] tuple = new byte[][]{this.connection.encodeString((String)type)};
            v.add(new Tuple(tuple));
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql = null;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        int schemaPatternType = this.getExtSchemaPatternMatch(schemaPattern);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logInfo("schemaPatternType = {0}", schemaPatternType);
        }
        if (schemaPatternType == 1) {
            sql = this.buildLocalSchemaColumnsQuery(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        } else if (schemaPatternType == 0) {
            sql = this.isSingleDatabaseMetaData() ? this.buildUniversalSchemaColumnsQuery(catalog, schemaPattern, tableNamePattern, columnNamePattern) : this.buildUniversalAllSchemaColumnsQuery(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        } else if (schemaPatternType == 2) {
            sql = this.buildExternalSchemaColumnsQuery(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    private String buildLocalSchemaColumnsQuery(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder result = new StringBuilder();
        result.append("SELECT * FROM ( ");
        result.append("SELECT current_database() AS TABLE_CAT, ");
        result.append("n.nspname AS TABLE_SCHEM, ");
        result.append("c.relname as TABLE_NAME , ");
        result.append("a.attname as COLUMN_NAME, ");
        result.append("CAST(case typname ");
        result.append("when 'text' THEN 12 ");
        result.append("when 'bit' THEN -7 ");
        result.append("when 'bool' THEN -7 ");
        result.append("when 'boolean' THEN -7 ");
        result.append("when 'varchar' THEN 12 ");
        result.append("when 'character varying' THEN 12 ");
        result.append("when 'char' THEN 1 ");
        result.append("when '\"char\"' THEN 1 ");
        result.append("when 'character' THEN 1 ");
        result.append("when 'nchar' THEN 12 ");
        result.append("when 'bpchar' THEN 1 ");
        result.append("when 'nvarchar' THEN 12 ");
        result.append("when 'date' THEN 91 ");
        result.append("when 'time' THEN 92 ");
        result.append("when 'time without time zone' THEN 92 ");
        result.append("when 'timetz' THEN 2013 ");
        result.append("when 'time with time zone' THEN 2013 ");
        result.append("when 'timestamp' THEN 93 ");
        result.append("when 'timestamp without time zone' THEN 93 ");
        result.append("when 'timestamptz' THEN 2014 ");
        result.append("when 'timestamp with time zone' THEN 2014 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 4 ");
        result.append("when 'int' THEN 4 ");
        result.append("when 'int4' THEN 4 ");
        result.append("when 'bigint' THEN -5 ");
        result.append("when 'int8' THEN -5 ");
        result.append("when 'decimal' THEN 3 ");
        result.append("when 'real' THEN 7 ");
        result.append("when 'float4' THEN 7 ");
        result.append("when 'double precision' THEN 8 ");
        result.append("when 'float8' THEN 8 ");
        result.append("when 'float' THEN 6 ");
        result.append("when 'numeric' THEN 2 ");
        result.append("when '_float4' THEN 2003 ");
        result.append("when '_aclitem' THEN 2003 ");
        result.append("when '_text' THEN 2003 ");
        result.append("when 'bytea' THEN -2 ");
        result.append("when 'oid' THEN -5 ");
        result.append("when 'name' THEN 12 ");
        result.append("when '_int4' THEN 2003 ");
        result.append("when '_int2' THEN 2003 ");
        result.append("when 'ARRAY' THEN 2003 ");
        result.append("when 'geometry' THEN -4 ");
        result.append("when 'super' THEN -16 ");
        result.append("when 'varbyte' THEN -4 ");
        result.append("when 'geography' THEN -4 ");
        result.append("else 1111 END as SMALLINT) AS DATA_TYPE, ");
        result.append("t.typname as TYPE_NAME, ");
        result.append("case typname ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bit' THEN 1 ");
        result.append("when 'bool' THEN 1 ");
        result.append("when 'varchar' THEN atttypmod -4 ");
        result.append("when 'character varying' THEN atttypmod -4 ");
        result.append("when 'char' THEN atttypmod -4 ");
        result.append("when 'character' THEN atttypmod -4 ");
        result.append("when 'nchar' THEN atttypmod -4 ");
        result.append("when 'bpchar' THEN atttypmod -4 ");
        result.append("when 'nvarchar' THEN atttypmod -4 ");
        result.append("when 'date' THEN 13 ");
        result.append("when 'time' THEN 15 ");
        result.append("when 'time without time zone' THEN 15 ");
        result.append("when 'timetz' THEN 21 ");
        result.append("when 'time with time zone' THEN 21 ");
        result.append("when 'timestamp' THEN 29 ");
        result.append("when 'timestamp without time zone' THEN 29 ");
        result.append("when 'timestamptz' THEN 35 ");
        result.append("when 'timestamp with time zone' THEN 35 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 10 ");
        result.append("when 'int' THEN 10 ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bigint' THEN 19 ");
        result.append("when 'int8' THEN 19 ");
        result.append("when 'decimal' then (atttypmod - 4) >> 16 ");
        result.append("when 'real' THEN 8 ");
        result.append("when 'float4' THEN 8 ");
        result.append("when 'double precision' THEN 17 ");
        result.append("when 'float8' THEN 17 ");
        result.append("when 'float' THEN 17 ");
        result.append("when 'numeric' THEN (atttypmod - 4) >> 16 ");
        result.append("when '_float4' THEN 8 ");
        result.append("when 'oid' THEN 10 ");
        result.append("when '_int4' THEN 10 ");
        result.append("when '_int2' THEN 5 ");
        result.append("when 'geometry' THEN NULL ");
        result.append("when 'super' THEN NULL ");
        result.append("when 'varbyte' THEN NULL ");
        result.append("when 'geography' THEN NULL ");
        result.append("else 2147483647 end as COLUMN_SIZE , ");
        result.append("null as BUFFER_LENGTH , ");
        result.append("case typname ");
        result.append("when 'float4' then 8 ");
        result.append("when 'float8' then 17 ");
        result.append("when 'numeric' then (atttypmod - 4) & 65535 ");
        result.append("when 'time without time zone' then 6 ");
        result.append("when 'timetz' then 6 ");
        result.append("when 'time with time zone' then 6 ");
        result.append("when 'timestamp without time zone' then 6 ");
        result.append("when 'timestamp' then 6 ");
        result.append("when 'geometry' then NULL ");
        result.append("when 'super' then NULL ");
        result.append("when 'varbyte' then NULL ");
        result.append("when 'geography' then NULL ");
        result.append("else 0 end as DECIMAL_DIGITS, ");
        result.append("case typname ");
        result.append("when 'varbyte' then 2 ");
        result.append("when 'geography' then 2 ");
        result.append("else 10 end as NUM_PREC_RADIX, ");
        result.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        result.append("when 'false' then 1 ");
        result.append("when NULL then 2 ");
        result.append("else 0 end AS NULLABLE , ");
        result.append("dsc.description as REMARKS , ");
        result.append("pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS COLUMN_DEF, ");
        result.append("CAST(case typname ");
        result.append("when 'text' THEN 12 ");
        result.append("when 'bit' THEN -7 ");
        result.append("when 'bool' THEN -7 ");
        result.append("when 'boolean' THEN -7 ");
        result.append("when 'varchar' THEN 12 ");
        result.append("when 'character varying' THEN 12 ");
        result.append("when '\"char\"' THEN 1 ");
        result.append("when 'char' THEN 1 ");
        result.append("when 'character' THEN 1 ");
        result.append("when 'nchar' THEN 1 ");
        result.append("when 'bpchar' THEN 1 ");
        result.append("when 'nvarchar' THEN 12 ");
        result.append("when 'date' THEN 91 ");
        result.append("when 'time' THEN 92 ");
        result.append("when 'time without time zone' THEN 92 ");
        result.append("when 'timetz' THEN 2013 ");
        result.append("when 'time with time zone' THEN 2013 ");
        result.append("when 'timestamp with time zone' THEN 2014 ");
        result.append("when 'timestamp' THEN 93 ");
        result.append("when 'timestamp without time zone' THEN 93 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 4 ");
        result.append("when 'int' THEN 4 ");
        result.append("when 'int4' THEN 4 ");
        result.append("when 'bigint' THEN -5 ");
        result.append("when 'int8' THEN -5 ");
        result.append("when 'decimal' THEN 3 ");
        result.append("when 'real' THEN 7 ");
        result.append("when 'float4' THEN 7 ");
        result.append("when 'double precision' THEN 8 ");
        result.append("when 'float8' THEN 8 ");
        result.append("when 'float' THEN 6 ");
        result.append("when 'numeric' THEN 2 ");
        result.append("when '_float4' THEN 2003 ");
        result.append("when 'timestamptz' THEN 2014 ");
        result.append("when 'timestamp with time zone' THEN 2014 ");
        result.append("when '_aclitem' THEN 2003 ");
        result.append("when '_text' THEN 2003 ");
        result.append("when 'bytea' THEN -2 ");
        result.append("when 'oid' THEN -5 ");
        result.append("when 'name' THEN 12 ");
        result.append("when '_int4' THEN 2003 ");
        result.append("when '_int2' THEN 2003 ");
        result.append("when 'ARRAY' THEN 2003 ");
        result.append("when 'geometry' THEN -4 ");
        result.append("when 'super' THEN -16 ");
        result.append("when 'varbyte' THEN -4 ");
        result.append("when 'geography' THEN -4 ");
        result.append("else 1111 END as SMALLINT) AS SQL_DATA_TYPE, ");
        result.append("CAST(NULL AS SMALLINT) as SQL_DATETIME_SUB , ");
        result.append("case typname ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bit' THEN 1 ");
        result.append("when 'bool' THEN 1 ");
        result.append("when 'varchar' THEN atttypmod -4 ");
        result.append("when 'character varying' THEN atttypmod -4 ");
        result.append("when 'char' THEN atttypmod -4 ");
        result.append("when 'character' THEN atttypmod -4 ");
        result.append("when 'nchar' THEN atttypmod -4 ");
        result.append("when 'bpchar' THEN atttypmod -4 ");
        result.append("when 'nvarchar' THEN atttypmod -4 ");
        result.append("when 'date' THEN 13 ");
        result.append("when 'time' THEN 15 ");
        result.append("when 'time without time zone' THEN 15 ");
        result.append("when 'timetz' THEN 21 ");
        result.append("when 'time with time zone' THEN 21 ");
        result.append("when 'timestamp' THEN 29 ");
        result.append("when 'timestamp without time zone' THEN 29 ");
        result.append("when 'timestamptz' THEN 35 ");
        result.append("when 'timestamp with time zone' THEN 35 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 10 ");
        result.append("when 'int' THEN 10 ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bigint' THEN 19 ");
        result.append("when 'int8' THEN 19 ");
        result.append("when 'decimal' then ((atttypmod - 4) >> 16) & 65535 ");
        result.append("when 'real' THEN 8 ");
        result.append("when 'float4' THEN 8 ");
        result.append("when 'double precision' THEN 17 ");
        result.append("when 'float8' THEN 17 ");
        result.append("when 'float' THEN 17 ");
        result.append("when 'numeric' THEN ((atttypmod - 4) >> 16) & 65535 ");
        result.append("when '_float4' THEN 8 ");
        result.append("when 'oid' THEN 10 ");
        result.append("when '_int4' THEN 10 ");
        result.append("when '_int2' THEN 5 ");
        result.append("when 'geometry' THEN NULL ");
        result.append("when 'super' THEN NULL ");
        result.append("when 'varbyte' THEN NULL ");
        result.append("when 'geography' THEN NULL ");
        result.append("else 2147483647 end as CHAR_OCTET_LENGTH , ");
        result.append("a.attnum AS ORDINAL_POSITION, ");
        result.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        result.append("when 'false' then 'YES' ");
        result.append("when NULL then '' ");
        result.append("else 'NO' end AS IS_NULLABLE, ");
        result.append("null as SCOPE_CATALOG , ");
        result.append("null as SCOPE_SCHEMA , ");
        result.append("null as SCOPE_TABLE, ");
        result.append("t.typbasetype AS SOURCE_DATA_TYPE , ");
        result.append("CASE WHEN left(pg_catalog.pg_get_expr(def.adbin, def.adrelid), 16) = 'default_identity' THEN 'YES' ");
        result.append("ELSE 'NO' END AS IS_AUTOINCREMENT, ");
        result.append("IS_AUTOINCREMENT AS IS_GENERATEDCOLUMN ");
        result.append("FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid) ");
        result.append("JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) ");
        result.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) ");
        result.append("LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) ");
        result.append("LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid) ");
        result.append("LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class') ");
        result.append("LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog') ");
        result.append("WHERE a.attnum > 0 AND NOT a.attisdropped    ");
        result.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            result.append(" AND n.nspname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            result.append(" AND c.relname LIKE " + this.escapeQuotes(tableNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            result.append(" AND attname LIKE " + this.escapeQuotes(columnNamePattern));
        }
        result.append(" ORDER BY TABLE_SCHEM,c.relname,attnum ) ");
        result.append(" UNION ALL ");
        result.append("SELECT current_database()::VARCHAR(128) AS TABLE_CAT, ");
        result.append("schemaname::varchar(128) AS table_schem, ");
        result.append("tablename::varchar(128) AS table_name, ");
        result.append("columnname::varchar(128) AS column_name, ");
        result.append("CAST(CASE columntype_rep ");
        result.append("WHEN 'text' THEN 12 ");
        result.append("WHEN 'bit' THEN -7 ");
        result.append("WHEN 'bool' THEN -7 ");
        result.append("WHEN 'boolean' THEN -7 ");
        result.append("WHEN 'varchar' THEN 12 ");
        result.append("WHEN 'character varying' THEN 12 ");
        result.append("WHEN 'char' THEN 1 ");
        result.append("WHEN 'character' THEN 1 ");
        result.append("WHEN 'nchar' THEN 1 ");
        result.append("WHEN 'bpchar' THEN 1 ");
        result.append("WHEN 'nvarchar' THEN 12 ");
        result.append("WHEN '\"char\"' THEN 1 ");
        result.append("WHEN 'date' THEN 91 ");
        result.append("when 'time' THEN 92 ");
        result.append("when 'time without time zone' THEN 92 ");
        result.append("when 'timetz' THEN 2013 ");
        result.append("when 'time with time zone' THEN 2013 ");
        result.append("WHEN 'timestamp' THEN 93 ");
        result.append("WHEN 'timestamp without time zone' THEN 93 ");
        result.append("when 'timestamptz' THEN 2014 ");
        result.append("WHEN 'timestamp with time zone' THEN 2014 ");
        result.append("WHEN 'smallint' THEN 5 ");
        result.append("WHEN 'int2' THEN 5 ");
        result.append("WHEN 'integer' THEN 4 ");
        result.append("WHEN 'int' THEN 4 ");
        result.append("WHEN 'int4' THEN 4 ");
        result.append("WHEN 'bigint' THEN -5 ");
        result.append("WHEN 'int8' THEN -5 ");
        result.append("WHEN 'decimal' THEN 3 ");
        result.append("WHEN 'real' THEN 7 ");
        result.append("WHEN 'float4' THEN 7 ");
        result.append("WHEN 'double precision' THEN 8 ");
        result.append("WHEN 'float8' THEN 8 ");
        result.append("WHEN 'float' THEN 6 ");
        result.append("WHEN 'numeric' THEN 2 ");
        result.append("WHEN 'timestamptz' THEN 2014 ");
        result.append("WHEN 'bytea' THEN -2 ");
        result.append("WHEN 'oid' THEN -5 ");
        result.append("WHEN 'name' THEN 12 ");
        result.append("WHEN 'ARRAY' THEN 2003 ");
        result.append("WHEN 'geometry' THEN -4 ");
        result.append("WHEN 'super' THEN -16 ");
        result.append("WHEN 'varbyte' THEN -4 ");
        result.append("WHEN 'geography' THEN -4 ");
        result.append("ELSE 1111 END AS SMALLINT) AS DATA_TYPE, ");
        result.append("COALESCE(NULL,CASE columntype WHEN 'boolean' THEN 'bool' ");
        result.append("WHEN 'character varying' THEN 'varchar' ");
        result.append("WHEN '\"char\"' THEN 'char' ");
        result.append("WHEN 'smallint' THEN 'int2' ");
        result.append("WHEN 'integer' THEN 'int4'");
        result.append("WHEN 'bigint' THEN 'int8' ");
        result.append("WHEN 'real' THEN 'float4' ");
        result.append("WHEN 'double precision' THEN 'float8' ");
        result.append("WHEN 'time without time zone' THEN 'time' ");
        result.append("WHEN 'time with time zone' THEN 'timetz' ");
        result.append("WHEN 'timestamp without time zone' THEN 'timestamp' ");
        result.append("WHEN 'timestamp with time zone' THEN 'timestamptz' ");
        result.append("ELSE columntype END) AS TYPE_NAME,  ");
        result.append("CASE columntype_rep ");
        result.append("WHEN 'int4' THEN 10  ");
        result.append("WHEN 'bit' THEN 1    ");
        result.append("WHEN 'bool' THEN 1");
        result.append("WHEN 'boolean' THEN 1");
        result.append("WHEN 'varchar' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'character varying' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'char' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',4),''),'0')::INTEGER ");
        result.append("WHEN 'character' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',4),''),'0')::INTEGER ");
        result.append("WHEN 'nchar' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'bpchar' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'nvarchar' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'date' THEN 13 ");
        result.append("WHEN 'time' THEN 15 ");
        result.append("WHEN 'time without time zone' THEN 15 ");
        result.append("WHEN 'timetz' THEN 21 ");
        result.append("WHEN 'timestamp' THEN 29 ");
        result.append("WHEN 'timestamp without time zone' THEN 29 ");
        result.append("WHEN 'time with time zone' THEN 21 ");
        result.append("WHEN 'timestamptz' THEN 35 ");
        result.append("WHEN 'timestamp with time zone' THEN 35 ");
        result.append("WHEN 'smallint' THEN 5 ");
        result.append("WHEN 'int2' THEN 5 ");
        result.append("WHEN 'integer' THEN 10 ");
        result.append("WHEN 'int' THEN 10 ");
        result.append("WHEN 'int4' THEN 10 ");
        result.append("WHEN 'bigint' THEN 19 ");
        result.append("WHEN 'int8' THEN 19 ");
        result.append("WHEN 'decimal' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN 'real' THEN 8 ");
        result.append("WHEN 'float4' THEN 8 ");
        result.append("WHEN 'double precision' THEN 17 ");
        result.append("WHEN 'float8' THEN 17 ");
        result.append("WHEN 'float' THEN 17");
        result.append("WHEN 'numeric' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN '_float4' THEN 8 ");
        result.append("WHEN 'oid' THEN 10 ");
        result.append("WHEN '_int4' THEN 10 ");
        result.append("WHEN '_int2' THEN 5 ");
        result.append("WHEN 'geometry' THEN NULL ");
        result.append("WHEN 'super' THEN NULL ");
        result.append("WHEN 'varbyte' THEN NULL ");
        result.append("WHEN 'geography' THEN NULL ");
        result.append("ELSE 2147483647 END AS COLUMN_SIZE, ");
        result.append("NULL AS BUFFER_LENGTH, ");
        result.append("CASE REGEXP_REPLACE(columntype,'[()0-9,]') ");
        result.append("WHEN 'real' THEN 8 ");
        result.append("WHEN 'float4' THEN 8 ");
        result.append("WHEN 'double precision' THEN 17 ");
        result.append("WHEN 'float8' THEN 17 ");
        result.append("WHEN 'timestamp' THEN 6 ");
        result.append("WHEN 'timestamp without time zone' THEN 6 ");
        result.append("WHEN 'geometry' THEN NULL ");
        result.append("WHEN 'super' THEN NULL ");
        result.append("WHEN 'numeric' THEN regexp_substr (columntype,'[0-9]+',charindex (',',columntype))::INTEGER ");
        result.append("WHEN 'varbyte' THEN NULL ");
        result.append("WHEN 'geography' THEN NULL ");
        result.append("ELSE 0 END AS DECIMAL_DIGITS, ");
        result.append("CASE columntype ");
        result.append("WHEN 'varbyte' THEN 2 ");
        result.append("WHEN 'geography' THEN 2 ");
        result.append("ELSE 10 END AS NUM_PREC_RADIX, ");
        result.append("NULL AS NULLABLE,  NULL AS REMARKS,   NULL AS COLUMN_DEF, ");
        result.append("CAST(CASE columntype_rep ");
        result.append("WHEN 'text' THEN 12 ");
        result.append("WHEN 'bit' THEN -7 ");
        result.append("WHEN 'bool' THEN -7 ");
        result.append("WHEN 'boolean' THEN -7 ");
        result.append("WHEN 'varchar' THEN 12 ");
        result.append("WHEN 'character varying' THEN 12 ");
        result.append("WHEN 'char' THEN 1 ");
        result.append("WHEN 'character' THEN 1 ");
        result.append("WHEN 'nchar' THEN 12 ");
        result.append("WHEN 'bpchar' THEN 1 ");
        result.append("WHEN 'nvarchar' THEN 12 ");
        result.append("WHEN '\"char\"' THEN 1 ");
        result.append("WHEN 'date' THEN 91 ");
        result.append("WHEN 'time' THEN 92 ");
        result.append("WHEN 'time without time zone' THEN 92 ");
        result.append("WHEN 'timetz' THEN 2013 ");
        result.append("WHEN 'time with time zone' THEN 2013 ");
        result.append("WHEN 'timestamp' THEN 93 ");
        result.append("WHEN 'timestamp without time zone' THEN 93 ");
        result.append("WHEN 'timestamptz' THEN 2014 ");
        result.append("WHEN 'timestamp with time zone' THEN 2014 ");
        result.append("WHEN 'smallint' THEN 5 ");
        result.append("WHEN 'int2' THEN 5 ");
        result.append("WHEN 'integer' THEN 4 ");
        result.append("WHEN 'int' THEN 4 ");
        result.append("WHEN 'int4' THEN 4 ");
        result.append("WHEN 'bigint' THEN -5 ");
        result.append("WHEN 'int8' THEN -5 ");
        result.append("WHEN 'decimal' THEN 3 ");
        result.append("WHEN 'real' THEN 7 ");
        result.append("WHEN 'float4' THEN 7 ");
        result.append("WHEN 'double precision' THEN 8 ");
        result.append("WHEN 'float8' THEN 8 ");
        result.append("WHEN 'float' THEN 6 ");
        result.append("WHEN 'numeric' THEN 2 ");
        result.append("WHEN 'bytea' THEN -2 ");
        result.append("WHEN 'oid' THEN -5 ");
        result.append("WHEN 'name' THEN 12 ");
        result.append("WHEN 'ARRAY' THEN 2003 ");
        result.append("WHEN 'geometry' THEN -4 ");
        result.append("WHEN 'super' THEN -16 ");
        result.append("WHEN 'varbyte' THEN -4 ");
        result.append("WHEN 'geography' THEN -4 ");
        result.append("ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, ");
        result.append("CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE ");
        result.append("WHEN LEFT (columntype,7) = 'varchar' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',7),''),'0')::INTEGER ");
        result.append("WHEN LEFT (columntype,4) = 'char' THEN isnull(nullif(regexp_substr (columntype,'[0-9]+',4),''),'0')::INTEGER ");
        result.append("WHEN columntype = 'string' THEN 16383  ELSE NULL ");
        result.append("END AS CHAR_OCTET_LENGTH, columnnum AS ORDINAL_POSITION, ");
        result.append("NULL AS IS_NULLABLE,  NULL AS SCOPE_CATALOG,  NULL AS SCOPE_SCHEMA, ");
        result.append("NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, 'NO' AS IS_AUTOINCREMENT, ");
        result.append("'NO' as IS_GENERATEDCOLUMN ");
        result.append("FROM (select lbv_cols.schemaname, ");
        result.append("lbv_cols.tablename, lbv_cols.columnname,");
        result.append("REGEXP_REPLACE(REGEXP_REPLACE(lbv_cols.columntype,'\\\\(.*\\\\)'),'^_.+','ARRAY') as columntype_rep,");
        result.append("columntype, ");
        result.append("lbv_cols.columnnum ");
        result.append("from pg_get_late_binding_view_cols() lbv_cols( ");
        result.append("schemaname name, tablename name, columnname name, ");
        result.append("columntype text, columnnum int)) lbv_columns  ");
        result.append(" WHERE true ");
        result.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            result.append(" AND schemaname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            result.append(" AND tablename LIKE " + this.escapeQuotes(tableNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            result.append(" AND columnname LIKE " + this.escapeQuotes(columnNamePattern));
        }
        return result.toString();
    }

    private String buildUniversalAllSchemaColumnsQuery(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String unknownColumnSize = "2147483647";
        StringBuilder result = new StringBuilder(8192);
        result.append("SELECT database_name AS TABLE_CAT,  schema_name AS TABLE_SCHEM,  table_name,  COLUMN_NAME,  CAST(CASE regexp_replace(data_type, '^_.', 'ARRAY')  WHEN 'text' THEN 12  WHEN 'bit' THEN -7  WHEN 'bool' THEN -7  WHEN 'boolean' THEN -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN 12  WHEN 'char' THEN 1  WHEN 'character' THEN 1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN '\"char\"' THEN 1  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111 END AS SMALLINT) AS DATA_TYPE,  CASE data_type  WHEN 'boolean' THEN 'bool'  WHEN 'character varying' THEN 'varchar'  WHEN '\"char\"' THEN 'char'  WHEN 'smallint' THEN 'int2'  WHEN 'integer' THEN 'int4'  WHEN 'bigint' THEN 'int8'  WHEN 'real' THEN 'float4'  WHEN 'double precision' THEN 'float8'  WHEN 'time without time zone' THEN 'time'  WHEN 'time with time zone' THEN 'timetz'  WHEN 'timestamp without time zone' THEN 'timestamp'  WHEN 'timestamp with time zone' THEN 'timestamptz'  ELSE data_type  END AS TYPE_NAME,  CASE data_type  WHEN 'int4' THEN 10  WHEN 'bit' THEN 1  WHEN 'bool' THEN 1  WHEN 'boolean' THEN 1  WHEN 'varchar' THEN character_maximum_length  WHEN 'character varying' THEN character_maximum_length  WHEN 'char' THEN character_maximum_length  WHEN 'character' THEN character_maximum_length  WHEN 'nchar' THEN character_maximum_length  WHEN 'bpchar' THEN character_maximum_length  WHEN 'nvarchar' THEN character_maximum_length  WHEN 'date' THEN 13  WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 29  WHEN 'timestamp without time zone' THEN 29  WHEN 'timestamptz' THEN 35  WHEN 'timestamp with time zone' THEN 35  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN numeric_precision  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float8' THEN 17  WHEN 'float' THEN 17  WHEN 'numeric' THEN numeric_precision  WHEN '_float4' THEN 8  WHEN 'oid' THEN 10  WHEN '_int4' THEN 10  WHEN '_int2' THEN 5  WHEN 'geometry' THEN NULL  WHEN 'super' THEN NULL  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  ELSE   2147483647  END AS COLUMN_SIZE,  NULL AS BUFFER_LENGTH,  CASE data_type  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float8' THEN 17  WHEN 'numeric' THEN numeric_scale  WHEN 'time' THEN 6  WHEN 'time without time zone' THEN 6  WHEN 'timetz' THEN 6  WHEN 'time with time zone' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  WHEN 'geometry' THEN NULL  WHEN 'super' THEN NULL  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  ELSE 0  END AS DECIMAL_DIGITS,  CASE data_type  WHEN 'varbyte' THEN 2  WHEN 'geography' THEN 2  ELSE 10  END AS NUM_PREC_RADIX,  CASE is_nullable WHEN 'YES' THEN 1  WHEN 'NO' THEN 0  ELSE 2 end AS NULLABLE,  REMARKS,  column_default AS COLUMN_DEF,  CAST(CASE regexp_replace(data_type, '^_.', 'ARRAY')  WHEN 'text' THEN 12  WHEN 'bit' THEN -7  WHEN 'bool' THEN -7  WHEN 'boolean' THEN -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN 12  WHEN 'char' THEN 1  WHEN 'character' THEN 1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN '\"char\"' THEN 1  WHEN 'date' THEN 91  WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CASE data_type  WHEN 'int4' THEN 10  WHEN 'bit' THEN 1  WHEN 'bool' THEN 1  WHEN 'boolean' THEN 1  WHEN 'varchar' THEN character_maximum_length  WHEN 'character varying' THEN character_maximum_length  WHEN 'char' THEN character_maximum_length  WHEN 'character' THEN character_maximum_length  WHEN 'nchar' THEN character_maximum_length  WHEN 'bpchar' THEN character_maximum_length  WHEN 'nvarchar' THEN character_maximum_length  WHEN 'date' THEN 13  WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 29  WHEN 'timestamp without time zone' THEN 29  WHEN 'timestamptz' THEN 35  WHEN 'timestamp with time zone' THEN 35  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN numeric_precision  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float8' THEN 17  WHEN 'float' THEN 17  WHEN 'numeric' THEN numeric_precision  WHEN '_float4' THEN 8  WHEN 'oid' THEN 10  WHEN '_int4' THEN 10  WHEN '_int2' THEN 5  WHEN 'geometry' THEN NULL  WHEN 'super' THEN NULL  WHEN 'varbyte' THEN NULL  WHEN 'geography' THEN NULL  ELSE   2147483647  END AS CHAR_OCTET_LENGTH,  ordinal_position AS ORDINAL_POSITION,  is_nullable AS IS_NULLABLE,  NULL AS SCOPE_CATALOG,  NULL AS SCOPE_SCHEMA,  NULL AS SCOPE_TABLE,  data_type as SOURCE_DATA_TYPE,  CASE WHEN left(column_default, 10) = '\"identity\"' THEN 'YES'  WHEN left(column_default, 16) = 'default_identity' THEN 'YES'  ELSE 'NO' END AS IS_AUTOINCREMENT,  IS_AUTOINCREMENT AS IS_GENERATEDCOLUMN  FROM PG_CATALOG.svv_all_columns ");
        result.append(" WHERE true ");
        result.append(this.getCatalogFilterCondition(catalog, false, null));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            result.append(" AND schema_name LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            result.append(" AND table_name LIKE " + this.escapeQuotes(tableNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            result.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        result.append(" ORDER BY TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        return result.toString();
    }

    private String buildUniversalSchemaColumnsQuery(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String unknownColumnSize = "2147483647";
        StringBuilder result = new StringBuilder(8192);
        result.append("SELECT current_database()::varchar(128) AS TABLE_CAT, table_schema AS TABLE_SCHEM, table_name, COLUMN_NAME, CAST(CASE regexp_replace(data_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 12 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamptz' THEN 2014 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 WHEN 'geometry' THEN -4  WHEN 'super' THEN -16  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111 END AS SMALLINT) AS DATA_TYPE, COALESCE( domain_name, CASE data_type WHEN 'boolean' THEN 'bool' WHEN 'character varying' THEN 'varchar' WHEN '\"char\"' THEN 'char' WHEN 'smallint' THEN 'int2' WHEN 'integer' THEN 'int4' WHEN 'bigint' THEN 'int8' WHEN 'real' THEN 'float4' WHEN 'double precision' THEN 'float8' WHEN 'time without time zone' THEN 'time' WHEN 'time with time zone' THEN 'timetz' WHEN 'timestamp without time zone' THEN 'timestamp' WHEN 'timestamp with time zone' THEN 'timestamptz' ELSE data_type END) AS TYPE_NAME, CASE data_type WHEN 'int4' THEN 10 WHEN 'bit' THEN 1 WHEN 'bool' THEN 1 WHEN 'boolean' THEN 1 WHEN 'varchar' THEN character_maximum_length WHEN 'character varying' THEN character_maximum_length WHEN 'char' THEN character_maximum_length WHEN 'character' THEN character_maximum_length WHEN 'nchar' THEN character_maximum_length WHEN 'bpchar' THEN character_maximum_length WHEN 'nvarchar' THEN character_maximum_length WHEN 'date' THEN 13 WHEN 'time' THEN 15  WHEN 'time without time zone' THEN 15  WHEN 'timetz' THEN 21  WHEN 'time with time zone' THEN 21  WHEN 'timestamp' THEN 29 WHEN 'timestamp without time zone' THEN 29 WHEN 'timestamptz' THEN 35 WHEN 'timestamp with time zone' THEN 35 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 10 WHEN 'int' THEN 10 WHEN 'int4' THEN 10 WHEN 'bigint' THEN 19 WHEN 'int8' THEN 19 WHEN 'decimal' THEN numeric_precision WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'float' THEN 17 WHEN 'numeric' THEN numeric_precision WHEN '_float4' THEN 8 WHEN 'oid' THEN 10 WHEN '_int4' THEN 10 WHEN '_int2' THEN 5 WHEN 'geometry' THEN NULL WHEN 'super' THEN NULL WHEN 'varbyte' THEN NULL WHEN 'geography' THEN NULL ELSE 2147483647 END AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, CASE data_type WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'numeric' THEN numeric_scale WHEN 'time' THEN 6 WHEN 'time without time zone' THEN 6 WHEN 'timetz' THEN 6 WHEN 'time with time zone' THEN 6 WHEN 'timestamp' THEN 6 WHEN 'timestamp without time zone' THEN 6 WHEN 'timestamptz' THEN 6 WHEN 'timestamp with time zone' THEN 6 WHEN 'geometry' THEN NULL WHEN 'super' THEN NULL WHEN 'varbyte' THEN NULL WHEN 'geography' THEN NULL ELSE 0 END AS DECIMAL_DIGITS, CASE data_type WHEN 'varbyte' THEN 2 WHEN 'geography' THEN 2 ELSE 10 END AS NUM_PREC_RADIX, CASE is_nullable WHEN 'YES' THEN 1 WHEN 'NO' THEN 0 ELSE 2 end AS NULLABLE, REMARKS, column_default AS COLUMN_DEF, CAST(CASE regexp_replace(data_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 12 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'time' THEN 92  WHEN 'time without time zone' THEN 92  WHEN 'timetz' THEN 2013  WHEN 'time with time zone' THEN 2013  WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamptz' THEN 2014 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 WHEN 'geometry' THEN -4 WHEN 'super' THEN -16 WHEN 'varbyte' THEN -4 WHEN 'geography' THEN -4 ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE data_type WHEN 'int4' THEN 10 WHEN 'bit' THEN 1 WHEN 'bool' THEN 1 WHEN 'boolean' THEN 1 WHEN 'varchar' THEN character_maximum_length WHEN 'character varying' THEN character_maximum_length WHEN 'char' THEN character_maximum_length WHEN 'character' THEN character_maximum_length WHEN 'nchar' THEN character_maximum_length WHEN 'bpchar' THEN character_maximum_length WHEN 'nvarchar' THEN character_maximum_length WHEN 'date' THEN 13 WHEN 'time' THEN 15 WHEN 'time without time zone' THEN 15 WHEN 'timetz' THEN 21 WHEN 'time with time zone' THEN 21 WHEN 'timestamp' THEN 29 WHEN 'timestamp without time zone' THEN 29 WHEN 'timestamptz' THEN 35 WHEN 'timestamp with time zone' THEN 35 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 10 WHEN 'int' THEN 10 WHEN 'int4' THEN 10 WHEN 'bigint' THEN 19 WHEN 'int8' THEN 19 WHEN 'decimal' THEN numeric_precision WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'float' THEN 17 WHEN 'numeric' THEN numeric_precision WHEN '_float4' THEN 8 WHEN 'oid' THEN 10 WHEN '_int4' THEN 10 WHEN '_int2' THEN 5 WHEN 'geometry' THEN NULL WHEN 'super' THEN NULL WHEN 'varbyte' THEN NULL WHEN 'geography' THEN NULL ELSE 2147483647 END AS CHAR_OCTET_LENGTH, ordinal_position AS ORDINAL_POSITION, is_nullable AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, CASE WHEN domain_name is not null THEN data_type END AS SOURCE_DATA_TYPE, CASE WHEN left(column_default, 10) = '\\\"identity\\\"' THEN 'YES' WHEN left(column_default, 16) = 'default_identity' THEN 'YES'  ELSE 'NO' END AS IS_AUTOINCREMENT, IS_AUTOINCREMENT AS IS_GENERATEDCOLUMN FROM svv_columns");
        result.append(" WHERE true ");
        result.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            result.append(" AND table_schema LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            result.append(" AND table_name LIKE " + this.escapeQuotes(tableNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            result.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        result.append(" ORDER BY table_schem,table_name,ORDINAL_POSITION ");
        return result.toString();
    }

    private String buildExternalSchemaColumnsQuery(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String unknownColumnSize = "2147483647";
        StringBuilder result = new StringBuilder(8192);
        result.append("SELECT current_database()::varchar(128) AS TABLE_CAT, schemaname AS TABLE_SCHEM, tablename AS TABLE_NAME, columnname AS COLUMN_NAME, CAST(CASE WHEN external_type = 'text' THEN 12 WHEN external_type = 'bit' THEN -7 WHEN external_type = 'bool' THEN -7 WHEN external_type = 'boolean' THEN -7 WHEN left(external_type, 7) = 'varchar' THEN 12 WHEN left(external_type, 17) = 'character varying' THEN 12 WHEN left(external_type, 4) = 'char' THEN 1 WHEN left(external_type, 9) = 'character' THEN 1 WHEN left(external_type, 5) = 'nchar' THEN 1 WHEN left(external_type, 6) = 'bpchar' THEN 1 WHEN left(external_type, 8) = 'nvarchar' THEN 12 WHEN external_type = '\"char\"' THEN 1 WHEN external_type = 'date' THEN 91 WHEN external_type = 'time' THEN 92  WHEN external_type = 'time without time zone' THEN 92  WHEN external_type = 'timetz' THEN 2013  WHEN external_type = 'time with time zone' THEN 2013  WHEN external_type = 'timestamp' THEN 93 WHEN external_type = 'timestamp without time zone' THEN 93 WHEN external_type = 'timestamptz' THEN 2014 WHEN external_type = 'timestamp with time zone' THEN 2014 WHEN external_type = 'smallint' THEN 5 WHEN external_type = 'int2' THEN 5 WHEN external_type = '_int2' THEN 5 WHEN external_type = 'integer' THEN 4 WHEN external_type = 'int' THEN 4 WHEN external_type = 'int4' THEN 4 WHEN external_type = '_int4' THEN 4 WHEN external_type = 'bigint' THEN -5 WHEN external_type = 'int8' THEN -5 WHEN left(external_type, 7) = 'decimal' THEN 2 WHEN external_type = 'real' THEN 7 WHEN external_type = 'float4' THEN 7 WHEN external_type = '_float4' THEN 7 WHEN external_type = 'double' THEN 8 WHEN external_type = 'double precision' THEN 8 WHEN external_type = 'float8' THEN 8 WHEN external_type = '_float8' THEN 8 WHEN external_type = 'float' THEN 6 WHEN left(external_type, 7) = 'numeric' THEN 2 WHEN external_type = 'bytea' THEN -2 WHEN external_type = 'oid' THEN -5 WHEN external_type = 'name' THEN 12 WHEN external_type = 'ARRAY' THEN 2003 WHEN external_type = 'geometry' THEN -4 WHEN external_type = 'super' THEN -16 WHEN external_type = 'varbyte' THEN -4 WHEN external_type = 'geography' THEN -4 ELSE 1111 END AS SMALLINT) AS DATA_TYPE, CASE WHEN left(external_type, 17) = 'character varying' THEN 'varchar' WHEN left(external_type, 7) = 'varchar' THEN 'varchar' WHEN left(external_type, 4) = 'char' THEN 'char' WHEN left(external_type, 7) = 'decimal' THEN 'numeric' WHEN left(external_type, 7) = 'numeric' THEN 'numeric' WHEN external_type = 'double' THEN 'double precision' WHEN external_type = 'time without time zone' THEN 'time' WHEN external_type = 'time with time zone' THEN 'timetz' WHEN external_type = 'timestamp without time zone' THEN 'timestamp' WHEN external_type = 'timestamp with time zone' THEN 'timestamptz' ELSE external_type END AS TYPE_NAME, CASE WHEN external_type = 'int4' THEN 10 WHEN external_type = 'bit' THEN 1 WHEN external_type = 'bool' THEN 1 WHEN external_type = 'boolean' THEN 1 WHEN left(external_type, 7) = 'varchar'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 7) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 7)   END::integer  WHEN left(external_type, 17) = 'character varying'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 17) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 17)   END::integer  WHEN left(external_type, 4) = 'char'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 4) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 4)   END::integer  WHEN left(external_type, 9) = 'character' \t THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 9) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 9)   END::integer  WHEN left(external_type, 5) = 'nchar'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 5) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 5)   END::integer  WHEN left(external_type, 6) = 'bpchar' \t THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 6) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 6)   END::integer  WHEN left(external_type, 8) = 'nvarchar'   THEN CASE     WHEN regexp_instr(external_type, '\\\\(', 8) = 0 THEN '0'     ELSE regexp_substr(external_type, '[0-9]+', 8)   END::integer  WHEN external_type = 'date' THEN 13  WHEN external_type = 'time' THEN 15  WHEN external_type = 'time without time zone' THEN 15  WHEN external_type = 'timetz' THEN 21  WHEN external_type = 'time with time zone' THEN 21  WHEN external_type = 'timestamp' THEN 29  WHEN external_type = 'timestamp without time zone' THEN 29 WHEN external_type = 'timestamptz' THEN 35 WHEN external_type = 'timestamp with time zone' THEN 35 WHEN external_type = 'smallint' THEN 5 WHEN external_type = 'int2' THEN 5 WHEN external_type = 'integer' THEN 10 WHEN external_type = 'int' THEN 10 WHEN external_type = 'int4' THEN 10 WHEN external_type = 'bigint' THEN 19 WHEN external_type = 'int8' THEN 19 WHEN left(external_type, 7) = 'decimal' THEN isnull(nullif(regexp_substr(external_type, '[0-9]+', 7),''),'0')::integer WHEN external_type = 'real' THEN 8 WHEN external_type = 'float4' THEN 8 WHEN external_type = '_float4' THEN 8 WHEN external_type = 'double' THEN 17 WHEN external_type = 'double precision' THEN 17 WHEN external_type = 'float8' THEN 17 WHEN external_type = '_float8' THEN 17 WHEN external_type = 'float' THEN 17 WHEN left(external_type, 7) = 'numeric' THEN isnull(nullif(regexp_substr(external_type, '[0-9]+', 7),''),'0')::integer WHEN external_type = '_float4' THEN 8 WHEN external_type = 'oid' THEN 10 WHEN external_type = '_int4' THEN 10 WHEN external_type = '_int2' THEN 5 WHEN external_type = 'geometry' THEN NULL WHEN external_type = 'super' THEN NULL WHEN external_type = 'varbyte' THEN NULL WHEN external_type = 'geography' THEN NULL ELSE 2147483647 END AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, CASE WHEN external_type = 'real'THEN 8 WHEN external_type = 'float4' THEN 8 WHEN external_type = 'double' THEN 17 WHEN external_type = 'double precision' THEN 17 WHEN external_type = 'float8' THEN 17 WHEN left(external_type, 7) = 'numeric' THEN isnull(nullif(regexp_substr(external_type, '[0-9]+', 11),''),'0')::integer WHEN left(external_type, 7) = 'decimal' THEN isnull(nullif(regexp_substr(external_type, '[0-9]+', 11),''),'0')::integer WHEN external_type = 'time' THEN 6  WHEN external_type = 'time without time zone' THEN 6  WHEN external_type = 'timetz' THEN 6  WHEN external_type = 'time with time zone' THEN 6  WHEN external_type = 'timestamp' THEN 6 WHEN external_type = 'timestamp without time zone' THEN 6 WHEN external_type = 'timestamptz' THEN 6 WHEN external_type = 'timestamp with time zone' THEN 6 WHEN external_type = 'geometry' THEN NULL WHEN external_type = 'super' THEN NULL WHEN external_type = 'varbyte' THEN NULL WHEN external_type = 'geography' THEN NULL ELSE 0 END AS DECIMAL_DIGITS, CASE WHEN external_type = 'varbyte' THEN 2 WHEN external_type = 'geography' THEN 2 ELSE 10 END AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, CAST(CASE WHEN external_type = 'text' THEN 12 WHEN external_type = 'bit' THEN -7 WHEN external_type = 'bool' THEN -7 WHEN external_type = 'boolean' THEN -7 WHEN left(external_type, 7) = 'varchar' THEN 12 WHEN left(external_type, 17) = 'character varying' THEN 12 WHEN left(external_type, 4) = 'char' THEN 1 WHEN left(external_type, 9) = 'character' THEN 1 WHEN left(external_type, 5) = 'nchar' THEN 1 WHEN left(external_type, 6) = 'bpchar' THEN 1 WHEN left(external_type, 8) = 'nvarchar' THEN 12 WHEN external_type = '\"char\"' THEN 1 WHEN external_type = 'date' THEN 91 WHEN external_type = 'time' THEN 92  WHEN external_type = 'time without time zone' THEN 92  WHEN external_type = 'timetz' THEN 2013  WHEN external_type = 'time with time zone' THEN 2013  WHEN external_type = 'timestamp' THEN 93 WHEN external_type = 'timestamp without time zone' THEN 93 WHEN external_type = 'timestamptz' THEN 2014 WHEN external_type = 'timestamp with time zone' THEN 2014 WHEN external_type = 'smallint' THEN 5 WHEN external_type = 'int2' THEN 5 WHEN external_type = '_int2' THEN 5 WHEN external_type = 'integer' THEN 4 WHEN external_type = 'int' THEN 4 WHEN external_type = 'int4' THEN 4 WHEN external_type = '_int4' THEN 4 WHEN external_type = 'bigint' THEN -5 WHEN external_type = 'int8' THEN -5 WHEN left(external_type, 7) = 'decimal' THEN 3 WHEN external_type = 'real' THEN 7 WHEN external_type = 'float4' THEN 7 WHEN external_type = '_float4' THEN 7 WHEN external_type = 'double' THEN 8 WHEN external_type = 'double precision' THEN 8 WHEN external_type = 'float8' THEN 8 WHEN external_type = '_float8' THEN 8 WHEN external_type = 'float' THEN 6 WHEN left(external_type, 7) = 'numeric' THEN 2 WHEN external_type = 'bytea' THEN -2 WHEN external_type = 'oid' THEN -5 WHEN external_type = 'name' THEN 12 WHEN external_type = 'ARRAY' THEN 2003 WHEN external_type = 'geometry' THEN -4 WHEN external_type = 'super' THEN -16 WHEN external_type = 'varbyte' THEN -4 WHEN external_type = 'geography' THEN -4 ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE WHEN left(external_type, 7) = 'varchar'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 7) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 7)   END::integer  WHEN left(external_type, 17) = 'character varying'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 17) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 17)   END::integer  WHEN left(external_type, 4) = 'char'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 4) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 4)   END::integer  WHEN left(external_type, 9) = 'character' \t THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 9) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 9)   END::integer  WHEN left(external_type, 5) = 'nchar'   THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 5) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 5)   END::integer  WHEN left(external_type, 6) = 'bpchar' \t THEN CASE    WHEN regexp_instr(external_type, '\\\\(', 6) = 0 THEN '0'    ELSE regexp_substr(external_type, '[0-9]+', 6)   END::integer  WHEN left(external_type, 8) = 'nvarchar'   THEN CASE     WHEN regexp_instr(external_type, '\\\\(', 8) = 0 THEN '0'     ELSE regexp_substr(external_type, '[0-9]+', 8)   END::integer  WHEN external_type = 'string' THEN 16383 ELSE NULL END AS CHAR_OCTET_LENGTH, columnnum AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, 'NO' AS IS_AUTOINCREMENT, 'NO' AS IS_GENERATEDCOLUMN FROM svv_external_columns");
        result.append(" WHERE true ");
        result.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            result.append(" AND schemaname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            result.append(" AND tablename LIKE " + this.escapeQuotes(tableNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            result.append(" AND columnname LIKE " + this.escapeQuotes(columnNamePattern));
        }
        result.append(" ORDER BY table_schem,table_name,ORDINAL_POSITION ");
        return result.toString();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("TABLE_CAT", 1043);
        f[1] = new Field("TABLE_SCHEM", 1043);
        f[2] = new Field("TABLE_NAME", 1043);
        f[3] = new Field("COLUMN_NAME", 1043);
        f[4] = new Field("GRANTOR", 1043);
        f[5] = new Field("GRANTEE", 1043);
        f[6] = new Field("PRIVILEGE", 1043);
        f[7] = new Field("IS_GRANTABLE", 1043);
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl,  a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c,  pg_catalog.pg_user u, pg_catalog.pg_attribute a  WHERE c.relnamespace = n.oid  AND c.relowner = u.usesysid  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            sql = sql + " AND c.relname = " + this.escapeQuotes(table);
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            sql = sql + " AND a.attname LIKE " + this.escapeQuotes(columnNamePattern);
        }
        sql = sql + " ORDER BY attname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schemaName = rs.getBytes("nspname");
            byte[] tableName = rs.getBytes("relname");
            byte[] column = rs.getBytes("attname");
            String owner = rs.getString("usename");
            String relAcl = rs.getString("relacl");
            Map<String, Map<String, List<String[]>>> permissions = this.parseACL(relAcl, owner);
            Object[] permNames = permissions.keySet().toArray(new String[0]);
            Arrays.sort(permNames);
            for (Object permName : permNames) {
                byte[] privilege = this.connection.encodeString((String)permName);
                Map<String, List<String[]>> grantees = permissions.get(permName);
                for (Map.Entry<String, List<String[]>> userToGrantable : grantees.entrySet()) {
                    List<String[]> grantor = userToGrantable.getValue();
                    String grantee = userToGrantable.getKey();
                    for (String[] grants : grantor) {
                        String grantable = owner.equals(grantee) ? "YES" : grants[1];
                        byte[][] tuple = new byte[][]{this.connection.encodeString(this.connection.getCatalog()), schemaName, tableName, column, this.connection.encodeString(grants[0]), this.connection.encodeString(grantee), privilege, this.connection.encodeString(grantable)};
                        v.add(new Tuple(tuple));
                    }
                }
            }
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] f = new Field[7];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("TABLE_CAT", 1043);
        f[1] = new Field("TABLE_SCHEM", 1043);
        f[2] = new Field("TABLE_NAME", 1043);
        f[3] = new Field("GRANTOR", 1043);
        f[4] = new Field("GRANTEE", 1043);
        f[5] = new Field("PRIVILEGE", 1043);
        f[6] = new Field("IS_GRANTABLE", 1043);
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u  WHERE c.relnamespace = n.oid  AND c.relowner = u.usesysid  AND c.relkind IN ('r','p','v','m','f') ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            sql = sql + " AND c.relname LIKE " + this.escapeQuotes(tableNamePattern);
        }
        sql = sql + " ORDER BY nspname, relname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] table = rs.getBytes("relname");
            String owner = rs.getString("usename");
            String acl = rs.getString("relacl");
            Map<String, Map<String, List<String[]>>> permissions = this.parseACL(acl, owner);
            Object[] permNames = permissions.keySet().toArray(new String[0]);
            Arrays.sort(permNames);
            for (Object permName : permNames) {
                byte[] privilege = this.connection.encodeString((String)permName);
                Map<String, List<String[]>> grantees = permissions.get(permName);
                for (Map.Entry<String, List<String[]>> userToGrantable : grantees.entrySet()) {
                    List<String[]> grants = userToGrantable.getValue();
                    String granteeUser = userToGrantable.getKey();
                    for (String[] grantTuple : grants) {
                        String grantor = grantTuple[0] == null ? owner : grantTuple[0];
                        String grantable = owner.equals(granteeUser) ? "YES" : grantTuple[1];
                        byte[][] tuple = new byte[][]{this.connection.encodeString(this.connection.getCatalog()), schema, table, this.connection.encodeString(grantor), this.connection.encodeString(granteeUser), privilege, this.connection.encodeString(grantable)};
                        v.add(new Tuple(tuple));
                    }
                }
            }
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    private static List<String> parseACLArray(String aclString) {
        int i;
        ArrayList<String> acls = new ArrayList<String>();
        if (aclString == null || aclString.isEmpty()) {
            return acls;
        }
        boolean inQuotes = false;
        int beginIndex = 1;
        int prevChar = 32;
        for (i = beginIndex; i < aclString.length(); ++i) {
            char c = aclString.charAt(i);
            if (c == '\"' && prevChar != 92) {
                inQuotes = !inQuotes;
            } else if (c == ',' && !inQuotes) {
                acls.add(aclString.substring(beginIndex, i));
                beginIndex = i + 1;
            }
            prevChar = c;
        }
        acls.add(aclString.substring(beginIndex, aclString.length() - 1));
        for (i = 0; i < acls.size(); ++i) {
            String acl = (String)acls.get(i);
            if (!acl.startsWith("\"") || !acl.endsWith("\"")) continue;
            acl = acl.substring(1, acl.length() - 1);
            acls.set(i, acl);
        }
        return acls;
    }

    private static void addACLPrivileges(String acl, Map<String, Map<String, List<String[]>>> privileges) {
        String privs;
        int equalIndex = acl.lastIndexOf("=");
        int slashIndex = acl.lastIndexOf("/");
        if (equalIndex == -1) {
            return;
        }
        String user = acl.substring(0, equalIndex);
        String grantor = null;
        if (user.isEmpty()) {
            user = "PUBLIC";
        }
        if (slashIndex != -1) {
            privs = acl.substring(equalIndex + 1, slashIndex);
            grantor = acl.substring(slashIndex + 1, acl.length());
        } else {
            privs = acl.substring(equalIndex + 1, acl.length());
        }
        for (int i = 0; i < privs.length(); ++i) {
            List<String[]> permissionByGrantor;
            String sqlpriv;
            char c = privs.charAt(i);
            if (c == '*') continue;
            String grantable = i < privs.length() - 1 && privs.charAt(i + 1) == '*' ? "YES" : "NO";
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'p': 
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'D': {
                    sqlpriv = "TRUNCATE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            Map<String, List<String[]>> usersWithPermission = privileges.get(sqlpriv);
            String[] grant = new String[]{grantor, grantable};
            if (usersWithPermission == null) {
                usersWithPermission = new HashMap<String, List<String[]>>();
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                privileges.put(sqlpriv, usersWithPermission);
                continue;
            }
            permissionByGrantor = usersWithPermission.get(user);
            if (permissionByGrantor == null) {
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                continue;
            }
            permissionByGrantor.add(grant);
        }
    }

    public Map<String, Map<String, List<String[]>>> parseACL(String aclArray, String owner) {
        if (aclArray == null) {
            String perms = "arwdxt";
            aclArray = "{" + owner + "=" + perms + "/" + owner + "}";
        }
        List<String> acls = RedshiftDatabaseMetaData.parseACLArray(aclArray);
        HashMap<String, Map<String, List<String[]>>> privileges = new HashMap<String, Map<String, List<String[]>>>();
        for (String acl : acls) {
            RedshiftDatabaseMetaData.addACLPrivileges(acl, privileges);
        }
        return privileges;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("SCOPE", 21);
        f[1] = new Field("COLUMN_NAME", 1043);
        f[2] = new Field("DATA_TYPE", 21);
        f[3] = new Field("TYPE_NAME", 1043);
        f[4] = new Field("COLUMN_SIZE", 23);
        f[5] = new Field("BUFFER_LENGTH", 23);
        f[6] = new Field("DECIMAL_DIGITS", 21);
        f[7] = new Field("PSEUDO_COLUMN", 21);
        String sql = "SELECT a.attname, a.atttypid, a.atttypmod FROM  pg_catalog.pg_namespace n,  pg_catalog.pg_class ct,  pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid  AND a.attrelid=ci.oid AND i.indisprimary  AND ct.relnamespace = n.oid ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            sql = sql + " AND ct.relname = " + this.escapeQuotes(table);
        }
        sql = sql + " ORDER BY a.attnum ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[8][];
            int typeOid = (int)rs.getLong("atttypid");
            int typeMod = rs.getInt("atttypmod");
            int decimalDigits = this.connection.getTypeInfo().getScale(typeOid, typeMod);
            int columnSize = this.connection.getTypeInfo().getPrecision(typeOid, typeMod);
            if (columnSize == 0) {
                columnSize = this.connection.getTypeInfo().getDisplaySize(typeOid, typeMod);
            }
            tuple[0] = this.connection.encodeString(Integer.toString(scope));
            tuple[1] = rs.getBytes("attname");
            tuple[2] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(typeOid)));
            tuple[3] = this.connection.encodeString(this.connection.getTypeInfo().getRSType(typeOid));
            tuple[4] = this.connection.encodeString(Integer.toString(columnSize));
            tuple[5] = null;
            tuple[6] = this.connection.encodeString(Integer.toString(decimalDigits));
            tuple[7] = this.connection.encodeString(Integer.toString(1));
            v.add(new Tuple(tuple));
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("SCOPE", 21);
        f[1] = new Field("COLUMN_NAME", 1043);
        f[2] = new Field("DATA_TYPE", 21);
        f[3] = new Field("TYPE_NAME", 1043);
        f[4] = new Field("COLUMN_SIZE", 23);
        f[5] = new Field("BUFFER_LENGTH", 23);
        f[6] = new Field("DECIMAL_DIGITS", 21);
        f[7] = new Field("PSEUDO_COLUMN", 21);
        byte[][] tuple = new byte[][]{null, this.connection.encodeString("ctid"), this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType("tid"))), this.connection.encodeString("tid"), null, null, null, this.connection.encodeString(Integer.toString(2))};
        v.add(new Tuple(tuple));
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT current_database() AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  ct.relname AS TABLE_NAME,   a.attname AS COLUMN_NAME,   a.attnum AS KEY_SEQ,   ci.relname AS PK_NAME   FROM  pg_catalog.pg_namespace n,  pg_catalog.pg_class ct,  pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid  AND a.attrelid=ci.oid AND i.indisprimary  AND ct.relnamespace = n.oid ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            sql = sql + " AND ct.relname = " + this.escapeQuotes(table);
        }
        sql = sql + " ORDER BY table_name, pk_name, key_seq";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String sql = "SELECT current_database() AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, current_database() AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n),  pg_catalog.pg_class pkic";
        sql = sql + ", pg_catalog.pg_depend dep ";
        sql = sql + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' AND pkic.relkind = 'i' ";
        sql = sql + " AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid ";
        sql = sql + this.getCatalogFilterCondition(primaryCatalog);
        if (primarySchema != null && !primarySchema.isEmpty()) {
            sql = sql + " AND pkn.nspname = " + this.escapeQuotes(primarySchema);
        }
        if (foreignSchema != null && !foreignSchema.isEmpty()) {
            sql = sql + " AND fkn.nspname = " + this.escapeQuotes(foreignSchema);
        }
        if (primaryTable != null && !primaryTable.isEmpty()) {
            sql = sql + " AND pkc.relname = " + this.escapeQuotes(primaryTable);
        }
        if (foreignTable != null && !foreignTable.isEmpty()) {
            sql = sql + " AND fkc.relname = " + this.escapeQuotes(foreignTable);
        }
        sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,con.conname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname, con.conname,pos.n";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        Field[] f = new Field[18];
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        f[0] = new Field("TYPE_NAME", 1043);
        f[1] = new Field("DATA_TYPE", 21);
        f[2] = new Field("PRECISION", 23);
        f[3] = new Field("LITERAL_PREFIX", 1043);
        f[4] = new Field("LITERAL_SUFFIX", 1043);
        f[5] = new Field("CREATE_PARAMS", 1043);
        f[6] = new Field("NULLABLE", 21);
        f[7] = new Field("CASE_SENSITIVE", 16);
        f[8] = new Field("SEARCHABLE", 21);
        f[9] = new Field("UNSIGNED_ATTRIBUTE", 16);
        f[10] = new Field("FIXED_PREC_SCALE", 16);
        f[11] = new Field("AUTO_INCREMENT", 16);
        f[12] = new Field("LOCAL_TYPE_NAME", 1043);
        f[13] = new Field("MINIMUM_SCALE", 21);
        f[14] = new Field("MAXIMUM_SCALE", 21);
        f[15] = new Field("SQL_DATA_TYPE", 23);
        f[16] = new Field("SQL_DATETIME_SUB", 23);
        f[17] = new Field("NUM_PREC_RADIX", 23);
        String sql = "SELECT t.typname,t.oid FROM pg_catalog.pg_type t WHERE  t.typname in ('bool','char','int8','int2','int4','float4','float8','bpchar','varchar','date','time','timestamp','timestamptz','numeric','refcursor','geometry','super','varbyte','geography')";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        byte[] bZero = this.connection.encodeString("0");
        byte[] b10 = this.connection.encodeString("10");
        byte[] b2 = this.connection.encodeString("2");
        byte[] bf = this.connection.encodeString("f");
        byte[] bt = this.connection.encodeString("t");
        byte[] bliteral = this.connection.encodeString("'");
        byte[] bNullable = this.connection.encodeString(Integer.toString(1));
        byte[] bSearchable = this.connection.encodeString(Integer.toString(3));
        TypeInfo ti = this.connection.getTypeInfo();
        if (ti instanceof TypeInfoCache) {
            ((TypeInfoCache)ti).cacheSQLTypes(this.connection.getLogger());
        }
        while (rs.next()) {
            byte[][] tuple = new byte[19][];
            String typname = rs.getString(1);
            int typeOid = (int)rs.getLong(2);
            tuple[0] = this.connection.encodeString(typname);
            int sqlType = this.connection.getTypeInfo().getSQLType(typname);
            tuple[1] = this.connection.encodeString(Integer.toString(sqlType));
            tuple[18] = BigInteger.valueOf(sqlType).toByteArray();
            tuple[2] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getMaximumPrecision(typeOid)));
            if (this.connection.getTypeInfo().requiresQuotingSqlType(sqlType)) {
                tuple[3] = bliteral;
                tuple[4] = bliteral;
            }
            tuple[6] = bNullable;
            tuple[7] = this.connection.getTypeInfo().isCaseSensitive(typeOid) ? bt : bf;
            tuple[8] = bSearchable;
            tuple[9] = this.connection.getTypeInfo().isSigned(typeOid) ? bf : bt;
            tuple[10] = bf;
            tuple[11] = bf;
            tuple[13] = bZero;
            tuple[14] = typeOid == 1700 ? this.connection.encodeString("1000") : bZero;
            tuple[17] = typeOid == 6551 || typeOid == 3001 ? b2 : b10;
            v.add(new Tuple(tuple));
        }
        rs.close();
        stmt.close();
        Collections.sort(v, new Comparator<Tuple>(){

            @Override
            public int compare(Tuple o1, Tuple o2) {
                int i2;
                int i1 = ByteConverter.bytesToInt(o1.get(18));
                return i1 < (i2 = ByteConverter.bytesToInt(o2.get(18))) ? -1 : (i1 == i2 ? 0 : 1);
            }
        });
        ResultSet rc = ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String sql = "SELECT '' AS TABLE_CAT, '' AS TABLE_SCHEM, '' AS TABLE_NAME, cast('t' as boolean) AS NON_UNIQUE, '' AS INDEX_QUALIFIER, '' AS INDEX_NAME, cast(0 as smallint) AS TYPE, cast(1 as smallint) AS ORDINAL_POSITION, '' AS COLUMN_NAME, NULL AS ASC_OR_DESC, 0 AS CARDINALITY, 0 AS PAGES, '' AS FILTER_CONDITION WHERE (1 = 0)";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        return concurrency != 1008;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "select current_database() as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, pg_catalog.obj_description(t.oid, 'pg_type')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        StringBuilder sqlwhen = new StringBuilder();
        Iterator<String> i = this.connection.getTypeInfo().getRSTypeNamesWithSQLTypes();
        while (i.hasNext()) {
            String pgType = i.next();
            int sqlType = this.connection.getTypeInfo().getSQLType(pgType);
            sqlwhen.append(" when typname = ").append(this.escapeQuotes(pgType)).append(" then ").append(sqlType);
        }
        sql = sql + sqlwhen.toString();
        sql = sql + " else 1111 end from pg_type where oid=t.typbasetype) else null end as base_type from pg_catalog.pg_type t, pg_catalog.pg_namespace n where t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'";
        StringBuilder toAdd = new StringBuilder();
        if (types != null) {
            toAdd.append(" and (false ");
            block5: for (Object type : (String)types) {
                switch (type) {
                    case 2002: {
                        toAdd.append(" or t.typtype = 'c'");
                        continue block5;
                    }
                    case 2001: {
                        toAdd.append(" or t.typtype = 'd'");
                    }
                }
            }
            toAdd.append(" ) ");
        } else {
            toAdd.append(" and t.typtype IN ('c','d') ");
        }
        if (typeNamePattern != null) {
            int firstQualifier = typeNamePattern.indexOf(46);
            int secondQualifier = typeNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                schemaPattern = firstQualifier != secondQualifier ? typeNamePattern.substring(firstQualifier + 1, secondQualifier) : typeNamePattern.substring(0, firstQualifier);
                typeNamePattern = typeNamePattern.substring(secondQualifier + 1);
            }
            toAdd.append(" and t.typname like ").append(this.escapeQuotes(typeNamePattern));
        }
        toAdd.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null) {
            toAdd.append(" and n.nspname like ").append(this.escapeQuotes(schemaPattern));
        }
        sql = sql + toAdd.toString();
        sql = sql + " order by data_type, type_schem, type_name";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Field[] f = new Field[]{new Field("NAME", 1043), new Field("MAX_LEN", 23), new Field("DEFAULT_VALUE", 1043), new Field("DESCRIPTION", 1043)};
        ArrayList<Tuple> v = new ArrayList<Tuple>();
        byte[][] tuple = new byte[][]{this.connection.encodeString("ApplicationName"), this.connection.encodeString(Integer.toString(this.getMaxNameLength())), null, this.connection.encodeString("The name of the application currently utilizing the connection.")};
        v.add(new Tuple(tuple));
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, functionNamePattern);
        }
        String sql = "SELECT routine_catalog AS FUNCTION_CAT,  routine_schema AS FUNCTION_SCHEM,  routine_name AS FUNCTION_NAME, CAST('' AS VARCHAR(256)) AS REMARKS,  CASE data_type WHEN 'USER-DEFINED' THEN 0 WHEN 'record' THEN 2 ELSE 1 END AS FUNCTION_TYPE,  specific_name AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE routine_type LIKE 'FUNCTION' ";
        sql = sql + this.getCatalogFilterCondition(catalog);
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND  routine_schema LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
            sql = sql + " AND  routine_name LIKE " + this.escapeQuotes(functionNamePattern);
        }
        sql = sql + " ORDER BY routine_catalog, routine_schema, routine_name ";
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        int columns = 17;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        String unknownColumnSize = "2147483647";
        String superMaxLength = "4194304 ";
        String varbyteMaxLength = "1000000 ";
        String geographyMaxLength = "1000000 ";
        StringBuilder functionColumnQuery = new StringBuilder();
        functionColumnQuery.append("SELECT PROCEDURE_CAT AS FUNCTION_CAT,  PROCEDURE_SCHEM AS FUNCTION_SCHEM,  PROCEDURE_NAME AS FUNCTION_NAME, COLUMN_NAME,  COLUMN_TYPE,  DATA_TYPE,  TYPE_NAME,  COLUMN_SIZE AS PRECISION,  LENGTH ,  DECIMAL_DIGITS AS SCALE,  NUM_PREC_RADIX AS RADIX,  NULLABLE,  REMARKS,  CHAR_OCTET_LENGTH,  ORDINAL_POSITION,  IS_NULLABLE,  SPECIFIC_NAME   FROM (");
        functionColumnQuery.append("SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(CASE ((array_upper(proargnames, 0) - array_lower(proargnames, 0)) > 0)  WHEN 't' THEN proargnames[array_upper(proargnames, 1)]  ELSE ''  END AS VARCHAR(256)) AS COLUMN_NAME,  CAST(CASE p.proretset  WHEN 't' THEN 3  ELSE 5  END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN 1 WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -1  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN 1000000  WHEN 'geography' THEN 1000000  ELSE 2147483647 END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN 1000000  WHEN 'geography' THEN 1000000  END AS LENGTH,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'smallint' THEN 0  WHEN 'int2' THEN 0  WHEN 'integer' THEN 0  WHEN 'int' THEN 0  WHEN 'int4' THEN 0  WHEN 'bigint' THEN 0  WHEN 'int8' THEN 0  WHEN 'decimal' THEN 0  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float' THEN 17  WHEN 'float8' THEN 17  WHEN 'numeric' THEN 0  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  ELSE NULL END AS SMALLINT) AS DECIMAL_DIGITS,  10 AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST('' AS VARCHAR(256)) AS REMARKS,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST('' AS VARCHAR(256)) AS IS_NULLABLE,  p.proname || '_' || p.prooid AS SPECIFIC_NAME,  p.prooid as PROOID,  -1 AS PROARGINDEX  FROM pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  WHERE pg_catalog.format_type(p.prorettype, NULL) != 'void'  AND prokind = 'f' ");
        functionColumnQuery.append(this.getCatalogFilterCondition(catalog));
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            functionColumnQuery.append(" AND n.nspname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
            functionColumnQuery.append(" AND p.proname LIKE " + this.escapeQuotes(functionNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            functionColumnQuery.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        functionColumnQuery.append(" UNION ALL ");
        functionColumnQuery.append(" SELECT DISTINCT current_database() AS PROCEDURE_CAT,  PROCEDURE_SCHEM,  PROCEDURE_NAME, CAST(CASE (char_length(COLUMN_NAME) > 0) WHEN 't' THEN COLUMN_NAME ELSE '' END AS VARCHAR(256)) AS COLUMN_NAME,  CAST( CASE COLUMN_TYPE  WHEN 105 THEN 1  WHEN 98 THEN 2  WHEN 111 THEN 4  ELSE 5 END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE DATA_TYPE  WHEN 'text' THEN 12  WHEN 'bit' THEN  -7  WHEN 'bool' THEN  -7  WHEN 'boolean' THEN  -7  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN '\"char\"' THEN  1  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN 1  WHEN 'bpchar' THEN 1  WHEN 'nvarchar' THEN 12  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'timestamp without time zone' THEN 93  WHEN 'timestamptz' THEN 2014  WHEN 'timestamp with time zone' THEN 2014  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'decimal' THEN 3  WHEN 'numeric' THEN 2  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN 'ARRAY' THEN 2003  WHEN 'geometry' THEN -4  WHEN 'super' THEN -1  WHEN 'varbyte' THEN -4  WHEN 'geography' THEN -4  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  TYPE_NAME,  CASE COLUMN_SIZE  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN 1000000  WHEN 'geography' THEN 1000000  ELSE 2147483647 END AS COLUMN_SIZE,  CASE LENGTH  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  WHEN 'geometry' THEN NULL  WHEN 'super' THEN 4194304  WHEN 'varbyte' THEN 1000000  WHEN 'geography' THEN 1000000  END AS LENGTH,  CAST(CASE DECIMAL_DIGITS  WHEN 'smallint' THEN 0  WHEN 'int2' THEN 0  WHEN 'integer' THEN 0  WHEN 'int' THEN 0  WHEN 'int4' THEN 0  WHEN 'bigint' THEN 0  WHEN 'int8' THEN 0  WHEN 'decimal' THEN 0  WHEN 'real' THEN 8  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 17  WHEN 'float' THEN 17  WHEN 'float8' THEN 17  WHEN 'numeric' THEN 0  WHEN 'timestamp' THEN 6  WHEN 'timestamp without time zone' THEN 6  WHEN 'timestamptz' THEN 6  WHEN 'timestamp with time zone' THEN 6  ELSE NULL END AS SMALLINT) AS DECIMAL_DIGITS,  10 AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  PROARGINDEX AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  SPECIFIC_NAME, PROOID, PROARGINDEX  FROM (  SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CASE WHEN (proallargtypes is NULL) THEN proargnames[pos+1]  ELSE proargnames[pos] END AS COLUMN_NAME, CASE WHEN proargmodes is NULL THEN 105  ELSE CAST(proargmodes[pos] AS INT) END AS COLUMN_TYPE,  CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DATA_TYPE, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL)  ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS TYPE_NAME, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS COLUMN_SIZE, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS LENGTH, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DECIMAL_DIGITS, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS RADIX, CAST(2 AS SMALLINT) AS NULLABLE, CAST(''AS VARCHAR(256)) AS REMARKS, pg_catalog.format_type(proargtypes[pos], NULL) AS CHAR_OCTET_LENGTH, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS ORDINAL_POSITION, CAST('' AS VARCHAR(256)) AS IS_NULLABLE, p.prooid AS PROOID, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN prokind = 'f' AND pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS PROARGINDEX,  p.proname || '_' || p.prooid AS SPECIFIC_NAME  FROM (pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace) LEFT JOIN (SELECT  CASE WHEN (proallargtypes IS NULL)  THEN generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1))-1 ELSE generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1)+1)-1  END AS pos FROM pg_catalog.pg_proc_info p ) AS s ON (pos >= 0 AND pos <= pronargs+1) WHERE prokind = 'f' ");
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            functionColumnQuery.append(" AND n.nspname LIKE " + this.escapeQuotes(schemaPattern));
        }
        if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
            functionColumnQuery.append(" AND p.proname LIKE " + this.escapeQuotes(functionNamePattern));
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            functionColumnQuery.append(" AND COLUMN_NAME LIKE " + this.escapeQuotes(columnNamePattern));
        }
        functionColumnQuery.append(" ) AS INPUT_PARAM_TABLE WHERE ORDINAL_POSITION IS NOT NULL ) AS RESULT_SET WHERE (DATA_TYPE != 1111 OR (TYPE_NAME IS NOT NULL AND TYPE_NAME != '-')) ORDER BY PROCEDURE_CAT ,PROCEDURE_SCHEM, PROCEDURE_NAME, PROOID, PROARGINDEX, COLUMN_TYPE DESC");
        ResultSet rc = this.createMetaDataStatement().executeQuery(functionColumnQuery.toString());
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getPseudoColumns(String, String, String, String)");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTypes(String,String,String)");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTables(String,String,String,String)");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes(String,String,String,String)");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getServerMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getServerMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getExtSchemaPatternMatch(String schemaPattern) throws SQLException {
        if (null != schemaPattern && !schemaPattern.equals("")) {
            if (this.isSingleDatabaseMetaData()) {
                String sql = "select 1 from svv_external_schemas where schemaname like " + this.escapeQuotes(schemaPattern);
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = this.connection.createStatement();
                    rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        int n = 2;
                        return n;
                    }
                    int n = 1;
                    return n;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            return 0;
        }
        return 0;
    }

    private boolean isSingleDatabaseMetaData() {
        return this.isDatabaseMetadataCurrentDbOnly() || !this.isMultiDatabasesCatalogEnableInServer();
    }

    private boolean isDatabaseMetadataCurrentDbOnly() {
        return this.connection.isDatabaseMetadataCurrentDbOnly();
    }

    private boolean isMultiDatabasesCatalogEnableInServer() {
        return this.connection.getQueryExecutor().isDatashareEnabled();
    }

    private String getCatalogFilterCondition(String catalog) throws SQLException {
        return this.getCatalogFilterCondition(catalog, true, null);
    }

    private String getCatalogFilterCondition(String catalog, boolean apiSupportedOnlyForConnectedDatabase, String databaseColName) throws SQLException {
        String catalogFilter = "";
        if (catalog != null && !catalog.isEmpty()) {
            if (this.isSingleDatabaseMetaData() || apiSupportedOnlyForConnectedDatabase) {
                catalogFilter = " AND current_database() = " + this.escapeOnlyQuotes(catalog);
            } else {
                if (databaseColName == null) {
                    databaseColName = "database_name";
                }
                catalogFilter = " AND " + databaseColName + " = " + this.escapeOnlyQuotes(catalog);
            }
        }
        return catalogFilter;
    }

    static {
        HashMap<String, String> ht = new HashMap<String, String>();
        tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new HashMap();
        tableTypeClauses.put("TYPE", ht);
        ht.put("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ");
        tableTypeClauses.put("EXTERNAL TABLE", null);
    }
}

