/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl.ipn;

import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.impl.PayLogUtil;
import com.amazon.pay.impl.ipn.NotificationVerification;
import com.amazon.pay.response.ipn.model.AuthorizationNotification;
import com.amazon.pay.response.ipn.model.BillingAgreementNotification;
import com.amazon.pay.response.ipn.model.CaptureNotification;
import com.amazon.pay.response.ipn.model.ChargebackNotification;
import com.amazon.pay.response.ipn.model.IPNMessageMetaData;
import com.amazon.pay.response.ipn.model.Notification;
import com.amazon.pay.response.ipn.model.NotificationMetaData;
import com.amazon.pay.response.ipn.model.OrderReferenceNotification;
import com.amazon.pay.response.ipn.model.ProviderCreditNotification;
import com.amazon.pay.response.ipn.model.ProviderCreditReversalNotification;
import com.amazon.pay.response.ipn.model.RefundNotification;
import com.amazon.pay.response.ipn.model.SolutionProviderMerchantNotification;
import com.amazon.pay.response.parser.AmazonValidationEventHandler;
import com.google.gson.Gson;
import java.io.StringReader;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class NotificationFactory {
    public static PayLogUtil payUtil = new PayLogUtil();

    public static Notification parseNotification(Map<String, String> headers, String body) throws AmazonClientException {
        NotificationVerification verifier = new NotificationVerification();
        verifier.verifyHeaders(headers);
        try {
            payUtil.logMessage("\n\nNotification Header:\n" + headers.toString());
        }
        catch (Exception e) {
            throw new AmazonClientException("Encountered an Exception: ", e);
        }
        Notification notification = NotificationFactory.getNotification(body);
        try {
            if (body != null) {
                payUtil.logMessage("\n\nNotification Body:\n" + body.replace("\\\\n", "\n").replace("\\\\/", "/").replace("\\\\\\\"", "\"").replace(",\\\"", ",\n    \"").replace("\"{\\\"", "\n  {\n    \"").replace("\\\"}\"", "\n  }").replace("\\\"", "\""));
            }
        }
        catch (Exception e) {
            throw new AmazonClientException("Encountered an Exception: ", e);
        }
        verifier.verifyMessage(notification);
        return notification;
    }

    private static Notification getNotification(String payLoad) {
        String notificationTypeWithSpaces;
        Notification notifData = null;
        if (payLoad == null || payLoad.isEmpty()) {
            throw new AmazonClientException("Aborting, empty payload");
        }
        String notificationDataAsJSON = payLoad;
        Map notificationDataAsMap = (Map)new Gson().fromJson(payLoad, Map.class);
        String message = (String)notificationDataAsMap.get("Message");
        Map messageDataMap = null;
        if (message != null && (messageDataMap = (Map)new Gson().fromJson(message, Map.class)) != null && (notificationTypeWithSpaces = (String)messageDataMap.get("NotificationType")) != null) {
            String notificationType = notificationTypeWithSpaces.replaceAll(" ", "");
            JAXBContext jaxbContext = null;
            try {
                if ("OrderReferenceNotification".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OrderReferenceNotification.class});
                } else if ("PaymentAuthorize".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AuthorizationNotification.class});
                } else if ("PaymentCapture".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CaptureNotification.class});
                } else if ("PaymentRefund".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RefundNotification.class});
                } else if ("BillingAgreementNotification".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BillingAgreementNotification.class});
                } else if ("ProviderCredit".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProviderCreditNotification.class});
                } else if ("ProviderCreditReversal".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProviderCreditReversalNotification.class});
                } else if ("SolutionProviderEvent".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SolutionProviderMerchantNotification.class});
                } else if ("ChargebackDetailedNotification".equalsIgnoreCase(notificationType)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChargebackNotification.class});
                } else {
                    throw new AmazonClientException("Unknown notification type: " + notificationType);
                }
                if (jaxbContext != null) {
                    String notificationData = ((String)messageDataMap.get("NotificationData")).replaceAll("xmlns(?:.*?)?=\"https://mws.amazonservices.com/ipn/OffAmazonPayments/2013-01-01\"", "");
                    StringReader reader = new StringReader(notificationData.trim());
                    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                    unmarshaller.setEventHandler((ValidationEventHandler)new AmazonValidationEventHandler());
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                    xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
                    XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
                    notifData = (Notification)unmarshaller.unmarshal(xmlStreamReader);
                    notifData.setNotificationMetadata(new NotificationMetaData(notificationDataAsMap));
                    notifData.setMessageMetaData(new IPNMessageMetaData(messageDataMap));
                    notifData.setJSON(notificationDataAsJSON);
                    notifData.setMap(notificationDataAsMap);
                }
            }
            catch (JAXBException e) {
                throw new AmazonClientException("Failed marshalling notification: " + notificationDataAsJSON, (Exception)((Object)e));
            }
            catch (XMLStreamException e) {
                throw new AmazonClientException("Failed marshalling notification: " + notificationDataAsJSON, e);
            }
        }
        return notifData;
    }
}

