/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl;

import com.amazon.pay.Client;
import com.amazon.pay.Config;
import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.exceptions.AmazonServiceException;
import com.amazon.pay.impl.PayConfig;
import com.amazon.pay.impl.Util;
import com.amazon.pay.request.AuthorizeOnBillingAgreementRequest;
import com.amazon.pay.request.AuthorizeRequest;
import com.amazon.pay.request.CancelOrderReferenceRequest;
import com.amazon.pay.request.CaptureRequest;
import com.amazon.pay.request.ChargeRequest;
import com.amazon.pay.request.CloseAuthorizationRequest;
import com.amazon.pay.request.CloseBillingAgreementRequest;
import com.amazon.pay.request.CloseOrderReferenceRequest;
import com.amazon.pay.request.ConfirmBillingAgreementRequest;
import com.amazon.pay.request.ConfirmOrderReferenceRequest;
import com.amazon.pay.request.CreateOrderReferenceForIdRequest;
import com.amazon.pay.request.GetAuthorizationDetailsRequest;
import com.amazon.pay.request.GetBillingAgreementDetailsRequest;
import com.amazon.pay.request.GetCaptureDetailsRequest;
import com.amazon.pay.request.GetMerchantAccountStatusRequest;
import com.amazon.pay.request.GetOrderReferenceDetailsRequest;
import com.amazon.pay.request.GetProviderCreditDetailsRequest;
import com.amazon.pay.request.GetProviderCreditReversalDetailsRequest;
import com.amazon.pay.request.GetRefundDetailsRequest;
import com.amazon.pay.request.ListOrderReferenceByNextTokenRequest;
import com.amazon.pay.request.ListOrderReferenceRequest;
import com.amazon.pay.request.RefundRequest;
import com.amazon.pay.request.RequestHelper;
import com.amazon.pay.request.ReverseProviderCreditRequest;
import com.amazon.pay.request.SetBillingAgreementDetailsRequest;
import com.amazon.pay.request.SetOrderAttributesRequest;
import com.amazon.pay.request.SetOrderReferenceDetailsRequest;
import com.amazon.pay.request.ValidateBillingAgreementRequest;
import com.amazon.pay.response.model.AuthorizationDetails;
import com.amazon.pay.response.model.BillingAgreementDetails;
import com.amazon.pay.response.model.CaptureDetails;
import com.amazon.pay.response.model.Environment;
import com.amazon.pay.response.model.OrderReferenceDetails;
import com.amazon.pay.response.model.RefundDetails;
import com.amazon.pay.response.parser.AuthorizeOnBillingAgreementResponseData;
import com.amazon.pay.response.parser.AuthorizeResponseData;
import com.amazon.pay.response.parser.CancelOrderReferenceResponseData;
import com.amazon.pay.response.parser.CaptureResponseData;
import com.amazon.pay.response.parser.CloseAuthorizationResponseData;
import com.amazon.pay.response.parser.CloseBillingAgreementResponseData;
import com.amazon.pay.response.parser.CloseOrderReferenceResponseData;
import com.amazon.pay.response.parser.ConfirmBillingAgreementResponseData;
import com.amazon.pay.response.parser.ConfirmOrderReferenceResponseData;
import com.amazon.pay.response.parser.CreateOrderReferenceForIdResponseData;
import com.amazon.pay.response.parser.GetAuthorizationDetailsResponseData;
import com.amazon.pay.response.parser.GetBillingAgreementDetailsResponseData;
import com.amazon.pay.response.parser.GetCaptureDetailsResponseData;
import com.amazon.pay.response.parser.GetMerchantAccountStatusResponseData;
import com.amazon.pay.response.parser.GetOrderReferenceDetailsResponseData;
import com.amazon.pay.response.parser.GetPaymentDetails;
import com.amazon.pay.response.parser.GetProviderCreditDetailsResponseData;
import com.amazon.pay.response.parser.GetProviderCreditReversalDetailsResponseData;
import com.amazon.pay.response.parser.GetRefundDetailsResponseData;
import com.amazon.pay.response.parser.GetServiceStatusResponseData;
import com.amazon.pay.response.parser.ListOrderReferenceByNextTokenResponseData;
import com.amazon.pay.response.parser.ListOrderReferenceResponseData;
import com.amazon.pay.response.parser.Parser;
import com.amazon.pay.response.parser.RefundResponseData;
import com.amazon.pay.response.parser.ResponseData;
import com.amazon.pay.response.parser.ReverseProviderCreditResponseData;
import com.amazon.pay.response.parser.SetBillingAgreementDetailsResponseData;
import com.amazon.pay.response.parser.SetOrderAttributesResponseData;
import com.amazon.pay.response.parser.SetOrderReferenceDetailsResponseData;
import com.amazon.pay.response.parser.ValidateBillingAgreementResponseData;
import com.amazon.pay.types.AmazonReferenceIdType;
import com.amazon.pay.types.ServiceConstants;
import com.amazon.pay.types.User;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PayClient
implements Client {
    private final RequestHelper helper;
    private final PayConfig payConfig;

    public PayClient(Config config) {
        this.payConfig = (PayConfig)config;
        this.helper = new RequestHelper(this.payConfig);
    }

    @Override
    public GetServiceStatusResponseData getServiceStatus() throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURLGetServiceStatus());
        return Parser.getServiceStatus(rawResponse);
    }

    @Override
    public CreateOrderReferenceForIdResponseData createOrderReferenceForId(CreateOrderReferenceForIdRequest createOrderReferenceForIdRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(createOrderReferenceForIdRequest));
        return Parser.createOrderReferenceForId(rawResponse);
    }

    @Override
    public GetOrderReferenceDetailsResponseData getOrderReferenceDetails(GetOrderReferenceDetailsRequest getOrderReferenceDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getOrderReferenceDetailsRequest));
        return Parser.getOrderReferenceDetails(rawResponse);
    }

    @Override
    public GetPaymentDetails getPaymentDetails(String orderReferenceID) throws AmazonServiceException {
        return this.getPaymentDetails(orderReferenceID, null);
    }

    @Override
    public GetPaymentDetails getPaymentDetails(String orderReferenceID, String MWSAuthToken) throws AmazonServiceException {
        GetPaymentDetails paymentDetails = new GetPaymentDetails();
        GetOrderReferenceDetailsRequest getOrderReferenceDetailsRequest = (GetOrderReferenceDetailsRequest)new GetOrderReferenceDetailsRequest(orderReferenceID).setMWSAuthToken(MWSAuthToken);
        OrderReferenceDetails orderReferenceResponse = this.getOrderReferenceDetails(getOrderReferenceDetailsRequest).getDetails();
        paymentDetails.putOrderReferenceDetails(orderReferenceID, orderReferenceResponse);
        List<String> amazon_authorization_id = orderReferenceResponse.getIdList().getMember();
        for (String authorizeID : amazon_authorization_id) {
            GetAuthorizationDetailsRequest getAuthDetailsRequest = (GetAuthorizationDetailsRequest)new GetAuthorizationDetailsRequest(authorizeID).setMWSAuthToken(MWSAuthToken);
            AuthorizationDetails responseAuthorize = this.getAuthorizationDetails(getAuthDetailsRequest).getDetails();
            paymentDetails.putAuthorizationDetails(authorizeID, responseAuthorize);
            List<String> amazon_capture_id = responseAuthorize.getIdList().getMember();
            for (String captureID : amazon_capture_id) {
                GetCaptureDetailsRequest getCaptureDetailsRequest = (GetCaptureDetailsRequest)new GetCaptureDetailsRequest(captureID).setMWSAuthToken(MWSAuthToken);
                CaptureDetails responseCapture = this.getCaptureDetails(getCaptureDetailsRequest).getDetails();
                paymentDetails.putCaptureDetails(captureID, responseCapture);
                List<String> amazon_refund_id = responseCapture.getIdList().getMember();
                for (String refundID : amazon_refund_id) {
                    GetRefundDetailsRequest getRefundDetailsRequest = (GetRefundDetailsRequest)new GetRefundDetailsRequest(refundID).setMWSAuthToken(MWSAuthToken);
                    RefundDetails responseRefund = this.getRefundDetails(getRefundDetailsRequest).getDetails();
                    paymentDetails.putRefundDetails(refundID, responseRefund);
                }
            }
        }
        return paymentDetails;
    }

    @Override
    public SetOrderReferenceDetailsResponseData setOrderReferenceDetails(SetOrderReferenceDetailsRequest setOrderReferenceDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(setOrderReferenceDetailsRequest));
        return Parser.setOrderReferenceDetails(rawResponse);
    }

    @Override
    public AuthorizeResponseData authorize(AuthorizeRequest authorizeRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(authorizeRequest));
        return Parser.getAuthorizeData(rawResponse);
    }

    @Override
    public GetAuthorizationDetailsResponseData getAuthorizationDetails(GetAuthorizationDetailsRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.getAuthorizationDetailsData(rawResponse);
    }

    @Override
    public CaptureResponseData capture(CaptureRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.getCapture(rawResponse);
    }

    @Override
    public GetCaptureDetailsResponseData getCaptureDetails(GetCaptureDetailsRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.getCaptureDetailsData(rawResponse);
    }

    @Override
    public ConfirmOrderReferenceResponseData confirmOrderReference(ConfirmOrderReferenceRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.confirmOrderReference(rawResponse);
    }

    @Override
    public CloseAuthorizationResponseData closeAuthorization(CloseAuthorizationRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.closeAuthorizationResponse(rawResponse);
    }

    @Override
    public CancelOrderReferenceResponseData cancelOrderReference(CancelOrderReferenceRequest request) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(request));
        return Parser.getCancelOrderReference(rawResponse);
    }

    @Override
    public CloseOrderReferenceResponseData closeOrderReference(CloseOrderReferenceRequest closeOrderReferenceRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(closeOrderReferenceRequest));
        return Parser.getCloseOrderReference(rawResponse);
    }

    @Override
    public RefundResponseData refund(RefundRequest refundRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(refundRequest));
        return Parser.getRefundData(rawResponse);
    }

    @Override
    public GetRefundDetailsResponseData getRefundDetails(GetRefundDetailsRequest getRefundDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getRefundDetailsRequest));
        return Parser.getRefundDetailsData(rawResponse);
    }

    @Override
    public GetBillingAgreementDetailsResponseData getBillingAgreementDetails(GetBillingAgreementDetailsRequest getBillingAgreementDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getBillingAgreementDetailsRequest));
        return Parser.getBillingAgreementDetailsData(rawResponse);
    }

    @Override
    public SetBillingAgreementDetailsResponseData setBillingAgreementDetails(SetBillingAgreementDetailsRequest setBillingAgreementDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(setBillingAgreementDetailsRequest));
        return Parser.getSetBillingAgreementDetailsResponse(rawResponse);
    }

    @Override
    public ValidateBillingAgreementResponseData validateBillingAgreement(ValidateBillingAgreementRequest validateBillingAgreementRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(validateBillingAgreementRequest));
        return Parser.getValidateBillingAgreementResponse(rawResponse);
    }

    @Override
    public ConfirmBillingAgreementResponseData confirmBillingAgreement(ConfirmBillingAgreementRequest confirmBillingAgreementRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(confirmBillingAgreementRequest));
        return Parser.confirmBillingAgreementResponse(rawResponse);
    }

    @Override
    public AuthorizeOnBillingAgreementResponseData authorizeOnBillingAgreement(AuthorizeOnBillingAgreementRequest authorizeOnBillingAgreementRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(authorizeOnBillingAgreementRequest));
        return Parser.getAuthorizeOnBillingAgreement(rawResponse);
    }

    @Override
    public CloseBillingAgreementResponseData closeBillingAgreement(CloseBillingAgreementRequest closeBillingAgreementRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(closeBillingAgreementRequest));
        return Parser.closeBillingAgreementResponse(rawResponse);
    }

    @Override
    public GetProviderCreditReversalDetailsResponseData getProviderCreditReversalDetails(GetProviderCreditReversalDetailsRequest getProviderCreditReversalDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getProviderCreditReversalDetailsRequest));
        return Parser.getProviderCreditReversalDetails(rawResponse);
    }

    @Override
    public GetProviderCreditDetailsResponseData getProviderCreditDetails(GetProviderCreditDetailsRequest getProviderCreditDetailsRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getProviderCreditDetailsRequest));
        return Parser.getGetProviderCreditDetails(rawResponse);
    }

    @Override
    public ReverseProviderCreditResponseData reverseProviderCredit(ReverseProviderCreditRequest reverseProviderCreditRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(reverseProviderCreditRequest));
        return Parser.getReverseProviderCreditResponseData(rawResponse);
    }

    @Override
    public User getUserInfo(String accessToken, String clientId) throws AmazonServiceException, IOException {
        String decodedAccessToken = URLDecoder.decode(accessToken, "UTF-8");
        String profileEndpoint = this.payConfig.getOverrideProfileURL() != null ? this.payConfig.getOverrideProfileURL() : (this.payConfig.getEnvironment() == Environment.SANDBOX ? ServiceConstants.profileEndpointSandboxMappings.get((Object)this.payConfig.getRegion()) : ServiceConstants.profileEndpointMappings.get((Object)this.payConfig.getRegion()));
        HashMap<String, String> headerValues = new HashMap<String, String>();
        ResponseData response = Util.httpSendRequest("GET", profileEndpoint + "/auth/o2/tokeninfo?access_token=" + decodedAccessToken, null, headerValues, null);
        Map m = Util.convertJsonToObject(response.toXML(), Map.class);
        if (m.containsKey("error")) {
            throw new AmazonServiceException("Retrieving User Info Failed. " + (String)m.get("error_description"));
        }
        if (clientId == null || !clientId.equals(m.get("aud"))) {
            throw new AmazonClientException("Access token does not belong to clientId: " + clientId);
        }
        headerValues.put("Authorization", "bearer " + decodedAccessToken);
        response = Util.httpSendRequest("GET", profileEndpoint + "/user/profile", null, headerValues);
        m = Util.convertJsonToObject(response.toXML(), Map.class);
        if (m.containsKey("error")) {
            throw new AmazonServiceException("Retrieving User Info Failed. " + (String)m.get("error_description"));
        }
        User user = Util.convertJsonToObject(response.toXML(), User.class);
        return user;
    }

    @Override
    public GetAuthorizationDetailsResponseData charge(ChargeRequest chargeRequest) throws AmazonServiceException {
        GetAuthorizationDetailsResponseData authDetails = null;
        AmazonReferenceIdType type = chargeRequest.getType();
        switch (type) {
            case ORDER_REFERENCE_ID: {
                authDetails = this.chargeORO(chargeRequest);
                break;
            }
            case BILLING_AGREEMENT_ID: {
                authDetails = this.chargeBillingAgreement(chargeRequest);
                break;
            }
            default: {
                throw new AmazonClientException("Aborting..charge method failed to handle request");
            }
        }
        return authDetails;
    }

    private GetAuthorizationDetailsResponseData chargeBillingAgreement(ChargeRequest chargeRequest) throws AmazonServiceException {
        GetAuthorizationDetailsResponseData authDetails = null;
        String amazonReferenceId = chargeRequest.getAmazonReferenceId();
        String mwsAuthToken = chargeRequest.getMwsAuthToken();
        String amount = chargeRequest.getAmount();
        BillingAgreementDetails res = this.getBillingAgreementDetails((GetBillingAgreementDetailsRequest)new GetBillingAgreementDetailsRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken)).getDetails();
        String billingAgreementStatus = res.getBillingAgreementStatus().getState();
        if ("Draft".equals(billingAgreementStatus)) {
            this.setBillingAgreementDetails(((SetBillingAgreementDetailsRequest)new SetBillingAgreementDetailsRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken)).setCustomInformation(chargeRequest.getCustomInformation()).setPlatformId(chargeRequest.getPlatformId()).setSellerNote(chargeRequest.getSellerNote()).setStoreName(chargeRequest.getStoreName()).setSellerBillingAgreementId(chargeRequest.getChargeOrderId()));
        }
        this.confirmBillingAgreement((ConfirmBillingAgreementRequest)new ConfirmBillingAgreementRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken));
        BillingAgreementDetails postConfirmResponse = this.getBillingAgreementDetails((GetBillingAgreementDetailsRequest)new GetBillingAgreementDetailsRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken)).getDetails();
        String postConfirmStatus = postConfirmResponse.getBillingAgreementStatus().getState();
        if (!"Open".equals(postConfirmStatus)) {
            throw new AmazonClientException("Billing Agreement is in " + postConfirmStatus + " state, unable to authorize transaction: ");
        }
        AuthorizationDetails authResponse = this.authorizeOnBillingAgreement(((AuthorizeOnBillingAgreementRequest)new AuthorizeOnBillingAgreementRequest(amazonReferenceId, chargeRequest.getChargeReferenceId(), amount).setMWSAuthToken(mwsAuthToken)).setCaptureNow(chargeRequest.getCaptureNow()).setTransactionTimeout(chargeRequest.getTransactionTimeout()).setPlatformId(chargeRequest.getPlatformId()).setCustomInformation(chargeRequest.getCustomInformation()).setStoreName(chargeRequest.getStoreName()).setSellerNote(chargeRequest.getSellerNote()).setSellerAuthorizationNote(chargeRequest.getSellerNote()).setAuthorizationCurrencyCode(chargeRequest.getCurrencyCode()).setSellerOrderId(chargeRequest.getChargeOrderId()).setSoftDescriptor(chargeRequest.getSoftDescriptor()).setInheritShippingAddress(chargeRequest.getInheritShippingAddress())).getDetails();
        String authId = authResponse.getAmazonAuthorizationId();
        authDetails = this.getAuthorizationDetails((GetAuthorizationDetailsRequest)new GetAuthorizationDetailsRequest(authId).setMWSAuthToken(mwsAuthToken));
        return authDetails;
    }

    private GetAuthorizationDetailsResponseData chargeORO(ChargeRequest chargeRequest) throws AmazonServiceException {
        String mwsAuthToken;
        GetAuthorizationDetailsResponseData authDetails = null;
        String amazonReferenceId = chargeRequest.getAmazonReferenceId();
        GetOrderReferenceDetailsRequest getOrderDetailsRequest = (GetOrderReferenceDetailsRequest)new GetOrderReferenceDetailsRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken = chargeRequest.getMwsAuthToken());
        OrderReferenceDetails response = this.getOrderReferenceDetails(getOrderDetailsRequest).getDetails();
        if ("Draft".equals(response.getOrderReferenceStatus().getState())) {
            this.setOrderReferenceDetails(((SetOrderReferenceDetailsRequest)new SetOrderReferenceDetailsRequest(amazonReferenceId, chargeRequest.getAmount()).setMWSAuthToken(mwsAuthToken)).setSellerOrderId(chargeRequest.getChargeOrderId()).setStoreName(chargeRequest.getStoreName()).setSellerNote(chargeRequest.getSellerNote()).setCustomInformation(chargeRequest.getCustomInformation()).setPlatformId(chargeRequest.getPlatformId()).setOrderCurrencyCode(chargeRequest.getCurrencyCode()));
        }
        this.confirmOrderReference((ConfirmOrderReferenceRequest)new ConfirmOrderReferenceRequest(amazonReferenceId).setMWSAuthToken(mwsAuthToken));
        OrderReferenceDetails postConfirmResponse = this.getOrderReferenceDetails(getOrderDetailsRequest).getDetails();
        if (!"Open".equals(postConfirmResponse.getOrderReferenceStatus().getState())) {
            throw new AmazonClientException("Order Reference is in " + postConfirmResponse.getOrderReferenceStatus().getState() + " state, unable to authorize transaction: ");
        }
        String authId = this.authorize(((AuthorizeRequest)new AuthorizeRequest(amazonReferenceId, chargeRequest.getChargeReferenceId(), chargeRequest.getAmount()).setMWSAuthToken(mwsAuthToken)).setCaptureNow(chargeRequest.getCaptureNow()).setTransactionTimeout(chargeRequest.getTransactionTimeout()).setProviderCredit(chargeRequest.getProviderCredit()).setSellerAuthorizationNote(chargeRequest.getSellerNote()).setSoftDescriptor(chargeRequest.getSoftDescriptor()).setProviderCredit(chargeRequest.getProviderCredit())).getDetails().getAmazonAuthorizationId();
        authDetails = this.getAuthorizationDetails((GetAuthorizationDetailsRequest)new GetAuthorizationDetailsRequest(authId).setMWSAuthToken(mwsAuthToken));
        return authDetails;
    }

    @Override
    public ListOrderReferenceResponseData listOrderReference(ListOrderReferenceRequest listOrderReferenceRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(listOrderReferenceRequest));
        return Parser.listOrderReference(rawResponse);
    }

    @Override
    public ListOrderReferenceByNextTokenResponseData listOrderReferenceByNextToken(ListOrderReferenceByNextTokenRequest listOrderReferenceByNextTokenRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(listOrderReferenceByNextTokenRequest));
        return Parser.listOrderReferenceByNextToken(rawResponse);
    }

    @Override
    public SetOrderAttributesResponseData setOrderAttributes(SetOrderAttributesRequest setOrderAttributesRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(setOrderAttributesRequest));
        return Parser.setOrderAttributes(rawResponse);
    }

    @Override
    public GetMerchantAccountStatusResponseData getMerchantAccountStatus(GetMerchantAccountStatusRequest getMerchantAccountStatusRequest) throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(getMerchantAccountStatusRequest));
        return Parser.getMerchantAccountStatus(rawResponse);
    }

    @Override
    public GetMerchantAccountStatusResponseData getMerchantAccountStatus() throws AmazonServiceException {
        ResponseData rawResponse = this.sendRequest(this.helper.getPostURL(new GetMerchantAccountStatusRequest()));
        return Parser.getMerchantAccountStatus(rawResponse);
    }

    private ResponseData sendRequest(String httpPostRequest) {
        ResponseData response = null;
        try {
            response = this.postRequest(httpPostRequest);
            int statusCode = response.getStatusCode();
            int retry = 0;
            while ((statusCode == 503 || statusCode == 500) && retry < 3 && this.payConfig.isUseAutoRetryOnThrottle()) {
                if (++retry == 1) {
                    Thread.sleep(1000L);
                } else if (retry == 2) {
                    Thread.sleep(4000L);
                } else if (retry == 3) {
                    Thread.sleep(10000L);
                } else {
                    return null;
                }
                response = this.postRequest(httpPostRequest);
                statusCode = response.getStatusCode();
            }
        }
        catch (IOException e) {
            throw new AmazonClientException("Encountered IOException: ", e);
        }
        catch (InterruptedException ex) {
            throw new AmazonClientException("Encountered InterruptedException:", ex);
        }
        return response;
    }

    private ResponseData postRequest(String httpPostRequest) throws IOException {
        return Util.httpSendRequest("POST", Util.getServiceURLEndpoint(this.payConfig), httpPostRequest, null, this.helper.payConfig);
    }

    @Override
    public Config getConfig() throws AmazonServiceException {
        return this.payConfig;
    }
}

