/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonList;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.impl.IonReaderTreeSystem;
import com.amazon.ion.impl.LocalSymbolTable;
import com.amazon.ion.impl.LocalSymbolTableImports;
import com.amazon.ion.impl._Private_LocalSymbolTableFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class LocalSymbolTableAsStruct
extends LocalSymbolTable {
    private final ValueFactory myImageFactory;
    private IonStruct myImage;

    private LocalSymbolTableAsStruct(ValueFactory imageFactory, LocalSymbolTableImports imports, List<String> symbolsList) {
        super(imports, symbolsList);
        this.myImageFactory = imageFactory;
    }

    @Override
    int putSymbol(String symbolName) {
        int sid = super.putSymbol(symbolName);
        if (this.myImage != null) {
            this.recordLocalSymbolInIonRep(this.myImage, symbolName, sid);
        }
        return sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IonStruct getIonRepresentation() {
        LocalSymbolTableAsStruct localSymbolTableAsStruct = this;
        synchronized (localSymbolTableAsStruct) {
            IonStruct image = this.myImage;
            if (image == null) {
                this.myImage = image = this.makeIonRepresentation(this.myImageFactory);
            }
            return image;
        }
    }

    private IonStruct makeIonRepresentation(ValueFactory factory) {
        IonStruct ionRep = factory.newEmptyStruct();
        ionRep.addTypeAnnotation("$ion_symbol_table");
        SymbolTable[] importedTables = this.getImportedTablesNoCopy();
        if (importedTables.length > 1) {
            IonList importsList = factory.newEmptyList();
            for (int i = 1; i < importedTables.length; ++i) {
                SymbolTable importedTable = importedTables[i];
                IonStruct importStruct = factory.newEmptyStruct();
                importStruct.add("name", (IonValue)factory.newString(importedTable.getName()));
                importStruct.add("version", (IonValue)factory.newInt(importedTable.getVersion()));
                importStruct.add("max_id", (IonValue)factory.newInt(importedTable.getMaxId()));
                importsList.add(importStruct);
            }
            ionRep.add("imports", (IonValue)importsList);
        }
        if (this.mySymbolsCount > 0) {
            int sid = this.myFirstLocalSid;
            int offset = 0;
            while (offset < this.mySymbolsCount) {
                String symbolName = this.mySymbolNames[offset];
                this.recordLocalSymbolInIonRep(ionRep, symbolName, sid);
                ++offset;
                ++sid;
            }
        }
        return ionRep;
    }

    private void recordLocalSymbolInIonRep(IonStruct ionRep, String symbolName, int sid) {
        assert (sid >= this.myFirstLocalSid);
        IonSystem sys = ionRep.getSystem();
        IonValue syms = ionRep.get("symbols");
        while (syms != null && syms.getType() != IonType.LIST) {
            ionRep.remove(syms);
            syms = ionRep.get("symbols");
        }
        if (syms == null) {
            syms = sys.newEmptyList();
            ionRep.put("symbols", syms);
        }
        int this_offset = sid - this.myFirstLocalSid;
        IonString name = sys.newString(symbolName);
        ((IonList)syms).add(this_offset, name);
    }

    static class Factory
    implements _Private_LocalSymbolTableFactory {
        private final ValueFactory imageFactory;

        public Factory(ValueFactory imageFactory) {
            this.imageFactory = imageFactory;
        }

        public SymbolTable newLocalSymtab(IonCatalog catalog, IonReader reader, boolean alreadyInStruct) {
            ArrayList<String> symbolsList = new ArrayList<String>();
            SymbolTable currentSymbolTable = reader.getSymbolTable();
            LocalSymbolTableImports imports = LocalSymbolTable.readLocalSymbolTable(reader, catalog, alreadyInStruct, symbolsList, currentSymbolTable);
            if (imports == null) {
                return currentSymbolTable;
            }
            return new LocalSymbolTableAsStruct(this.imageFactory, imports, symbolsList);
        }

        public SymbolTable newLocalSymtab(SymbolTable defaultSystemSymtab, SymbolTable ... imports) {
            LocalSymbolTableImports unifiedSymtabImports = new LocalSymbolTableImports(defaultSystemSymtab, imports);
            return new LocalSymbolTableAsStruct(this.imageFactory, unifiedSymtabImports, null);
        }

        public SymbolTable newLocalSymtab(IonCatalog catalog, IonStruct ionRep) {
            assert (this.imageFactory == ionRep.getSystem());
            IonReaderTreeSystem reader = new IonReaderTreeSystem(ionRep);
            ArrayList<String> symbolsList = new ArrayList<String>();
            LocalSymbolTableImports imports = LocalSymbolTable.readLocalSymbolTable(reader, catalog, false, symbolsList, ionRep.getSymbolTable());
            LocalSymbolTableAsStruct table = new LocalSymbolTableAsStruct(this.imageFactory, imports, symbolsList);
            table.myImage = ionRep;
            return table;
        }
    }
}

