/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import com.amazon.deequ.analyzers.ApproxCountDistinctState;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.expressions.aggregate.HLLConstants$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.DoubleRef;

public final class DeequHyperLogLogPlusPlusUtils$ {
    public static final DeequHyperLogLogPlusPlusUtils$ MODULE$;
    private final int NUM_WORDS;
    private final double RELATIVE_SD;
    private final int P;
    private final int IDX_SHIFT;
    private final long W_PADDING;
    private final int M;
    public final double org$apache$spark$sql$catalyst$expressions$aggregate$DeequHyperLogLogPlusPlusUtils$$ALPHA_M2;

    static {
        new DeequHyperLogLogPlusPlusUtils$();
    }

    public int NUM_WORDS() {
        return this.NUM_WORDS;
    }

    public double RELATIVE_SD() {
        return this.RELATIVE_SD;
    }

    public int P() {
        return this.P;
    }

    public int IDX_SHIFT() {
        return this.IDX_SHIFT;
    }

    public long W_PADDING() {
        return this.W_PADDING;
    }

    public int M() {
        return this.M;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] wordsToBytes(long[] words) {
        void var2_2;
        Predef$.MODULE$.require(words.length == this.NUM_WORDS());
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(this.NUM_WORDS() * 64, ClassTag$.MODULE$.Byte());
        LongBuffer buffer = ByteBuffer.wrap(bytes).asLongBuffer();
        Predef$.MODULE$.longArrayOps(words).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final LongBuffer buffer$2;

            public final LongBuffer apply(long word) {
                return this.buffer$2.put(word);
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public ApproxCountDistinctState wordsFromBytes(byte[] bytes) {
        Predef$.MODULE$.require(bytes.length == this.NUM_WORDS() * 64);
        LongBuffer buffer = ByteBuffer.wrap(bytes).asLongBuffer().asReadOnlyBuffer();
        long[] words = (long[])Array$.MODULE$.fill(this.NUM_WORDS(), (Function0)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final LongBuffer buffer$3;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.buffer$3.get();
            }
            {
                this.buffer$3 = buffer$3;
            }
        }, ClassTag$.MODULE$.Long());
        return new ApproxCountDistinctState(words);
    }

    /*
     * WARNING - void declaration
     */
    public long[] merge(long[] words1, long[] words2) {
        void var3_3;
        long[] dest = (long[])Array$.MODULE$.ofDim(this.NUM_WORDS(), ClassTag$.MODULE$.Long());
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.NUM_WORDS(); ++wordOffset) {
            long word1 = words1[wordOffset];
            long word2 = words2[wordOffset];
            long word = 0L;
            long mask = HLLConstants$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.M() && i < HLLConstants$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HLLConstants$.MODULE$.REGISTER_SIZE();
            }
            dest[wordOffset] = word;
        }
        return var3_3;
    }

    public double count(long[] words) {
        double H;
        DoubleRef zInverse = DoubleRef.create((double)0.0);
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < words.length; ++wordOffset) {
            long word = words[wordOffset];
            int shift = 0;
            for (int i = 0; idx < this.M() && i < HLLConstants$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HLLConstants$.MODULE$.REGISTER_WORD_MASK();
                zInverse.elem += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HLLConstants$.MODULE$.REGISTER_SIZE();
            }
        }
        double estimate = V > 0.0 ? ((H = (double)this.M() * Math.log((double)this.M() / V)) <= HLLConstants$.MODULE$.THRESHOLDS()[this.P() - 4] ? H : this.EBiasCorrected$1(zInverse)) : this.EBiasCorrected$1(zInverse);
        return Math.round(estimate);
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HLLConstants$.MODULE$.RAW_ESTIMATE_DATA()[this.P() - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HLLConstants$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HLLConstants$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HLLConstants$.MODULE$.BIAS_DATA()[this.P() - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    private final double EBiasCorrected$1(DoubleRef zInverse$1) {
        double d = this.org$apache$spark$sql$catalyst$expressions$aggregate$DeequHyperLogLogPlusPlusUtils$$ALPHA_M2 / zInverse$1.elem;
        double d2 = this.P() < 19 && d < 5.0 * (double)this.M() ? d - this.estimateBias(d) : d;
        return d2;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff2 = e$1 - estimates$1[i];
        return diff2 * diff2;
    }

    private DeequHyperLogLogPlusPlusUtils$() {
        double d;
        MODULE$ = this;
        this.NUM_WORDS = 52;
        this.RELATIVE_SD = 0.05;
        this.P = (int)Math.ceil(2.0 * Math.log(1.106 / this.RELATIVE_SD()) / Math.log(2.0));
        this.IDX_SHIFT = 64 - this.P();
        this.W_PADDING = 1L << this.P() - 1;
        this.M = 1 << this.P();
        int n = this.P();
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.M()) * (double)this.M() * (double)this.M();
                break;
            }
            case 6: {
                d = 0.709 * (double)this.M() * (double)this.M();
                break;
            }
            case 5: {
                d = 0.697 * (double)this.M() * (double)this.M();
                break;
            }
            case 4: {
                d = 0.673 * (double)this.M() * (double)this.M();
            }
        }
        this.org$apache$spark$sql$catalyst$expressions$aggregate$DeequHyperLogLogPlusPlusUtils$$ALPHA_M2 = d;
    }
}

