/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.repository.fs;

import com.amazon.deequ.repository.fs.FileSystemMetricsRepository;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileSystemMetricsRepository$ {
    public static final FileSystemMetricsRepository$ MODULE$;
    private final String CHARSET_NAME;

    static {
        new FileSystemMetricsRepository$();
    }

    public String CHARSET_NAME() {
        return this.CHARSET_NAME;
    }

    public FileSystemMetricsRepository apply(SparkSession session, String path) {
        return new FileSystemMetricsRepository(session, path);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToFileOnDfs(SparkSession session, String path, Function1<BufferedOutputStream, BoxedUnit> writeFunc) {
        Tuple2 tuple22;
        String uuid = UUID.randomUUID().toString();
        Tuple2<FileSystem, Path> tuple2 = this.asQualifiedPath(session, path);
        if (tuple2 == null) throw new MatchError(tuple2);
        FileSystem fs = (FileSystem)tuple2._1();
        Path qualifiedPath = (Path)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)qualifiedPath);
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path qualifiedPath2 = (Path)tuple23._2();
        Path tempQualifiedPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{qualifiedPath2.getParent().toUri(), uuid})));
        FSDataOutputStream fsDataOutputStream = fs2.create(tempQualifiedPath, false);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)fsDataOutputStream);
        try {
            writeFunc.apply((Object)bufferedOutputStream);
        }
        catch (Throwable throwable) {
            void var14_14;
            Closeables.close((Closeable)var14_14, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)bufferedOutputStream, (boolean)false);
        Object object = fs2.exists(qualifiedPath2) ? BoxesRunTime.boxToBoolean((boolean)fs2.delete(qualifiedPath2, false)) : BoxedUnit.UNIT;
        fs2.rename(tempQualifiedPath, qualifiedPath2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Option<T> readFromFileOnDfs(SparkSession session, String path, Function1<BufferedInputStream, T> readFunc) {
        None$ none$;
        Path qualifiedPath;
        Path qualifiedPath2;
        Tuple2<FileSystem, Path> tuple2 = this.asQualifiedPath(session, path);
        if (tuple2 == null) throw new MatchError(tuple2);
        FileSystem fs = (FileSystem)tuple2._1();
        Tuple2 tuple22 = new Tuple2((Object)fs, (Object)(qualifiedPath2 = (Path)tuple2._2()));
        Tuple2 tuple23 = tuple22;
        FileSystem fs2 = (FileSystem)tuple23._1();
        if (!fs2.isFile(qualifiedPath = (Path)tuple23._2())) {
            none$ = None$.MODULE$;
            return none$;
        }
        FSDataInputStream fsDataInputStream = fs2.open(qualifiedPath);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)fsDataInputStream);
        try {
            none$ = Option$.MODULE$.apply(readFunc.apply((Object)bufferedInputStream));
        }
        catch (Throwable throwable) {
            void var12_12;
            Closeables.close((Closeable)var12_12, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)bufferedInputStream, (boolean)false);
        return none$;
    }

    public Tuple2<FileSystem, Path> asQualifiedPath(SparkSession session, String path) {
        Path hdfsPath = new Path(path);
        FileSystem fs = hdfsPath.getFileSystem(session.sparkContext().hadoopConfiguration());
        Path qualifiedPath = hdfsPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        return new Tuple2((Object)fs, (Object)qualifiedPath);
    }

    private FileSystemMetricsRepository$() {
        MODULE$ = this;
        this.CHARSET_NAME = "UTF-8";
    }
}

