/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class DfsUtils$ {
    public static final DfsUtils$ MODULE$;

    static {
        new DfsUtils$();
    }

    public <T> T readFromFileOnDfs(SparkSession session, String path, Function1<FSDataInputStream, T> readFunc) {
        FSDataInputStream input;
        Tuple2<FileSystem, Path> tuple2 = this.asQualifiedPath(session, path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileSystem fs = (FileSystem)tuple2._1();
            Path qualifiedPath = (Path)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)qualifiedPath);
            FileSystem fs2 = (FileSystem)tuple23._1();
            Path qualifiedPath2 = (Path)tuple23._2();
            input = fs2.open(qualifiedPath2);
            return (T)readFunc.apply((Object)input);
        }
        throw new MatchError(tuple2);
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public void writeToFileOnDfs(SparkSession session, String path, boolean overwrite, Function1<FSDataOutputStream, BoxedUnit> writeFunc) {
        FSDataOutputStream output;
        Tuple2<FileSystem, Path> tuple2 = this.asQualifiedPath(session, path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileSystem fs = (FileSystem)tuple2._1();
            Path qualifiedPath = (Path)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)qualifiedPath);
            FileSystem fs2 = (FileSystem)tuple23._1();
            Path qualifiedPath2 = (Path)tuple23._2();
            output = fs2.create(qualifiedPath2, overwrite);
            writeFunc.apply((Object)output);
            return;
        }
        throw new MatchError(tuple2);
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public boolean writeToFileOnDfs$default$3() {
        return false;
    }

    public void writeToTextFileOnDfs(SparkSession session, String path, boolean overwrite, Function1<BufferedWriter, BoxedUnit> writeFunc) {
        FSDataOutputStream output;
        Tuple2<FileSystem, Path> tuple2 = this.asQualifiedPath(session, path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileSystem fs = (FileSystem)tuple2._1();
            Path qualifiedPath = (Path)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)qualifiedPath);
            FileSystem fs2 = (FileSystem)tuple23._1();
            Path qualifiedPath2 = (Path)tuple23._2();
            output = fs2.create(qualifiedPath2, overwrite);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output));
            writeFunc.apply((Object)writer);
            writer.close();
            return;
        }
        throw new MatchError(tuple2);
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public boolean writeToTextFileOnDfs$default$3() {
        return false;
    }

    public Tuple2<FileSystem, Path> asQualifiedPath(SparkSession session, String path) {
        Path hdfsPath = new Path(path);
        FileSystem fs = hdfsPath.getFileSystem(session.sparkContext().hadoopConfiguration());
        Path qualifiedPath = hdfsPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        return new Tuple2((Object)fs, (Object)qualifiedPath);
    }

    private DfsUtils$() {
        MODULE$ = this;
    }
}

