/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.examples;

import com.amazon.deequ.analyzers.Analysis;
import com.amazon.deequ.analyzers.Analyzer;
import com.amazon.deequ.analyzers.InMemoryStateProvider;
import com.amazon.deequ.analyzers.StateLoader;
import com.amazon.deequ.analyzers.StatePersister;
import com.amazon.deequ.analyzers.runners.AnalysisRunner$;
import com.amazon.deequ.analyzers.runners.AnalyzerContext;
import com.amazon.deequ.checks.Check;
import com.amazon.deequ.checks.Check$;
import com.amazon.deequ.checks.CheckLevel$;
import com.amazon.deequ.checks.CheckWithLastConstraintFilterable;
import com.amazon.deequ.examples.ExampleUtils$;
import com.amazon.deequ.examples.Manufacturer;
import com.amazon.deequ.examples.UpdateMetricsOnPartitionedDataExample;
import com.amazon.deequ.metrics.Metric;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class UpdateMetricsOnPartitionedDataExample$
implements App {
    public static final UpdateMetricsOnPartitionedDataExample$ MODULE$;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new UpdateMetricsOnPartitionedDataExample$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public final void delayedEndpoint$com$amazon$deequ$examples$UpdateMetricsOnPartitionedDataExample$1() {
        ExampleUtils$.MODULE$.withSpark((Function1<SparkSession, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSession session) {
                Dataset<Row> deManufacturers = ExampleUtils$.MODULE$.manufacturersAsDataframe(session, (Seq<Manufacturer>)Predef$.MODULE$.wrapRefArray((Object[])new Manufacturer[]{new Manufacturer(1L, "ManufacturerA", "DE"), new Manufacturer(2L, "ManufacturerB", "DE")}));
                Dataset<Row> usManufacturers = ExampleUtils$.MODULE$.manufacturersAsDataframe(session, (Seq<Manufacturer>)Predef$.MODULE$.wrapRefArray((Object[])new Manufacturer[]{new Manufacturer(3L, "ManufacturerD", "US"), new Manufacturer(4L, "ManufacturerE", "US"), new Manufacturer(5L, "ManufacturerF", "US")}));
                Dataset<Row> cnManufacturers = ExampleUtils$.MODULE$.manufacturersAsDataframe(session, (Seq<Manufacturer>)Predef$.MODULE$.wrapRefArray((Object[])new Manufacturer[]{new Manufacturer(6L, "ManufacturerG", "CN"), new Manufacturer(7L, "ManufacturerH", "CN")}));
                Check qual$1 = new Check(CheckLevel$.MODULE$.Warning(), "a check", Check$.MODULE$.apply$default$3());
                String x$2 = "manufacturerName";
                Option<String> x$3 = qual$1.isComplete$default$2();
                CheckWithLastConstraintFilterable qual$2 = qual$1.isComplete(x$2, x$3);
                String x$4 = "manufacturerName";
                Serializable x$5 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$1) {
                        return this.apply$mcZD$sp(x$1);
                    }

                    public boolean apply$mcZD$sp(double x$1) {
                        return x$1 == 0.0;
                    }
                };
                Option<String> x$6 = qual$2.containsURL$default$3();
                CheckWithLastConstraintFilterable check = qual$2.containsURL(x$4, (Function1<Object, Object>)x$5, x$6).isContainedIn("countryCode", (String[])((Object[])new String[]{"DE", "US", "CN"}));
                Seq analyzers = check.requiredAnalyzers().toSeq();
                Analysis analysis = new Analysis(analyzers);
                InMemoryStateProvider deStates = new InMemoryStateProvider();
                InMemoryStateProvider usStates = new InMemoryStateProvider();
                InMemoryStateProvider cnStates = new InMemoryStateProvider();
                Dataset<Row> x$7 = deManufacturers;
                Analysis x$8 = analysis;
                Some x$9 = new Some((Object)deStates);
                Option<StateLoader> x$10 = AnalysisRunner$.MODULE$.run$default$3();
                StorageLevel x$11 = AnalysisRunner$.MODULE$.run$default$5();
                AnalysisRunner$.MODULE$.run(x$7, x$8, x$10, (Option<StatePersister>)x$9, x$11);
                Dataset<Row> x$12 = usManufacturers;
                Analysis x$13 = analysis;
                Some x$14 = new Some((Object)usStates);
                Option<StateLoader> x$15 = AnalysisRunner$.MODULE$.run$default$3();
                StorageLevel x$16 = AnalysisRunner$.MODULE$.run$default$5();
                AnalysisRunner$.MODULE$.run(x$12, x$13, x$15, (Option<StatePersister>)x$14, x$16);
                Dataset<Row> x$17 = cnManufacturers;
                Analysis x$18 = analysis;
                Some x$19 = new Some((Object)cnStates);
                Option<StateLoader> x$20 = AnalysisRunner$.MODULE$.run$default$3();
                StorageLevel x$21 = AnalysisRunner$.MODULE$.run$default$5();
                AnalysisRunner$.MODULE$.run(x$17, x$18, x$20, (Option<StatePersister>)x$19, x$21);
                AnalyzerContext tableMetrics = AnalysisRunner$.MODULE$.runOnAggregatedStates(deManufacturers.schema(), analysis, (Seq<StateLoader>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InMemoryStateProvider[]{deStates, usStates, cnStates}))), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$4(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$5(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$6(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$7());
                Predef$.MODULE$.println((Object)"Metrics for the whole table:\n");
                tableMetrics.metricMap().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Analyzer<?, Metric<?>>, Metric<?>> x0$1) {
                        Tuple2<Analyzer<?, Metric<?>>, Metric<?>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Analyzer analyzer = (Analyzer)tuple2._1();
                            Metric metric = (Metric)tuple2._2();
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzer, metric.value().get()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                Dataset<Row> updatedUsManufacturers = ExampleUtils$.MODULE$.manufacturersAsDataframe(session, (Seq<Manufacturer>)Predef$.MODULE$.wrapRefArray((Object[])new Manufacturer[]{new Manufacturer(3L, "ManufacturerDNew", "US"), new Manufacturer(4L, null, "US"), new Manufacturer(5L, "ManufacturerFNew http://clickme.com", "US")}));
                InMemoryStateProvider updatedUsStates = new InMemoryStateProvider();
                Dataset<Row> x$22 = updatedUsManufacturers;
                Analysis x$23 = analysis;
                Some x$24 = new Some((Object)updatedUsStates);
                Option<StateLoader> x$25 = AnalysisRunner$.MODULE$.run$default$3();
                StorageLevel x$26 = AnalysisRunner$.MODULE$.run$default$5();
                AnalysisRunner$.MODULE$.run(x$22, x$23, x$25, (Option<StatePersister>)x$24, x$26);
                AnalyzerContext updatedTableMetrics = AnalysisRunner$.MODULE$.runOnAggregatedStates(deManufacturers.schema(), analysis, (Seq<StateLoader>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InMemoryStateProvider[]{deStates, updatedUsStates, cnStates}))), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$4(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$5(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$6(), AnalysisRunner$.MODULE$.runOnAggregatedStates$default$7());
                Predef$.MODULE$.println((Object)"Metrics for the whole table after updating the US partition:\n");
                updatedTableMetrics.metricMap().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Analyzer<?, Metric<?>>, Metric<?>> x0$2) {
                        Tuple2<Analyzer<?, Metric<?>>, Metric<?>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Analyzer analyzer = (Analyzer)tuple2._1();
                            Metric metric = (Metric)tuple2._2();
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzer, metric.value().get()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
            }
        });
    }

    private UpdateMetricsOnPartitionedDataExample$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new UpdateMetricsOnPartitionedDataExample.delayedInit.body(this));
    }
}

