/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.examples;

import com.amazon.deequ.VerificationSuite$;
import com.amazon.deequ.analyzers.Completeness;
import com.amazon.deequ.analyzers.Completeness$;
import com.amazon.deequ.analyzers.runners.AnalyzerContext;
import com.amazon.deequ.checks.Check;
import com.amazon.deequ.checks.Check$;
import com.amazon.deequ.checks.CheckLevel$;
import com.amazon.deequ.checks.CheckWithLastConstraintFilterable;
import com.amazon.deequ.examples.ExampleUtils$;
import com.amazon.deequ.examples.Item;
import com.amazon.deequ.examples.MetricsRepositoryExample;
import com.amazon.deequ.metrics.Metric;
import com.amazon.deequ.repository.MetricsRepositoryMultipleResultsLoader;
import com.amazon.deequ.repository.ResultKey;
import com.amazon.deequ.repository.fs.FileSystemMetricsRepository;
import com.amazon.deequ.repository.fs.FileSystemMetricsRepository$;
import com.google.common.io.Files;
import java.io.File;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class MetricsRepositoryExample$
implements App {
    public static final MetricsRepositoryExample$ MODULE$;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new MetricsRepositoryExample$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public final void delayedEndpoint$com$amazon$deequ$examples$MetricsRepositoryExample$1() {
        ExampleUtils$.MODULE$.withSpark((Function1<SparkSession, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSession session) {
                Dataset<Row> data = ExampleUtils$.MODULE$.itemsAsDataframe(session, (Seq<Item>)Predef$.MODULE$.wrapRefArray((Object[])new Item[]{new Item(1L, "Thingy A", "awesome thing.", "high", 0L), new Item(2L, "Thingy B", "available at http://thingb.com", null, 0L), new Item(3L, null, null, "low", 5L), new Item(4L, "Thingy D", "checkout https://thingd.ca", "low", 10L), new Item(5L, "Thingy E", null, "high", 12L)}));
                File metricsFile = new File(Files.createTempDir(), "metrics.json");
                FileSystemMetricsRepository repository = FileSystemMetricsRepository$.MODULE$.apply(session, metricsFile.getAbsolutePath());
                ResultKey resultKey = new ResultKey(System.currentTimeMillis(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tag"), (Object)"repositoryExample")}))));
                Check qual$1 = new Check(CheckLevel$.MODULE$.Error(), "integrity checks", Check$.MODULE$.apply$default$3());
                Serializable x$2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$1) {
                        return this.apply$mcZJ$sp(x$1);
                    }

                    public boolean apply$mcZJ$sp(long x$1) {
                        return x$1 == 5L;
                    }
                };
                Option<String> x$3 = qual$1.hasSize$default$2();
                CheckWithLastConstraintFilterable qual$2 = qual$1.hasSize((Function1<Object, Object>)x$2, x$3);
                String x$4 = "id";
                Option<String> x$5 = qual$2.isComplete$default$2();
                CheckWithLastConstraintFilterable qual$3 = qual$2.isComplete(x$4, x$5);
                String x$6 = "productName";
                Option<String> x$7 = qual$3.isComplete$default$2();
                CheckWithLastConstraintFilterable qual$4 = qual$3.isComplete(x$6, x$7).isContainedIn("priority", (String[])((Object[])new String[]{"high", "low"}));
                String x$8 = "numViews";
                Function1<Object, Object> x$9 = qual$4.isNonNegative$default$2();
                Option<String> x$10 = qual$4.isNonNegative$default$3();
                VerificationSuite$.MODULE$.apply().onData(data).addCheck(qual$4.isNonNegative(x$8, x$9, x$10)).useRepository(repository).saveOrAppendResult(resultKey).run();
                Metric completenessOfProductName = (Metric)((AnalyzerContext)repository.loadByKey(resultKey).get()).metric(new Completeness("productName", Completeness$.MODULE$.apply$default$2())).get();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The completeness of the productName column is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completenessOfProductName})));
                MetricsRepositoryMultipleResultsLoader qual$5 = repository.load().after(System.currentTimeMillis() - 10000L);
                Seq<String> x$11 = qual$5.getSuccessMetricsAsJson$default$1();
                String json = qual$5.getSuccessMetricsAsJson(x$11);
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metrics from the last 10 minutes:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})));
                MetricsRepositoryMultipleResultsLoader qual$6 = repository.load().withTagValues((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tag"), (Object)"repositoryExample")}))));
                SparkSession x$12 = session;
                Seq<String> x$13 = qual$6.getSuccessMetricsAsDataFrame$default$2();
                qual$6.getSuccessMetricsAsDataFrame(x$12, x$13).show();
            }
        });
    }

    private MetricsRepositoryExample$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new MetricsRepositoryExample.delayedInit.body(this));
    }
}

