/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.analyzers;

import com.amazon.deequ.analyzers.runners.NoColumnsSpecifiedException;
import com.amazon.deequ.analyzers.runners.NoSuchColumnException;
import com.amazon.deequ.analyzers.runners.NumberOfSpecifiedColumnsException;
import com.amazon.deequ.analyzers.runners.WrongColumnTypeException;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Preconditions$ {
    public static final Preconditions$ MODULE$;
    public final Set<Serializable> com$amazon$deequ$analyzers$Preconditions$$numericDataTypes;

    static {
        new Preconditions$();
    }

    public Option<Exception> findFirstFailing(StructType schema, Seq<Function1<StructType, BoxedUnit>> conditions) {
        return ((IterableLike)conditions.map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Option<Exception> apply(Function1<StructType, BoxedUnit> condition) {
                Some some;
                try {
                    condition.apply((Object)this.schema$1);
                    some = None$.MODULE$;
                }
                catch (Exception exception) {
                    some = new Some((Object)exception);
                }
                return some;
            }
            {
                this.schema$1 = schema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Exception> x$5) {
                return x$5.isDefined();
            }
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public Function1<StructType, BoxedUnit> atLeastOne(Seq<String> columns) {
        return new Serializable(columns){
            public static final long serialVersionUID = 0L;
            private final Seq columns$1;

            public final void apply(StructType x$6) {
                if (this.columns$1.isEmpty()) {
                    throw new NoColumnsSpecifiedException("At least one column needs to be specified!");
                }
            }
            {
                this.columns$1 = columns$1;
            }
        };
    }

    public Function1<StructType, BoxedUnit> exactlyNColumns(Seq<String> columns, int n) {
        return new Serializable(columns, n){
            public static final long serialVersionUID = 0L;
            private final Seq columns$2;
            private final int n$1;

            public final void apply(StructType x$7) {
                if (this.columns$2.size() != this.n$1) {
                    throw new NumberOfSpecifiedColumnsException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " columns have to be specified! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, columns contains only ", " column(s): ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.columns$2.size()), this.columns$2.mkString(",")}))).toString());
                }
            }
            {
                this.columns$2 = columns$2;
                this.n$1 = n$1;
            }
        };
    }

    public Function1<StructType, BoxedUnit> hasColumn(String column) {
        return new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final String column$1;

            public final void apply(StructType schema) {
                if (Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).contains((Object)this.column$1)) {
                    return;
                }
                throw new NoSuchColumnException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input data does not include column ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$1})));
            }
            {
                this.column$1 = column$1;
            }
        };
    }

    public Function1<StructType, BoxedUnit> isNumeric(String column) {
        return new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final String column$2;

            public final void apply(StructType schema) {
                DataType columnDataType = schema.apply(this.column$2).dataType();
                DataType dataType = columnDataType;
                boolean bl = ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : dataType instanceof DecimalType)))));
                boolean bl2 = bl;
                boolean hasNumericType = bl2;
                if (hasNumericType) {
                    return;
                }
                throw new WrongColumnTypeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected type of column ", " to be one of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "), but found ", " instead!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Preconditions$.MODULE$.com$amazon$deequ$analyzers$Preconditions$$numericDataTypes.mkString(","), columnDataType}))).toString());
            }
            {
                this.column$2 = column$2;
            }
        };
    }

    public Function1<StructType, BoxedUnit> isString(String column) {
        return new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final String column$3;

            public final void apply(StructType schema) {
                DataType columnDataType = schema.apply(this.column$3).dataType();
                DataType dataType = columnDataType;
                boolean bl = StringType$.MODULE$.equals(dataType);
                boolean hasStringType = bl;
                if (hasStringType) {
                    return;
                }
                throw new WrongColumnTypeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected type of column ", " to be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"StringType, but found ", " instead!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnDataType}))).toString());
            }
            {
                this.column$3 = column$3;
            }
        };
    }

    private Preconditions$() {
        MODULE$ = this;
        this.com$amazon$deequ$analyzers$Preconditions$$numericDataTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, DecimalType$.MODULE$}));
    }
}

