/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.analyzers;

import com.amazon.deequ.analyzers.DataTypeHistogram;
import com.amazon.deequ.analyzers.DataTypeInstances$;
import com.amazon.deequ.metrics.Distribution;
import com.amazon.deequ.metrics.DistributionValue;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class DataTypeHistogram$
implements Serializable {
    public static final DataTypeHistogram$ MODULE$;
    private final int SIZE_IN_BYTES;
    private final int NULL_POS;
    private final int FRACTIONAL_POS;
    private final int INTEGRAL_POS;
    private final int BOOLEAN_POS;
    private final int STRING_POS;

    static {
        new DataTypeHistogram$();
    }

    public int SIZE_IN_BYTES() {
        return this.SIZE_IN_BYTES;
    }

    public int NULL_POS() {
        return this.NULL_POS;
    }

    public int FRACTIONAL_POS() {
        return this.FRACTIONAL_POS;
    }

    public int INTEGRAL_POS() {
        return this.INTEGRAL_POS;
    }

    public int BOOLEAN_POS() {
        return this.BOOLEAN_POS;
    }

    public int STRING_POS() {
        return this.STRING_POS;
    }

    public DataTypeHistogram fromBytes(byte[] bytes) {
        Predef$.MODULE$.require(bytes.length == this.SIZE_IN_BYTES());
        LongBuffer buffer = ByteBuffer.wrap(bytes).asLongBuffer().asReadOnlyBuffer();
        long numNull = buffer.get(this.NULL_POS());
        long numFractional = buffer.get(this.FRACTIONAL_POS());
        long numIntegral = buffer.get(this.INTEGRAL_POS());
        long numBoolean = buffer.get(this.BOOLEAN_POS());
        long numString = buffer.get(this.STRING_POS());
        return new DataTypeHistogram(numNull, numFractional, numIntegral, numBoolean, numString);
    }

    public byte[] toBytes(long numNull, long numFractional, long numIntegral, long numBoolean, long numString) {
        ByteBuffer out = ByteBuffer.allocate(this.SIZE_IN_BYTES());
        LongBuffer outB = out.asLongBuffer();
        outB.put(numNull);
        outB.put(numFractional);
        outB.put(numIntegral);
        outB.put(numBoolean);
        outB.put(numString);
        byte[] bytes = new byte[out.remaining()];
        out.get(bytes);
        return bytes;
    }

    public Distribution toDistribution(DataTypeHistogram hist) {
        long totalObservations = hist.numNull() + hist.numString() + hist.numBoolean() + hist.numIntegral() + hist.numFractional();
        return new Distribution((Map<String, DistributionValue>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypeInstances$.MODULE$.Unknown().toString()), (Object)new DistributionValue(hist.numNull(), (double)hist.numNull() / (double)totalObservations)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypeInstances$.MODULE$.Fractional().toString()), (Object)new DistributionValue(hist.numFractional(), (double)hist.numFractional() / (double)totalObservations)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypeInstances$.MODULE$.Integral().toString()), (Object)new DistributionValue(hist.numIntegral(), (double)hist.numIntegral() / (double)totalObservations)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypeInstances$.MODULE$.Boolean().toString()), (Object)new DistributionValue(hist.numBoolean(), (double)hist.numBoolean() / (double)totalObservations)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypeInstances$.MODULE$.String().toString()), (Object)new DistributionValue(hist.numString(), (double)hist.numString() / (double)totalObservations))}))), 5L);
    }

    public Enumeration.Value determineType(Distribution dist) {
        return this.ratioOf(DataTypeInstances$.MODULE$.Unknown(), dist) == 1.0 ? DataTypeInstances$.MODULE$.Unknown() : (this.ratioOf(DataTypeInstances$.MODULE$.String(), dist) > 0.0 || this.ratioOf(DataTypeInstances$.MODULE$.Boolean(), dist) > 0.0 && (this.ratioOf(DataTypeInstances$.MODULE$.Integral(), dist) > 0.0 || this.ratioOf(DataTypeInstances$.MODULE$.Fractional(), dist) > 0.0) ? DataTypeInstances$.MODULE$.String() : (this.ratioOf(DataTypeInstances$.MODULE$.Boolean(), dist) > 0.0 ? DataTypeInstances$.MODULE$.Boolean() : (this.ratioOf(DataTypeInstances$.MODULE$.Fractional(), dist) > 0.0 ? DataTypeInstances$.MODULE$.Fractional() : DataTypeInstances$.MODULE$.Integral())));
    }

    private double ratioOf(Enumeration.Value key, Distribution distribution) {
        return ((DistributionValue)distribution.values().getOrElse((Object)key.toString(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DistributionValue apply() {
                return new DistributionValue(0L, 0.0);
            }
        })).ratio();
    }

    public DataTypeHistogram apply(long numNull, long numFractional, long numIntegral, long numBoolean, long numString) {
        return new DataTypeHistogram(numNull, numFractional, numIntegral, numBoolean, numString);
    }

    public Option<Tuple5<Object, Object, Object, Object, Object>> unapply(DataTypeHistogram x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.numNull()), (Object)BoxesRunTime.boxToLong((long)x$0.numFractional()), (Object)BoxesRunTime.boxToLong((long)x$0.numIntegral()), (Object)BoxesRunTime.boxToLong((long)x$0.numBoolean()), (Object)BoxesRunTime.boxToLong((long)x$0.numString())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DataTypeHistogram$() {
        MODULE$ = this;
        this.SIZE_IN_BYTES = 40;
        this.NULL_POS = 0;
        this.FRACTIONAL_POS = 1;
        this.INTEGRAL_POS = 2;
        this.BOOLEAN_POS = 3;
        this.STRING_POS = 4;
    }
}

