/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.deequ.analyzers;

import com.amazon.deequ.analyzers.Analyzer;
import com.amazon.deequ.analyzers.State;
import com.amazon.deequ.analyzers.runners.EmptyStateException;
import com.amazon.deequ.analyzers.runners.MetricCalculationException$;
import com.amazon.deequ.metrics.DoubleMetric;
import com.amazon.deequ.metrics.Entity$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Analyzers$ {
    public static final Analyzers$ MODULE$;
    private final String COL_PREFIX;
    private final String COUNT_COL;

    static {
        new Analyzers$();
    }

    public String COL_PREFIX() {
        return this.COL_PREFIX;
    }

    public String COUNT_COL() {
        return this.COUNT_COL;
    }

    public <S extends State<?>> Option<S> merge(Option<S> state, Option<S> anotherState, Seq<Option<S>> moreStates) {
        Seq statesToMerge = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{state, anotherState}))).$plus$plus(moreStates, Seq$.MODULE$.canBuildFrom());
        return (Option)statesToMerge.reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Option<S> apply(Option<S> stateA, Option<S> stateB) {
                Tuple2 tuple2 = new Tuple2((Object)stateA, (Object)stateB);
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option2 = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        State theStateA = (State)some.x();
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            State theStateB = (State)some2.x();
                            return new Some(theStateA.sumUntyped(theStateB));
                        }
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option3 = (Option)tuple2._2();
                    if (option instanceof Some && None$.MODULE$.equals(option3)) {
                        return stateA;
                    }
                }
                if (tuple2 == null) return None$.MODULE$;
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option)) return None$.MODULE$;
                if (!(option4 instanceof Some)) return None$.MODULE$;
                return stateB;
            }
        });
    }

    public <S extends State<?>> Option<S> ifNoNullsIn(Row result, int offset, int howMany, Function1<BoxedUnit, S> func) {
        boolean nullInResult = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + howMany).exists((Function1)new Serializable(result){
            public static final long serialVersionUID = 0L;
            private final Row result$1;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return this.result$1.isNullAt(index);
            }
            {
                this.result$1 = result$1;
            }
        });
        return nullInResult ? None$.MODULE$ : Option$.MODULE$.apply(func.apply((Object)BoxedUnit.UNIT));
    }

    public <S extends State<?>> int ifNoNullsIn$default$3() {
        return 1;
    }

    public Enumeration.Value entityFrom(Seq<String> columns) {
        return columns.size() == 1 ? Entity$.MODULE$.Column() : Entity$.MODULE$.Mutlicolumn();
    }

    public Column conditionalSelection(String selection, Option<String> where) {
        return this.conditionalSelection(functions$.MODULE$.col(selection), where);
    }

    public Column conditionalSelection(Column selection, Option<String> condition) {
        Option conditionColumn = condition.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String expression) {
                return functions$.MODULE$.expr(expression);
            }
        });
        return this.conditionalSelectionFromColumns(selection, (Option<Column>)conditionColumn);
    }

    private Column conditionalSelectionFromColumns(Column selection, Option<Column> conditionColumn) {
        return (Column)conditionColumn.map((Function1)new Serializable(selection){
            public static final long serialVersionUID = 0L;
            private final Column selection$1;

            public final Column apply(Column condition) {
                return functions$.MODULE$.when(condition, (Object)this.selection$1);
            }
            {
                this.selection$1 = selection$1;
            }
        }).getOrElse((Function0)new Serializable(selection){
            public static final long serialVersionUID = 0L;
            private final Column selection$1;

            public final Column apply() {
                return this.selection$1;
            }
            {
                this.selection$1 = selection$1;
            }
        });
    }

    public Column conditionalCount(Option<String> where) {
        return (Column)where.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String filter) {
                return functions$.MODULE$.sum(functions$.MODULE$.expr(filter).cast((DataType)LongType$.MODULE$));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypedColumn<Object, Object> apply() {
                return functions$.MODULE$.count("*");
            }
        });
    }

    public DoubleMetric metricFromValue(double value, String name, String instance, Enumeration.Value entity) {
        return new DoubleMetric(entity, name, instance, (Try<Object>)new Success((Object)BoxesRunTime.boxToDouble((double)value)));
    }

    public Enumeration.Value metricFromValue$default$4() {
        return Entity$.MODULE$.Column();
    }

    public EmptyStateException emptyStateException(Analyzer<?, ?> analyzer) {
        return new EmptyStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty state for analyzer ", ", all input values were NULL."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzer})));
    }

    public DoubleMetric metricFromEmpty(Analyzer<?, ?> analyzer, String name, String instance, Enumeration.Value entity) {
        return this.metricFromFailure(this.emptyStateException(analyzer), name, instance, entity);
    }

    public Enumeration.Value metricFromEmpty$default$4() {
        return Entity$.MODULE$.Column();
    }

    public DoubleMetric metricFromFailure(Throwable exception, String name, String instance, Enumeration.Value entity) {
        return new DoubleMetric(entity, name, instance, (Try<Object>)new Failure((Throwable)MetricCalculationException$.MODULE$.wrapIfNecessary(exception)));
    }

    public Enumeration.Value metricFromFailure$default$4() {
        return Entity$.MODULE$.Column();
    }

    private Analyzers$() {
        MODULE$ = this;
        this.COL_PREFIX = "com_amazon_deequ_dq_metrics_";
        this.COUNT_COL = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "count"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.COL_PREFIX()}));
    }
}

