/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.robolectric.shadows.MediaCodecInfoBuilder;
import org.robolectric.shadows.ShadowMediaCodec;
import org.robolectric.shadows.ShadowMediaCodecList;

public final class ShadowMediaCodecConfig
extends ExternalResource {
    public static ShadowMediaCodecConfig forAllSupportedMimeTypes() {
        return new ShadowMediaCodecConfig();
    }

    protected void before() throws Throwable {
        MediaCodecInfo.CodecProfileLevel avcProfileLevel = ShadowMediaCodecConfig.createProfileLevel(8, 524288);
        this.configureCodec("exotest.video.avc", "video/avc", (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of((Object)avcProfileLevel), (List<Integer>)ImmutableList.of((Object)2135033992));
        MediaCodecInfo.CodecProfileLevel mpeg2ProfileLevel = ShadowMediaCodecConfig.createProfileLevel(1, 1);
        this.configureCodec("exotest.video.mpeg2", "video/mpeg2", (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of((Object)mpeg2ProfileLevel), (List<Integer>)ImmutableList.of((Object)2135033992));
        this.configureCodec("exotest.video.vp9", "video/x-vnd.on2.vp9", (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of(), (List<Integer>)ImmutableList.of((Object)2135033992));
        this.configureCodec("exotest.audio.aac", "audio/mp4a-latm");
        this.configureCodec("exotest.audio.ac3", "audio/ac3");
        this.configureCodec("exotest.audio.ac4", "audio/ac4");
        this.configureCodec("exotest.audio.eac3", "audio/eac3");
        this.configureCodec("exotest.audio.eac3joc", "audio/eac3-joc");
        this.configureCodec("exotest.audio.flac", "audio/flac");
        this.configureCodec("exotest.audio.mpeg", "audio/mpeg");
        this.configureCodec("exotest.audio.mpegl2", "audio/mpeg-L2");
        this.configureCodec("exotest.audio.opus", "audio/opus");
        this.configureCodec("exotest.audio.vorbis", "audio/vorbis");
        this.configureCodec("exotest.audio.raw", "audio/raw");
    }

    protected void after() {
        MediaCodecUtil.clearDecoderInfoCache();
        ShadowMediaCodecList.reset();
        ShadowMediaCodec.clearCodecs();
    }

    private void configureCodec(String codecName, String mimeType) {
        this.configureCodec(codecName, mimeType, (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of(), (List<Integer>)ImmutableList.of());
    }

    private void configureCodec(String codecName, String mimeType, List<MediaCodecInfo.CodecProfileLevel> profileLevels, List<Integer> colorFormats) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", mimeType);
        MediaCodecInfoBuilder.CodecCapabilitiesBuilder capabilities = MediaCodecInfoBuilder.CodecCapabilitiesBuilder.newBuilder().setMediaFormat(mediaFormat);
        if (!profileLevels.isEmpty()) {
            capabilities.setProfileLevels(profileLevels.toArray(new MediaCodecInfo.CodecProfileLevel[0]));
        }
        if (!colorFormats.isEmpty()) {
            capabilities.setColorFormats(Ints.toArray(colorFormats));
        }
        ShadowMediaCodecList.addCodec((MediaCodecInfo)MediaCodecInfoBuilder.newBuilder().setName(codecName).setCapabilities(new MediaCodecInfo.CodecCapabilities[]{capabilities.build()}).build());
        CodecImpl codec = new CodecImpl(mimeType);
        ShadowMediaCodec.addDecoder((String)codecName, (ShadowMediaCodec.CodecConfig)new ShadowMediaCodec.CodecConfig(100000, 100000, (ShadowMediaCodec.CodecConfig.Codec)codec));
    }

    private static MediaCodecInfo.CodecProfileLevel createProfileLevel(int profile, int level) {
        MediaCodecInfo.CodecProfileLevel profileLevel = new MediaCodecInfo.CodecProfileLevel();
        profileLevel.profile = profile;
        profileLevel.level = level;
        return profileLevel;
    }

    private static final class CodecImpl
    implements ShadowMediaCodec.CodecConfig.Codec {
        private final String mimeType;

        public CodecImpl(String mimeType) {
            this.mimeType = mimeType;
        }

        public void process(ByteBuffer in, ByteBuffer out) {
            byte[] bytes = new byte[in.remaining()];
            in.get(bytes);
            if (!MimeTypes.isAudio((String)this.mimeType)) {
                out.put(bytes);
            }
        }
    }
}

