/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.dvbsi.AppInfoTable;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.flac.PictureFrame;
import com.google.android.exoplayer2.metadata.icy.IcyHeaders;
import com.google.android.exoplayer2.metadata.icy.IcyInfo;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.metadata.mp4.MdtaMetadataEntry;
import com.google.android.exoplayer2.metadata.mp4.MotionPhotoMetadata;
import com.google.android.exoplayer2.metadata.mp4.SlowMotionData;
import com.google.android.exoplayer2.metadata.mp4.SmtaMetadataEntry;
import com.google.android.exoplayer2.metadata.scte35.SpliceCommand;
import com.google.android.exoplayer2.metadata.vorbis.VorbisComment;
import com.google.android.exoplayer2.testutil.CapturingRenderersFactory;
import com.google.android.exoplayer2.testutil.Dumper;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.CueGroup;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PlaybackOutput
implements Dumper.Dumpable {
    private final CapturingRenderersFactory capturingRenderersFactory;
    private final List<Metadata> metadatas;
    private final List<CueGroup> subtitles;
    private final List<List<Cue>> subtitlesFromDeprecatedTextOutput;

    private PlaybackOutput(ExoPlayer player, CapturingRenderersFactory capturingRenderersFactory) {
        this.capturingRenderersFactory = capturingRenderersFactory;
        this.metadatas = Collections.synchronizedList(new ArrayList());
        this.subtitles = Collections.synchronizedList(new ArrayList());
        this.subtitlesFromDeprecatedTextOutput = Collections.synchronizedList(new ArrayList());
        player.addListener(new Player.Listener(){

            public void onMetadata(Metadata metadata) {
                PlaybackOutput.this.metadatas.add(metadata);
            }

            public void onCues(List<Cue> cues) {
                PlaybackOutput.this.subtitlesFromDeprecatedTextOutput.add(cues);
            }

            public void onCues(CueGroup cueGroup) {
                PlaybackOutput.this.subtitles.add(cueGroup);
            }
        });
    }

    public static PlaybackOutput register(ExoPlayer player, CapturingRenderersFactory capturingRenderersFactory) {
        return new PlaybackOutput(player, capturingRenderersFactory);
    }

    public void dump(Dumper dumper) {
        this.capturingRenderersFactory.dump(dumper);
        this.dumpMetadata(dumper);
        this.dumpSubtitles(dumper);
    }

    private void dumpMetadata(Dumper dumper) {
        if (this.metadatas.isEmpty()) {
            return;
        }
        dumper.startBlock("MetadataOutput");
        for (int i = 0; i < this.metadatas.size(); ++i) {
            dumper.startBlock("Metadata[" + i + "]");
            Metadata metadata = this.metadatas.get(i);
            dumper.add("presentationTimeUs", (Object)metadata.presentationTimeUs);
            for (int j = 0; j < metadata.length(); ++j) {
                dumper.add("entry[" + j + "]", (Object)PlaybackOutput.getEntryAsString(metadata.get(j)));
            }
            dumper.endBlock();
        }
        dumper.endBlock();
    }

    private static String getEntryAsString(Metadata.Entry entry) {
        if (entry instanceof EventMessage || entry instanceof PictureFrame || entry instanceof VorbisComment || entry instanceof Id3Frame || entry instanceof MdtaMetadataEntry || entry instanceof MotionPhotoMetadata || entry instanceof SlowMotionData || entry instanceof SmtaMetadataEntry || entry instanceof AppInfoTable || entry instanceof IcyHeaders || entry instanceof IcyInfo || entry instanceof SpliceCommand || "com.google.android.exoplayer2.source.hls.HlsTrackMetadataEntry".equals(entry.getClass().getCanonicalName())) {
            return entry.toString();
        }
        return entry.getClass().getSimpleName();
    }

    private void dumpSubtitles(Dumper dumper) {
        if (this.subtitles.size() != this.subtitlesFromDeprecatedTextOutput.size()) {
            throw new IllegalStateException("Expected subtitles to be of equal length from both implementations of onCues method.");
        }
        if (this.subtitles.isEmpty()) {
            return;
        }
        dumper.startBlock("TextOutput");
        for (int i = 0; i < this.subtitles.size(); ++i) {
            dumper.startBlock("Subtitle[" + i + "]");
            dumper.add("presentationTimeUs", (Object)Math.max(0L, this.subtitles.get((int)i).presentationTimeUs));
            ImmutableList subtitle = this.subtitles.get((int)i).cues;
            if (!subtitle.equals(this.subtitlesFromDeprecatedTextOutput.get(i))) {
                throw new IllegalStateException("Expected subtitle to be equal from both implementations of onCues method for index " + i);
            }
            if (subtitle.isEmpty()) {
                dumper.add("Cues", (Object)ImmutableList.of());
            }
            for (int j = 0; j < subtitle.size(); ++j) {
                dumper.startBlock("Cue[" + j + "]");
                Cue cue = (Cue)subtitle.get(j);
                PlaybackOutput.dumpIfNotEqual(dumper, "text", cue.text, null);
                PlaybackOutput.dumpIfNotEqual(dumper, "textAlignment", cue.textAlignment, null);
                PlaybackOutput.dumpBitmap(dumper, cue.bitmap);
                PlaybackOutput.dumpIfNotEqual(dumper, "line", Float.valueOf(cue.line), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "lineType", cue.lineType, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "lineAnchor", cue.lineAnchor, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "position", Float.valueOf(cue.position), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "positionAnchor", cue.positionAnchor, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "size", Float.valueOf(cue.size), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "bitmapHeight", Float.valueOf(cue.bitmapHeight), Float.valueOf(-3.4028235E38f));
                if (cue.windowColorSet) {
                    dumper.add("cue.windowColor", (Object)cue.windowColor);
                }
                PlaybackOutput.dumpIfNotEqual(dumper, "textSizeType", cue.textSizeType, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "textSize", Float.valueOf(cue.textSize), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "verticalType", cue.verticalType, Integer.MIN_VALUE);
                dumper.endBlock();
            }
            dumper.endBlock();
        }
        dumper.endBlock();
    }

    private static void dumpIfNotEqual(Dumper dumper, String field, @Nullable Object actual, @Nullable Object comparison) {
        if (!Util.areEqual((Object)actual, (Object)comparison)) {
            dumper.add(field, actual);
        }
    }

    private static void dumpBitmap(Dumper dumper, @Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        byte[] bytes = new byte[bitmap.getByteCount()];
        bitmap.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(bytes));
        dumper.add("bitmap", bytes);
    }
}

