/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.SharedPreferences;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbConstants;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.PrivacyLocationMode;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class DtbSharedPreferences {
    private final String LOG_TAG = DtbSharedPreferences.class.getSimpleName();
    public static DtbSharedPreferences dtbSharedPreferencesInstance = null;
    private static final String PREF_FILE_NAME = "com.amazon.device.ads.dtb.preferences";
    private static final String ADID_PREF_NAME = "amzn-dtb-ad-id";
    private static final String SIS_LAST_CHECKIN_PREF_NAME = "amzn-dtb-ad-sis-last-checkin";
    private static final String CONFIG_LAST_CHECKIN_PREF_NAME = "amzn-dtb-ad-config-last-checkin";
    private static final String IDFA_PREF_NAME = "amzn-dtb-idfa";
    private static final String CONFIG_TTL_PREF_NAME = "amzn-dtb-ad-config-ttl";
    private static final String AAX_HOSTNAME_PREF_NAME = "amzn-dtb-ad-aax-hostname";
    private static final String AAX_VIDEO_HOSTNAME_PREF_NAME = "amzn-dtb-ad-aax-video-hostname";
    private static final String SIS_ENDPOINT_PREF_NAME = "amzn-dtb-ad-sis-endpoint";
    private static final String SIS_LAST_PING_PREF_NAME = "amzn-dtb-ad-sis-last-ping";
    private static final String SIS_LAST_PING_WEB_RESOURCES = "amzn-dtb-web-resource-ping";
    private static final String SDK_WRAPPER_PING = "sdk-wrapper-ping";
    private static final String OO_PREF_NAME = "amzn-dtb-oo";
    private static final String IS_ADID_CHANGED_PREF_NAME = "amzn-dtb-adid-changed";
    private static final String IS_ADID_NEW_PREF_NAME = "amzn-dtb-adid-new";
    private static final String IS_GPS_UNAVAILABLE_PREF_NAME = "amzn-dtb-is-gps-unavailable";
    private static final String DTB_VERSION_IN_USE = "amzn-dtb-version_in_use";
    private static final String NON_IAB_VENDORLIST = "NON_IAB_VENDORLIST";
    private static final String NON_IAB_CONSENT_STATUS = "NON_IAB_CONSENT_STATUS";
    private static final String NON_IAB_CMP_FLAVOR = "NON_IAB_CMP_FLAVOR";
    private static final String NON_IAB_CUSTOM_CONSENT = "NON_IAB_Custom_Consent";
    private static final String PJ_TEMPLATE_PREF_NAME = "amzn-dtb-pj-template";
    private static final String ENCODED_PRICE_CHECK_PREF_NAME = "amzn-dtb-enable-encoded-price-check";
    private static final String BID_TIMEOUT_PREF_NAME = "amzn-dtb-bid-timeout";
    private static final String PRIVACY_LOCATION_MODE_PREF_NAME = "amzn-dtb-privacy-location-mode";
    private static final String PRIVACY_LOCATION_ACCURACY_IN_METERS_PREF_NAME = "amzn-dtb-privacy-location-accuracy-in-meters";
    private static SharedPreferences sharedPreferences;
    private static boolean isIgnore;
    private static boolean IS_SIS_REGISTERATION_SUCCESSFUL;

    static void setIgnoreMode() {
        isIgnore = true;
    }

    public boolean getIsSisRegisterationSuccessful() {
        return IS_SIS_REGISTERATION_SUCCESSFUL;
    }

    public void setIsSisRegisterationSuccessful(boolean isSisRegisterationSuccessful) {
        IS_SIS_REGISTERATION_SUCCESSFUL = isSisRegisterationSuccessful;
    }

    private static SharedPreferences getSharedPreferences() {
        if (sharedPreferences == null) {
            sharedPreferences = AdRegistration.getContext().getSharedPreferences(PREF_FILE_NAME, 0);
        }
        return sharedPreferences;
    }

    public DtbSharedPreferences() {
        if (AdRegistration.getContext() != null) {
            sharedPreferences = AdRegistration.getContext().getSharedPreferences(PREF_FILE_NAME, 0);
        }
    }

    public static DtbSharedPreferences createInstance() {
        dtbSharedPreferencesInstance = new DtbSharedPreferences();
        return dtbSharedPreferencesInstance;
    }

    public static DtbSharedPreferences getInstance() {
        if (dtbSharedPreferencesInstance == null) {
            DtbSharedPreferences.createInstance();
        }
        return dtbSharedPreferencesInstance;
    }

    public String getVersionInUse() {
        return DtbSharedPreferences.getPref(DTB_VERSION_IN_USE, String.class);
    }

    public void setVersionInUse(String versionInUse) {
        DtbSharedPreferences.savePref(DTB_VERSION_IN_USE, versionInUse);
    }

    public String getAdId() {
        return DtbSharedPreferences.getPref(ADID_PREF_NAME, String.class);
    }

    public void saveAdId(String adId) {
        if (adId != null) {
            DtbSharedPreferences.savePref(ADID_PREF_NAME, adId);
        }
    }

    public void removeAdid() {
        DtbSharedPreferences.flushPreference(ADID_PREF_NAME);
    }

    public String getIdfa() {
        return DtbSharedPreferences.getPref(IDFA_PREF_NAME, String.class);
    }

    public void saveIdfa(String idfa) {
        if (idfa != null) {
            DtbSharedPreferences.savePref(IDFA_PREF_NAME, idfa);
        } else {
            DtbSharedPreferences.savePref(IDFA_PREF_NAME, "");
        }
    }

    public synchronized Boolean getOptOut() {
        if (!DtbSharedPreferences.containsPreference(OO_PREF_NAME)) {
            return null;
        }
        return DtbSharedPreferences.getPref(OO_PREF_NAME, Boolean.class);
    }

    public synchronized void saveOptOut(Boolean oo) {
        DtbSharedPreferences.flushPreference(OO_PREF_NAME);
        if (oo != null) {
            DtbSharedPreferences.savePref(OO_PREF_NAME, oo);
        }
    }

    public boolean getIsAdIdNew() {
        return DtbSharedPreferences.getPref(IS_ADID_NEW_PREF_NAME, Boolean.class);
    }

    public void saveIsAdIdNew(boolean value) {
        DtbSharedPreferences.savePref(IS_ADID_NEW_PREF_NAME, value);
    }

    public boolean getIsAdIdChanged() {
        return DtbSharedPreferences.getPref(IS_ADID_CHANGED_PREF_NAME, Boolean.class);
    }

    public void saveIsAdIdChanged(boolean value) {
        DtbSharedPreferences.savePref(IS_ADID_CHANGED_PREF_NAME, value);
    }

    public Long getSisLastCheckIn() {
        return DtbSharedPreferences.getPref(SIS_LAST_CHECKIN_PREF_NAME, Long.class);
    }

    public void saveSisLastCheckIn(long time) {
        DtbSharedPreferences.savePref(SIS_LAST_CHECKIN_PREF_NAME, time);
    }

    public Long getConfigLastCheckIn() {
        long configLastCheckIn = DtbSharedPreferences.getPref(CONFIG_LAST_CHECKIN_PREF_NAME, Long.class);
        if (configLastCheckIn <= 0L) {
            configLastCheckIn = this.getSisLastCheckIn();
        }
        return configLastCheckIn;
    }

    public void saveConfigLastCheckIn(long time) {
        DtbSharedPreferences.savePref(CONFIG_LAST_CHECKIN_PREF_NAME, time);
    }

    public void saveAaxHostname(String host) {
        this.saveHostName(host, AAX_HOSTNAME_PREF_NAME);
    }

    public void saveAaxVideoHostname(String host) {
        this.saveHostName(host, AAX_VIDEO_HOSTNAME_PREF_NAME);
    }

    private void saveHostName(String host, String preferenceName) {
        if (!DtbCommonUtils.isNullOrEmpty(host)) {
            DtbSharedPreferences.savePref(preferenceName, host);
        } else {
            DtbSharedPreferences.savePref(preferenceName, DtbConstants.AAX_HOSTNAME);
        }
    }

    public String getAaxHostname() {
        String host = DtbSharedPreferences.getPref(AAX_HOSTNAME_PREF_NAME, String.class);
        if (AdRegistration.isTestMode() && DtbDebugProperties.isInternalDebugMode) {
            return DtbDebugProperties.getAaxHostName(host == null ? DtbConstants.AAX_HOSTNAME : host);
        }
        if (DtbCommonUtils.isNullOrEmpty(host)) {
            return DtbConstants.AAX_HOSTNAME;
        }
        return host;
    }

    public String getAaxVideoHostName() {
        return DtbSharedPreferences.getPref(AAX_VIDEO_HOSTNAME_PREF_NAME, String.class);
    }

    public synchronized long getConfigTtlInMilliSeconds() {
        long ttlMilliseconds = DtbSharedPreferences.getPref(CONFIG_TTL_PREF_NAME, Long.class);
        if (ttlMilliseconds < 900000L) {
            return 172800000L;
        }
        return ttlMilliseconds;
    }

    public synchronized void saveConfigTtlInMilliSeconds(long ttl) {
        long ttlMilliseconds = ttl * 1000L;
        if (ttlMilliseconds < 900000L) {
            DtbSharedPreferences.savePref(CONFIG_TTL_PREF_NAME, 172800000L);
        } else {
            DtbSharedPreferences.savePref(CONFIG_TTL_PREF_NAME, ttlMilliseconds);
        }
    }

    public boolean saveSisEndpoint(String sis) {
        if (!DtbCommonUtils.isNullOrEmpty(sis)) {
            String oldSis = DtbSharedPreferences.getPref(SIS_ENDPOINT_PREF_NAME, String.class);
            String newSis = sis + "/api3";
            if (oldSis != null && oldSis.equals(newSis)) {
                return false;
            }
            DtbSharedPreferences.savePref(SIS_ENDPOINT_PREF_NAME, newSis);
            return true;
        }
        DtbSharedPreferences.savePref(SIS_ENDPOINT_PREF_NAME, DtbConstants.SIS_END_POINT + "/api3");
        return false;
    }

    public String getSisEndpoint() {
        String sis = DtbSharedPreferences.getPref(SIS_ENDPOINT_PREF_NAME, String.class);
        if (DtbCommonUtils.isNullOrEmpty(sis)) {
            return DtbConstants.SIS_END_POINT + "/api3";
        }
        return sis;
    }

    void saveWebResoucesLastPing(long time) {
        DtbSharedPreferences.savePref(SIS_LAST_PING_WEB_RESOURCES, time);
    }

    Long getWebResoucesLastPing() {
        return DtbSharedPreferences.getPref(SIS_LAST_PING_WEB_RESOURCES, Long.class);
    }

    void resetWebResoucesLastPing() {
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        if (sharedPreferences != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(SIS_LAST_PING_WEB_RESOURCES);
            editor.commit();
        }
    }

    void saveWrapperDetectionLastPing(long time) {
        DtbSharedPreferences.savePref(SDK_WRAPPER_PING, time);
    }

    Long getWrapperDetectionLastPing() {
        return DtbSharedPreferences.getPref(SDK_WRAPPER_PING, Long.class);
    }

    void resetWrapperDetectionLastPing() {
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        if (sharedPreferences != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(SDK_WRAPPER_PING);
            editor.commit();
        }
    }

    public void saveSisLastPing(long time) {
        DtbSharedPreferences.savePref(SIS_LAST_PING_PREF_NAME, time);
    }

    public long getSisLastPing() {
        return DtbSharedPreferences.getPref(SIS_LAST_PING_PREF_NAME, Long.class);
    }

    private static <T> void savePref(String key, T value) {
        if (isIgnore) {
            return;
        }
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        if (sharedPreferences != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            if (value instanceof Boolean) {
                editor.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (value instanceof String) {
                editor.putString(key, (String)value);
            } else if (value instanceof Integer) {
                editor.putInt(key, ((Integer)value).intValue());
            } else if (value instanceof Float) {
                editor.putFloat(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                editor.putLong(key, ((Long)value).longValue());
            } else if (value instanceof Set) {
                editor.putStringSet(key, (Set)value);
            } else {
                throw new IllegalArgumentException("Saving of " + value.getClass() + " is not supported.");
            }
            editor.commit();
        }
    }

    private static <T> T getPref(String key, Class<T> clazz) {
        if (isIgnore) {
            return null;
        }
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        if (clazz.isAssignableFrom(String.class)) {
            return (T)sharedPreferences.getString(key, null);
        }
        if (clazz.isAssignableFrom(Set.class)) {
            return (T)sharedPreferences.getStringSet(key, null);
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(sharedPreferences.getBoolean(key, false));
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(sharedPreferences.getLong(key, 0L));
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(sharedPreferences.getInt(key, 0));
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return (T)Float.valueOf(sharedPreferences.getFloat(key, 0.0f));
        }
        throw new IllegalArgumentException(clazz.getName() + " is not supported");
    }

    private static boolean containsPreference(String key) {
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        return sharedPreferences.contains(key);
    }

    private static void flushPreference(String key) {
        SharedPreferences sharedPreferences = DtbSharedPreferences.getSharedPreferences();
        if (sharedPreferences.contains(key)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(key);
            editor.apply();
        }
    }

    public void saveVendorList(String vendorList) {
        DtbSharedPreferences.savePref(NON_IAB_VENDORLIST, vendorList);
    }

    public String getVendorList() {
        return DtbSharedPreferences.getPref(NON_IAB_VENDORLIST, String.class);
    }

    public void saveConsentStatus(String consentStatus) {
        DtbSharedPreferences.savePref(NON_IAB_CONSENT_STATUS, consentStatus);
    }

    public String getConsentStatus() {
        return DtbSharedPreferences.getPref(NON_IAB_CONSENT_STATUS, String.class);
    }

    public void saveCMPFlavor(String cmpFlavor) {
        DtbSharedPreferences.savePref(NON_IAB_CMP_FLAVOR, cmpFlavor);
    }

    public String getCMPFlavor() {
        return DtbSharedPreferences.getPref(NON_IAB_CMP_FLAVOR, String.class);
    }

    public void saveNonIABCustomConsent(String encodedNONIABString) {
        DtbSharedPreferences.savePref(NON_IAB_CUSTOM_CONSENT, encodedNONIABString);
    }

    public String getNonIABCustomConsent() {
        return DtbSharedPreferences.getPref(NON_IAB_CUSTOM_CONSENT, String.class);
    }

    public void removeVendorList() {
        DtbSharedPreferences.flushPreference(NON_IAB_VENDORLIST);
    }

    public void removeCMPFlavor() {
        DtbSharedPreferences.flushPreference(NON_IAB_CMP_FLAVOR);
    }

    public void removeConsentStatus() {
        DtbSharedPreferences.flushPreference(NON_IAB_CONSENT_STATUS);
    }

    public void removeNonIABCustomConsent() {
        DtbSharedPreferences.flushPreference(NON_IAB_CUSTOM_CONSENT);
    }

    public void savePJTemplate(JSONObject pjObject) {
        if (pjObject != null) {
            String pjTemplate = pjObject.toString();
            DtbSharedPreferences.savePref(PJ_TEMPLATE_PREF_NAME, pjTemplate);
        }
    }

    public JSONObject getPJTemplate() {
        JSONObject pjObject;
        String pjTemplate = DtbSharedPreferences.getPref(PJ_TEMPLATE_PREF_NAME, String.class);
        try {
            pjObject = new JSONObject(pjTemplate);
        }
        catch (Exception e) {
            pjObject = new JSONObject();
            DtbLog.warn(this.LOG_TAG, "Get Pj template failed when fetching from Cache");
        }
        return pjObject;
    }

    public void removePJTemplate() {
        DtbSharedPreferences.flushPreference(PJ_TEMPLATE_PREF_NAME);
    }

    public void saveBidTimeout(Integer timeout) {
        DtbSharedPreferences.savePref(BID_TIMEOUT_PREF_NAME, timeout);
    }

    public int getBidTimeout() {
        Integer bidTimeout = DtbSharedPreferences.getPref(BID_TIMEOUT_PREF_NAME, Integer.class);
        if (bidTimeout != null && bidTimeout != 0) {
            return bidTimeout;
        }
        return 5000;
    }

    public void removeBidTimeout() {
        DtbSharedPreferences.flushPreference(BID_TIMEOUT_PREF_NAME);
    }

    synchronized void savePrivacyLocationConfig(JSONObject privacyLocation) {
        try {
            DtbSharedPreferences.savePref(PRIVACY_LOCATION_MODE_PREF_NAME, privacyLocation.getString("mode"));
            DtbSharedPreferences.savePref(PRIVACY_LOCATION_ACCURACY_IN_METERS_PREF_NAME, Float.valueOf((float)privacyLocation.getDouble("accuracyInMeters")));
        }
        catch (JSONException e) {
            DtbLog.error(this.LOG_TAG, "Failed to save privacy configurations in shared preferences");
        }
    }

    synchronized PrivacyLocationMode getPrivacyLocationConfigMode() {
        String mode = DtbSharedPreferences.getPref(PRIVACY_LOCATION_MODE_PREF_NAME, String.class);
        if (!DtbCommonUtils.isNullOrEmpty(mode)) {
            switch (mode) {
                case "Fixed": {
                    return PrivacyLocationMode.FIXED;
                }
                case "Compute": {
                    return PrivacyLocationMode.COMPUTE;
                }
            }
        }
        return PrivacyLocationMode.RESTRICTED;
    }

    synchronized float getPrivacyLocationConfigAccuracyInMeters() {
        Float accuracy = DtbSharedPreferences.getPref(PRIVACY_LOCATION_ACCURACY_IN_METERS_PREF_NAME, Float.class);
        if (accuracy == null) {
            return Float.MAX_VALUE;
        }
        return accuracy.floatValue();
    }

    synchronized void removePrivacyLocationConfig() {
        DtbSharedPreferences.flushPreference(PRIVACY_LOCATION_MODE_PREF_NAME);
        DtbSharedPreferences.flushPreference(PRIVACY_LOCATION_ACCURACY_IN_METERS_PREF_NAME);
    }

    static {
        isIgnore = false;
        IS_SIS_REGISTERATION_SUCCESSFUL = false;
    }
}

