/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdUtil;

public class DtbDeviceDataRetriever {
    public static final String ORIENTATION_PORTRAIT = "portrait";
    public static final String ORIENTATION_LANDSCAPE = "landscape";
    public static final String ORIENTATION_UNKNOWN = "unknown";
    private static final int SMALLEST_TABLET_SCREEN_WIDTH = 600;
    private static int[][] rotationArray = new int[][]{{1, 0, 9, 8}, {0, 9, 8, 1}};

    public static String getScreenSize(DisplayMetrics metrics, String orientation) {
        try {
            WindowManager wm = (WindowManager)AdRegistration.getContext().getSystemService("window");
            wm.getDefaultDisplay().getRealMetrics(metrics);
            int screenWidth = metrics.widthPixels;
            int screenHeight = metrics.heightPixels;
            int widthDp = DTBAdUtil.pixelsToDeviceIndependenPixels(screenWidth);
            int heightDp = DTBAdUtil.pixelsToDeviceIndependenPixels(screenHeight);
            if (orientation.equals(ORIENTATION_LANDSCAPE)) {
                if (widthDp < heightDp) {
                    int tmp = widthDp;
                    widthDp = heightDp;
                    heightDp = tmp;
                }
            } else if (widthDp > heightDp) {
                int tmp = widthDp;
                widthDp = heightDp;
                heightDp = tmp;
            }
            return String.valueOf(widthDp) + "x" + String.valueOf(heightDp);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getOrientation(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int rotation = display.getRotation();
        if (rotation == 0 || rotation == 2) {
            return ORIENTATION_PORTRAIT;
        }
        return ORIENTATION_LANDSCAPE;
    }

    public static String getCanonicalOrientation(Context context) {
        String orientation;
        int canonicalOrientation = DtbDeviceDataRetriever.determineCanonicalScreenOrientation(context);
        switch (canonicalOrientation) {
            case 1: 
            case 9: {
                orientation = ORIENTATION_PORTRAIT;
                break;
            }
            case 0: 
            case 8: {
                orientation = ORIENTATION_LANDSCAPE;
                break;
            }
            default: {
                orientation = ORIENTATION_UNKNOWN;
            }
        }
        return orientation;
    }

    private static int determineCanonicalScreenOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int rotation = display.getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        boolean naturalOrientationIsPortrait = orientation == 1 ? rotation == 0 || rotation == 2 : (orientation == 2 ? rotation == 1 || rotation == 3 : true);
        int rotationSelector = naturalOrientationIsPortrait ? 0 : 1;
        return rotationArray[rotationSelector][rotation];
    }

    public static boolean isTablet() {
        return AdRegistration.getContext().getResources().getConfiguration().smallestScreenWidthDp >= 600;
    }
}

