/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbThreadService;
import com.amazon.device.ads.WebResourceOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DTBMetricsConfiguration {
    private static final String LOG_TAG = DTBMetricsConfiguration.class.getSimpleName();
    private static DTBMetricsConfiguration theInstance;
    private JSONObject configuration;
    static final String CONFIG_WITH_JSON = "aps_mobile_client_config.json";
    static final String CONFIG_DIR = "config";
    static final String SAMPLE_RATES_KEY_NAME = "sample_rates";
    static final String ANALYTICS_KEY_NAME = "analytics";
    static final String SPP_FLAG_KEY_NAME = "spp_flag";
    static final String TEMPLATES_KEY_NAME = "templates";
    static final String WRAPPING_PIXEL_SAMPLE_RATE_KEY_NAME = "wrapping_pixel";
    static final String DISTRIBUTION_PIXEL_SAMPLE_RATE_KEY_NAME = "distribution_pixel";
    static final String SAMPLING_RATE_ANALYTICS_KEY_NAME = "sampling_rate";
    static final String URL_ANALYTICS_KEY_NAME = "url";
    static final String API_KEY_ANALYTICS_KEY_NAME = "api_key";
    static final String CREATIVE_TEMPLATES_KEY_NAME = "creative";
    static final String OM_SDK_FEATURE_KEY_NAME = "om_sdk_feature";
    static final String OM_SDK_FEATURE_ENABLE_KEY_NAME = "feature_enabled";
    static final String OM_SDK_CONFIGURABLE_PARTNER_KEY_NAME = "partner_name";
    static final String OM_SDK_DENIED_VERSION_KEY_NAME = "denied_version_list";
    static final String FEATURE_FLAG = "feature_toggle";
    public static final String FEATURE_AD_FORMAT_FROM_AAX = "ad_format_from_bid_response";
    public static final String FEATURE_LOG_API_TYPE_USAGE = "log_api_type_usage";
    public static final String FEATURE_CONFIG_IN_INIT = "config_in_init";
    public static final String FEATURE_ENABLE_DEFAULT_AD_SIZE = "enable_default_ad_size_to_bid_request";
    public static final String FEATURE_ENABLE_APS_BID_FLAG = "enable_aps_bid_flag";
    public static final String FEATURE_FLAG_GPP_PARAMS_TO_AIP_CALL = "enable_gpp_params_to_aip_call";
    public static final String APSMETRICS_LEVEL1_KEY = "apsmetricsv2";
    public static final String APSMETRICS_LEVEL2_KEY = "mobile";
    public static final String APSMETRICS_SAMPLING_RATE = "samplingPercentage";
    public static final String APSMETRICS_APIKEY = "apiKey";
    public static final String APSMETRICS_URL = "url";
    public static final String FEATURE_APSMETRICS_EXTENDED_METRICS = "apsmetrics_extended_metrics";
    static final Integer WRAPPING_PIXEL_DEFAULT_VALUE;
    static final Integer DISTRIBUTION_PIXEL_DEFAULT_VALUE;
    static final Integer ANALYTIC_PIXEL_DEFAULT_VALUE;
    static final String SPP_FLAG_DEFAULT_VALUE = "leq";
    public static final String CUSTOM_TAB_FEATURE_ENABLED_FLAG = "custom_tab_feature_enabled_flag";

    public static synchronized DTBMetricsConfiguration getInstance() {
        if (theInstance == null) {
            theInstance = new DTBMetricsConfiguration();
        }
        return theInstance;
    }

    private DTBMetricsConfiguration() {
        this.loadMobileClientConfig();
    }

    protected void loadMobileClientConfig() {
        DTBAdUtil.createDirIfDoesNotExist(CONFIG_DIR);
        this.loadConfiguration();
        DtbThreadService.getInstance().execute(() -> this.loadConfigurationFromWeb());
    }

    synchronized void loadConfiguration() {
        try {
            String content = this.getWorkingDirContent();
            if (content == null) {
                content = DTBAdUtil.loadFromAssets(CONFIG_WITH_JSON);
            }
            this.configuration = new JSONObject(content);
        }
        catch (IOException | RuntimeException | JSONException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error loading the configuration from assets", (Exception)e);
        }
    }

    private void loadConfigurationFromWeb() {
        try {
            boolean result;
            DtbHttpClient client = new DtbHttpClient(WebResourceOptions.getCDNHost(CONFIG_WITH_JSON) + CONFIG_WITH_JSON);
            client.setUseSecure(DtbDebugProperties.getIsSecure(true));
            client.executeGET(60000);
            if (client.getResponseCode() != 200) {
                throw new RuntimeException("resource aps_mobile_client_config.json not available");
            }
            String content = client.getResponse();
            File fileDir = AdRegistration.getContext().getFilesDir();
            File f = File.createTempFile("temp", "json", fileDir);
            FileWriter out = new FileWriter(f);
            out.write(content);
            out.close();
            File dest = new File(fileDir.getAbsolutePath() + "/" + CONFIG_DIR + "/" + CONFIG_WITH_JSON);
            if (dest.exists()) {
                dest.delete();
            }
            if (!(result = f.renameTo(dest))) {
                DtbLog.error("Rename failed");
            }
            this.loadConfiguration();
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error loading the configuration from web", e);
        }
    }

    public synchronized boolean isTypeEnabled(String type) {
        if (this.configuration != null) {
            try {
                JSONObject json = this.configuration.getJSONObject("metrics");
                if (json.has(type)) {
                    return json.getBoolean(type);
                }
            }
            catch (JSONException ex) {
                DtbLog.error("Unable to get metrics from configuration");
            }
        }
        return false;
    }

    public boolean isFeatureEnabled(String type, boolean defaultVal) {
        if (this.configuration != null && this.configuration.has(FEATURE_FLAG)) {
            try {
                JSONObject json = this.configuration.getJSONObject(FEATURE_FLAG);
                if (json.has(type)) {
                    return json.getBoolean(type);
                }
            }
            catch (JSONException ex) {
                DtbLog.error("Unable to get feature flag from configuration");
            }
        }
        return defaultVal;
    }

    public boolean isFeatureEnabled(String type) {
        return this.isFeatureEnabled(type, true);
    }

    private JSONObject getConfigParams(String keyName) {
        if (this.configuration.has(keyName)) {
            try {
                return this.configuration.getJSONObject(keyName);
            }
            catch (JSONException ex) {
                DtbLog.error("Unable to get" + keyName + "from configuration");
            }
        }
        return null;
    }

    public String getConfigVal(String keyName) {
        if (this.configuration.has(keyName)) {
            try {
                return this.configuration.getString(keyName);
            }
            catch (JSONException ex) {
                DtbLog.error("Unable to get" + keyName + "from configuration");
            }
        }
        return null;
    }

    public static Double getClientConfigVal(String level1Key, String level2Key, String keyName, double defaultValue) {
        try {
            JSONObject jsonObject = DTBMetricsConfiguration.getInstance().getConfigParams(level1Key).getJSONObject(level2Key);
            if (jsonObject != null && jsonObject.has(keyName)) {
                return jsonObject.getDouble(keyName);
            }
        }
        catch (RuntimeException | JSONException e) {
            ApsLog.d("Error reading the int config value " + level1Key + ":" + level2Key + ":" + keyName);
        }
        return defaultValue;
    }

    public static String getClientConfigVal(String level1Key, String level2Key, String keyName, String defaultValue) {
        try {
            JSONObject jsonObject = DTBMetricsConfiguration.getInstance().getConfigParams(level1Key).getJSONObject(level2Key);
            if (jsonObject != null && jsonObject.has(keyName)) {
                return jsonObject.getString(keyName);
            }
        }
        catch (RuntimeException | JSONException e) {
            ApsLog.d("Error reading the String config value " + level1Key + ":" + level2Key + ":" + keyName);
        }
        return defaultValue;
    }

    public static Integer getClientConfigVal(String pixelKey, int defaultValue, String configParamName) {
        block5: {
            try {
                DTBMetricsConfiguration config = DTBMetricsConfiguration.getInstance();
                JSONObject sampleRates = config.getConfigParams(configParamName);
                if (sampleRates == null) break block5;
                try {
                    if (sampleRates.has(pixelKey)) {
                        return sampleRates.getInt(pixelKey);
                    }
                }
                catch (Exception ex) {
                    DtbLog.warn("Unable to get" + configParamName + "for " + pixelKey + " from configuration. Using default value");
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getClientConfigVal method", e);
            }
        }
        return defaultValue;
    }

    public static String getClientConfigVal(String pixelKey, String defaultValue, String configParamName) {
        block5: {
            try {
                DTBMetricsConfiguration config = DTBMetricsConfiguration.getInstance();
                JSONObject sampleRates = config.getConfigParams(configParamName);
                if (sampleRates == null) break block5;
                try {
                    if (sampleRates.has(pixelKey)) {
                        return sampleRates.getString(pixelKey);
                    }
                }
                catch (Exception ex) {
                    DtbLog.warn("Unable to get" + configParamName + "for " + pixelKey + " from configuration. Using default value");
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getClientConfigVal method", e);
            }
        }
        return defaultValue;
    }

    public static String getClientConfigVal(String defaultValue, String configParamName) {
        try {
            DTBMetricsConfiguration config = DTBMetricsConfiguration.getInstance();
            String configVal = config.getConfigVal(configParamName);
            if (!DtbCommonUtils.isNullOrEmpty(configVal)) {
                return configVal;
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getClientConfigVal method", e);
        }
        return defaultValue;
    }

    public static Integer getAnalyticsParams(String pixelKey, int defaultValue) {
        block5: {
            try {
                DTBMetricsConfiguration config = DTBMetricsConfiguration.getInstance();
                JSONObject sampleRates = config.getConfigParams(ANALYTICS_KEY_NAME);
                if (sampleRates == null) break block5;
                try {
                    if (sampleRates.has(pixelKey)) {
                        return sampleRates.getInt(pixelKey);
                    }
                }
                catch (Exception ex) {
                    DtbLog.warn("Unable to get sample rates for " + pixelKey + " from configuration. Using default value");
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSampleRateForPixel method", e);
            }
        }
        return defaultValue;
    }

    public static List<String> getDeniedOmSdkVersionList(String deniedOmSdkVersionConfigKeyName) {
        ArrayList<String> list;
        block6: {
            list = new ArrayList<String>();
            try {
                DTBMetricsConfiguration config = DTBMetricsConfiguration.getInstance();
                JSONObject sampleRates = config.getConfigParams(OM_SDK_FEATURE_KEY_NAME);
                if (sampleRates == null) break block6;
                try {
                    if (sampleRates.has(deniedOmSdkVersionConfigKeyName)) {
                        JSONArray deniedVersionListArray = sampleRates.getJSONArray(deniedOmSdkVersionConfigKeyName);
                        for (int i = 0; i < deniedVersionListArray.length(); ++i) {
                            Object value = deniedVersionListArray.get(i);
                            if (!(value instanceof String)) continue;
                            list.add(value.toString());
                        }
                    }
                }
                catch (JSONException ex) {
                    APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getOMSDKVersionList method", (Exception)((Object)ex));
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getOMSDKVersionList method", e);
            }
        }
        return list;
    }

    private String getWorkingDirContent() throws IOException {
        return DTBAdUtil.loadFile(CONFIG_WITH_JSON, CONFIG_DIR);
    }

    static {
        WRAPPING_PIXEL_DEFAULT_VALUE = 5;
        DISTRIBUTION_PIXEL_DEFAULT_VALUE = 1;
        ANALYTIC_PIXEL_DEFAULT_VALUE = 1;
    }
}

