/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.util.Base64;
import com.amazon.device.ads.AdRegistration;
import java.util.Collections;
import java.util.List;

class DTBGDPREncoder {
    private static final int TOTAL_NUMBER_OF_BITS_FOR_META_INFO = 32;
    private static final int CONSENT_STRING_VERSION_START_INDEX = 6;
    private static final int CMP_INDICATOR_START_INDEX = 11;
    private static final int CONSENT_STATUS_START_INDEX = 15;
    private static final int MAX_VENDOR_ID_START_INDEX = 18;
    private static final int CONSENT_STRING_VERSION_INDICATOR_RANGE = 5;
    private static final int CMP_INDICATOR_RANGE = 4;
    private static final int CONSENT_STATUS_INDICATOR_RANGE = 3;
    private static final int MAX_VENDOR_ID_INDICATOR_RANGE = 14;
    private static final int AMAZON_CONSENT_STRING_VERSION_VALUE = 1;
    private static final int GOOGLE_CMP_VALUE = 1;
    private static final int MOPUB_CMP_VALUE = 2;
    private static final int EXPLICIT_YES_VALUE = 7;
    private static final int EXPLICIT_NO_VALUE = 0;
    private static final int UNKNOWN_CONSENT_STATUS_VALUE = 1;

    DTBGDPREncoder() {
    }

    static String getEncodedNonIABConsentString(List<Integer> vendorList) {
        String binaryString = DTBGDPREncoder.getEncodedBinaryString(vendorList);
        int length = binaryString.length();
        boolean bitsFit = length % 8 == 0;
        byte[] bits = new byte[length / 8 + (bitsFit ? 0 : 1)];
        for (int i = 0; i < length; ++i) {
            if (binaryString.charAt(i) == '1') {
                DTBGDPREncoder.setBit(bits, i);
                continue;
            }
            DTBGDPREncoder.unsetBit(bits, i);
        }
        return Base64.encodeToString((byte[])bits, (int)11).trim();
    }

    static void setBit(byte[] bytes, int index) {
        int byteIndex = index / 8;
        int shift = (byteIndex + 1) * 8 - index - 1;
        int n = byteIndex;
        bytes[n] = (byte)(bytes[n] | 1 << shift);
    }

    static void unsetBit(byte[] bytes, int index) {
        int byteIndex = index / 8;
        int shift = (byteIndex + 1) * 8 - index - 1;
        int n = byteIndex;
        bytes[n] = (byte)(bytes[n] & ~(1 << shift));
    }

    static String getEncodedBinaryString(List<Integer> vendorList) {
        String binaryVendorListString = DTBGDPREncoder.getBinaryStringBasedOnPositions(vendorList);
        StringBuilder bitVector = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            bitVector.append("0");
        }
        DTBGDPREncoder.setBitSetBasedOnConsentStringVersion(bitVector);
        DTBGDPREncoder.setBitSetBasedOnCMPFlavor(bitVector);
        DTBGDPREncoder.setBitSetBasedOnConsentStatus(bitVector);
        if (binaryVendorListString.length() >= 1) {
            DTBGDPREncoder.setBitSetBasedOnMaxVendorID(bitVector, binaryVendorListString.length() - 1);
        }
        bitVector.append(binaryVendorListString);
        return bitVector.toString();
    }

    static void setBitSetBasedOnConsentStringVersion(StringBuilder bitVector) {
        int start = 6;
        int end = 11;
        bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(1, 5));
    }

    static void setBitSetBasedOnCMPFlavor(StringBuilder bitVector) {
        AdRegistration.CMPFlavor flavor = AdRegistration.getCMPFlavor();
        int start = 11;
        int end = 15;
        if (flavor == AdRegistration.CMPFlavor.GOOGLE_CMP || flavor == AdRegistration.CMPFlavor.ADMOB_CMP) {
            bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(1, 4));
        } else if (flavor == AdRegistration.CMPFlavor.MOPUB_CMP) {
            bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(2, 4));
        }
    }

    static void setBitSetBasedOnConsentStatus(StringBuilder bitVector) {
        AdRegistration.ConsentStatus status = AdRegistration.getConsentStatus();
        int start = 15;
        int end = 18;
        if (status == AdRegistration.ConsentStatus.EXPLICIT_YES) {
            bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(7, 3));
        } else if (status == AdRegistration.ConsentStatus.EXPLICIT_NO) {
            bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(0, 3));
        } else {
            bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(1, 3));
        }
    }

    static void setBitSetBasedOnMaxVendorID(StringBuilder bitVector, int maxValue) {
        int start = 18;
        int end = 32;
        bitVector.replace(start, end, DTBGDPREncoder.getValidPaddedStringForInt(maxValue, 14));
    }

    static String getBinaryStringBasedOnPositions(List<Integer> pos) {
        if (!pos.isEmpty()) {
            int maxVendorValue = Collections.max(pos) + 1;
            StringBuilder vendorBinaryString = new StringBuilder();
            for (int i = 0; i < maxVendorValue; ++i) {
                vendorBinaryString.append("0");
            }
            for (Integer index : pos) {
                vendorBinaryString.setCharAt(index, '1');
            }
            return vendorBinaryString.toString();
        }
        return "";
    }

    static String getValidPaddedStringForInt(int num, int totalLength) {
        String binaryString = Integer.toBinaryString(num);
        int remaining = totalLength - binaryString.length();
        String padding = "";
        for (int i = 0; i < remaining; ++i) {
            padding = padding + "0";
        }
        return padding + binaryString;
    }
}

