/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdContainer;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBCacheData;
import com.amazon.device.ads.DTBMetricReport;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DTBMetricsProcessor;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.SDKUtilities;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class DTBAdUtil {
    static final String LOG_TAG = DTBAdUtil.class.getSimpleName();
    private static final String CUSTOM_EVENT = "amazon_custom_event";
    public static final DTBAdUtil INSTANCE = new DTBAdUtil();

    private DTBAdUtil() {
    }

    public AdManagerAdRequest loadDTBParams(AdManagerAdRequest adRequest, DTBAdResponse dtbAdResponse) {
        if (dtbAdResponse.getAdCount() == 0) {
            return adRequest;
        }
        AdManagerAdRequest.Builder adRequestBuilder = new AdManagerAdRequest.Builder();
        adRequestBuilder.setContentUrl(adRequest.getContentUrl());
        adRequestBuilder.setLocation(adRequest.getLocation());
        adRequestBuilder.setPublisherProvidedId(adRequest.getPublisherProvidedId());
        this.loadDTBParameters(dtbAdResponse, adRequestBuilder);
        return adRequestBuilder.build();
    }

    public void loadDTBParams(AdManagerAdRequest.Builder adRequestBuilder, DTBAdResponse dtbAdResponse) {
        if (dtbAdResponse.getAdCount() > 0) {
            this.loadDTBParameters(dtbAdResponse, adRequestBuilder);
        }
    }

    public AdManagerAdRequest.Builder createAdManagerAdRequestBuilder(DTBAdResponse dtbAdResponse) {
        AdManagerAdRequest.Builder builder = new AdManagerAdRequest.Builder();
        if (dtbAdResponse.getAdCount() > 0) {
            this.loadDTBParameters(dtbAdResponse, builder);
        }
        return builder;
    }

    private void loadDTBParameters(DTBAdResponse dtbAdResponse, AdManagerAdRequest.Builder adRequestBuilder) {
        Map<String, List<String>> custParams = dtbAdResponse.isVideo() ? dtbAdResponse.getVideoAdsRequestCustomParamsAsList() : dtbAdResponse.getDefaultDisplayAdsRequestCustomParams();
        for (Map.Entry<String, List<String>> entry : custParams.entrySet()) {
            adRequestBuilder.addCustomTargeting(entry.getKey(), entry.getValue());
        }
    }

    public static List<View> findViewsOfType(ViewGroup parent, Class clazz) {
        ArrayList<View> list = new ArrayList<View>();
        DTBAdUtil.findViewsOfType(parent, clazz, list);
        return list;
    }

    public static View findAncestorOfType(View view, Class clazz) {
        View v = view;
        while (true) {
            if (clazz.isInstance(v)) {
                return v;
            }
            ViewParent obj = v.getParent();
            if (obj == null || !(obj instanceof View)) break;
            v = (View)obj;
        }
        return null;
    }

    static void findViewsOfType(ViewGroup parent, Class clazz, List<View> list) {
        int count = parent.getChildCount();
        for (int k = 0; k < count; ++k) {
            View child = parent.getChildAt(k);
            if (clazz.isInstance(child)) {
                list.add(child);
            }
            if (!(child instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)child;
            DTBAdUtil.findViewsOfType(viewGroup, clazz, list);
        }
    }

    public static String buildMopubTargeting(String dtbTargeting, Map<String, String> additionalTargeting) {
        StringBuilder finalTargeting = new StringBuilder(dtbTargeting);
        if (additionalTargeting != null) {
            for (Map.Entry<String, String> entry : additionalTargeting.entrySet()) {
                finalTargeting.append(",").append(entry.getKey()).append(':').append(entry.getValue());
            }
        }
        DtbLog.debug(LOG_TAG, "Targeting String:" + finalTargeting.toString());
        return finalTargeting.toString();
    }

    static boolean isInstalledFromAppStore(Context context) {
        String installer = context.getPackageManager().getInstallerPackageName(context.getPackageName());
        return installer != null && installer.length() > 0;
    }

    public static Activity getActivity(View v) {
        Context context = v.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static int sizeToDevicePixels(int size) {
        float scale = AdRegistration.getContext().getResources().getDisplayMetrics().density;
        return (int)((float)size * scale + 0.5f);
    }

    static int sizeToDevicePixels(Context context, int size) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)size * scale + 0.5f);
    }

    public static int pixelsToDeviceIndependenPixels(int size) {
        float scale = AdRegistration.getContext().getResources().getDisplayMetrics().density;
        return (int)((float)size / scale + 0.5f);
    }

    public static ViewGroup getRootView(View view) {
        Activity act = DTBAdUtil.getActivity(view);
        if (act == null) {
            return null;
        }
        return (ViewGroup)act.findViewById(0x1020002);
    }

    static SDKUtilities.SimpleSize getMaxSize(View view) {
        ViewGroup rootView = DTBAdUtil.getRootView(view);
        if (rootView == null) {
            return DTBAdUtil.getScreenSize();
        }
        int width = DTBAdUtil.pixelsToDeviceIndependenPixels(rootView.getWidth());
        int height = DTBAdUtil.pixelsToDeviceIndependenPixels(rootView.getHeight());
        return new SDKUtilities.SimpleSize(width, height);
    }

    public static SDKUtilities.SimpleSize getScreenSize() {
        return DTBAdUtil.getScreenSize(null);
    }

    public static SDKUtilities.SimpleSize getScreenSize(View view) {
        int screenHeight;
        int screenWidth;
        int orientation = AdRegistration.getContext().getResources().getConfiguration().orientation;
        Activity activity = null;
        if (view != null) {
            activity = DTBAdUtil.getActivity(view);
        }
        if (activity != null) {
            Point size = new Point();
            activity.getWindowManager().getDefaultDisplay().getRealSize(size);
            screenWidth = size.x;
            screenHeight = size.y;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)AdRegistration.getContext().getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            screenWidth = displayMetrics.widthPixels;
            screenHeight = displayMetrics.heightPixels;
        }
        int width = DTBAdUtil.pixelsToDeviceIndependenPixels(screenWidth);
        int height = DTBAdUtil.pixelsToDeviceIndependenPixels(screenHeight);
        if (orientation == 1) {
            return new SDKUtilities.SimpleSize(width, height);
        }
        return new SDKUtilities.SimpleSize(height, width);
    }

    public static void setRectShape(View v) {
        DTBAdUtil.setRectShape(v, -16711936, 3.0f);
    }

    public static void setRectShape(View v, int color, float strokeWidth) {
        ShapeDrawable sd = new ShapeDrawable();
        sd.setShape((Shape)new RectShape());
        sd.getPaint().setColor(color);
        sd.getPaint().setStrokeWidth(strokeWidth);
        sd.getPaint().setStyle(Paint.Style.STROKE);
        v.setBackground((Drawable)sd);
    }

    public static Bundle getBidFromFetchManager(Bundle extraData) {
        if (extraData == null) {
            return null;
        }
        DtbLog.debug("RELOAD CUSTOM EVENT", "NO QUEUE");
        return extraData;
    }

    public static boolean validateAdMobCustomEvent(String serverParameter, Bundle customEventExtras) {
        DtbLog.debug(CUSTOM_EVENT, "AdMob Server Price Point is checked in:" + serverParameter + "in AdMob Single Price Custom Event Class");
        return DTBAdUtil.validateAdMobCustomEvent(serverParameter, customEventExtras, false);
    }

    public static boolean validateSinglePriceAdMobCustomEvent(String serverParameter, Bundle customEventExtras) {
        DtbLog.debug(CUSTOM_EVENT, "AdMob Server Price Point is checked in:" + serverParameter + "in AdMob Custom Event Class");
        return DTBAdUtil.validateAdMobCustomEvent(serverParameter, customEventExtras, true);
    }

    private static boolean validateAdMobCustomEvent(String serverParameter, Bundle customEventExtras, boolean enableEncodedPriceMechanism) {
        String LOG_PREFIX = enableEncodedPriceMechanism ? "Amazon Single Price Custom Event" : "Amazon Custom Event";
        if (customEventExtras != null) {
            String expectedServerParameter = customEventExtras.getString("event_server_parameter", "Unknown");
            String bidHtml = customEventExtras.getString("bid_html_template", null);
            if (expectedServerParameter != null && serverParameter != null && bidHtml != null) {
                boolean pricePointCheck = enableEncodedPriceMechanism ? DTBAdUtil.compareEncodedPrice(expectedServerParameter, serverParameter) : serverParameter.equals(expectedServerParameter);
                if (pricePointCheck) {
                    String bidID = customEventExtras.getString("bid_identifier", null);
                    String hostname = customEventExtras.getString("hostname_identifier", null);
                    long start = customEventExtras.getLong("start_load_time");
                    if (start > 0L) {
                        int millis = (int)(new Date().getTime() - start);
                        DTBMetricsProcessor.getInstance().submitLatencyReportBidId(DTBMetricReport.addBid(bidID, hostname), DTBMetricsProcessor.REPORT_MEDIATION_LATENCY, millis);
                    }
                    DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " Completed/Accepted");
                    return true;
                }
                DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " ignored (server " + serverParameter + " is not matched with expected parameter " + expectedServerParameter + ")");
            }
            if (expectedServerParameter == null) {
                DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " ignored (expected server parameter is null");
            }
            if (serverParameter == null) {
                DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " ignored (server parameter is null");
            }
            if (bidHtml == null) {
                DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " ignored (payload is not defined)");
            }
        }
        DtbLog.debug(CUSTOM_EVENT, LOG_PREFIX + " Completed/Ignored ");
        return false;
    }

    static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static ViewGroup getAdViewWrapper(View adView, int width, int height, int expectedWidth, int expectedHeight) {
        AdContainer wrapper = new AdContainer(adView.getContext());
        if (expectedHeight != 0 && expectedWidth != 0) {
            wrapper.addView(adView, DTBAdUtil.sizeToDevicePixels(expectedWidth), DTBAdUtil.sizeToDevicePixels(expectedHeight));
        } else {
            wrapper.addView(adView, DTBAdUtil.sizeToDevicePixels(width), DTBAdUtil.sizeToDevicePixels(height));
        }
        wrapper.setAdView(adView);
        return wrapper;
    }

    static void directAppStoreLinkToBrowser(DTBAdMRAIDController dtbAdMRAIDController, Uri uri) throws ActivityNotFoundException, NullPointerException {
        String redirectUrl;
        if ("amzn".equals(uri.getScheme())) {
            DtbLog.debug(LOG_TAG, "Amazon app store unavailable in the device");
            redirectUrl = "https://www.amazon.com/gp/mas/dl/android?" + uri.getQuery();
        } else {
            DtbLog.debug(LOG_TAG, "App store unavailable in the device");
            redirectUrl = "https://play.google.com/store/apps/" + uri.getHost() + "?" + uri.getQuery();
        }
        Uri modUri = Uri.parse((String)redirectUrl);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(modUri);
        AdRegistration.getCurrentActivity().startActivity(intent);
        dtbAdMRAIDController.onAdLeftApplication();
    }

    static synchronized String loadFile(String fileName, String directory) throws IOException {
        String str;
        Context context = AdRegistration.getContext();
        if (context == null) {
            return null;
        }
        File fileDir = context.getFilesDir();
        File f = new File(fileDir.getAbsolutePath() + "/" + directory + "/" + fileName);
        if (!f.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            str = str.trim();
            sb.append(str).append("\n");
        }
        reader.close();
        ((InputStream)is).close();
        return sb.toString();
    }

    static void createDirIfDoesNotExist(String directory) {
        Context context = AdRegistration.getContext();
        if (context != null) {
            File fileDir = context.getFilesDir();
            File dir = new File(fileDir.getAbsolutePath() + "/" + directory);
            if (dir.isDirectory()) {
                return;
            }
            if (dir.exists()) {
                return;
            }
            dir.mkdir();
        }
    }

    static String loadFromAssets(String file) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (AdRegistration.getContext() != null && AdRegistration.getContext().getAssets() != null) {
            String str;
            InputStream is = AdRegistration.getContext().getAssets().open(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((str = reader.readLine()) != null) {
                str = str.trim();
                sb.append(str).append("\n");
            }
            reader.close();
            is.close();
        }
        return sb.toString();
    }

    static JSONObject loadJsonFromAsset(String file) {
        JSONObject jsonObject = null;
        try {
            String jsonVal = DTBAdUtil.loadFromAssets(file);
            jsonObject = new JSONObject(jsonVal);
            return jsonObject;
        }
        catch (IOException e) {
            DtbLog.debug("Fail to load " + file + "from asset folder");
        }
        catch (JSONException e) {
            DtbLog.debug("Fail to parse " + file + " to JSON from asset folder");
        }
        return jsonObject;
    }

    public static String generateRequestId() {
        String requestId = UUID.randomUUID().toString() + "-" + new Date().getTime();
        DTBCacheData dtbCacheData = AdRegistration.getAdMobCache(requestId);
        if (dtbCacheData != null) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "Generate a conflict request id which already in request id map");
            AdRegistration.removeAdMobCache(requestId);
        }
        return requestId;
    }

    static boolean compareEncodedPrice(String expectedServerParameter, String serverParameter) {
        if (DtbCommonUtils.isNullOrEmpty(expectedServerParameter) || DtbCommonUtils.isNullOrEmpty(serverParameter)) {
            return false;
        }
        if (expectedServerParameter.length() < 8 || serverParameter.length() < 8 || !expectedServerParameter.contains("_spp") || !serverParameter.contains("_spp")) {
            return expectedServerParameter.compareTo(serverParameter) == 0;
        }
        expectedServerParameter = expectedServerParameter.replace("_spp", "");
        serverParameter = serverParameter.replace("_spp", "");
        String reverseExpectedServerParameter = new StringBuilder(expectedServerParameter).reverse().toString();
        String reverseServerParameter = new StringBuilder(serverParameter).reverse().toString();
        String sppFlag = DTBMetricsConfiguration.getClientConfigVal("leq", "spp_flag");
        if (!DtbCommonUtils.isNullOrEmpty(sppFlag)) {
            if ("eq".equals(sppFlag)) {
                return reverseServerParameter.compareTo(reverseExpectedServerParameter) == 0;
            }
            if ("geq".equals(sppFlag)) {
                return reverseServerParameter.compareTo(reverseExpectedServerParameter) >= 0;
            }
        }
        return reverseServerParameter.compareTo(reverseExpectedServerParameter) <= 0;
    }

    public static Bundle createAdMobBannerRequestBundle(String slotUUID, int width, int height) {
        return DTBAdUtil.createAdMobBannerRequestBundle(slotUUID, width, height, null);
    }

    public static Bundle createAdMobBannerRequestBundle(String slotUUID, int width, int height, Map<String, String> extras) {
        Bundle bundle = DTBAdUtil.createBundleWithExtras(extras);
        try {
            bundle.putString("amazon_custom_event_slot_uuid", slotUUID);
            bundle.putInt("amazon_custom_event_width", width);
            bundle.putInt("amazon_custom_event_height", height);
            bundle.putString("amazon_custom_event_request_id", DTBAdUtil.generateRequestId());
            bundle.putString("amazon_custom_event_adapter_version", "2.0");
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute createAdMobBannerRequestBundle method to create bundle for non smart banner ads", e);
        }
        return bundle;
    }

    public static Bundle createAdMobBannerRequestBundle(String slotGroup) {
        return DTBAdUtil.createAdMobBannerRequestBundle(slotGroup, null);
    }

    public static Bundle createAdMobBannerRequestBundle(String slotGroup, Map<String, String> extras) {
        Bundle bundle = DTBAdUtil.createBundleWithExtras(extras);
        try {
            bundle.putString("amazon_custom_event_slot_group", slotGroup);
            bundle.putString("amazon_custom_event_request_id", DTBAdUtil.generateRequestId());
            bundle.putString("amazon_custom_event_adapter_version", "2.0");
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute createAdMobBannerRequestBundle method to create bundle for smart banner ads", e);
        }
        return bundle;
    }

    public static Bundle createAdMobInterstitialRequestBundle(String slotUUID) {
        return DTBAdUtil.createAdMobInterstitialRequestBundle(slotUUID, false, null);
    }

    public static Bundle createAdMobInterstitialVideoRequestBundle(String slotUUID) {
        return DTBAdUtil.createAdMobInterstitialRequestBundle(slotUUID, true, null);
    }

    public static Bundle createAdMobInterstitialRequestBundle(String slotUUID, Map<String, String> extras) {
        return DTBAdUtil.createAdMobInterstitialRequestBundle(slotUUID, false, extras);
    }

    public static Bundle createAdMobInterstitialVideoRequestBundle(String slotUUID, Map<String, String> extras) {
        return DTBAdUtil.createAdMobInterstitialRequestBundle(slotUUID, true, extras);
    }

    private static Bundle createAdMobInterstitialRequestBundle(String slotUUID, boolean isVideo, Map<String, String> extras) {
        Bundle bundle = DTBAdUtil.createBundleWithExtras(extras);
        try {
            bundle.putString("amazon_custom_event_slot_uuid", slotUUID);
            bundle.putString("amazon_custom_event_request_id", DTBAdUtil.generateRequestId());
            bundle.putString("amazon_custom_event_adapter_version", "2.0");
            bundle.putBoolean("amazon_custom_event_is_video", isVideo);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute createAdMobInterstitialRequestBundle method", e);
        }
        return bundle;
    }

    private static Bundle createBundleWithExtras(Map<String, String> extras) {
        Bundle bundle = DtbCommonUtils.initializeEmptyBundle();
        try {
            if (!DtbCommonUtils.isNullOrEmpty(extras)) {
                if (extras.containsKey("aps_privacy") && !DtbCommonUtils.isNullOrEmpty(extras.get("aps_privacy"))) {
                    bundle.putString("aps_privacy", extras.get("aps_privacy"));
                }
                if (extras.containsKey("us_privacy") && !DtbCommonUtils.isNullOrEmpty(extras.get("us_privacy"))) {
                    bundle.putString("us_privacy", extras.get("us_privacy"));
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to add CCPA consent to AdMob mediation bundle", e);
        }
        return bundle;
    }
}

