/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.util.Log;
import com.amazon.aps.ads.model.ApsLogLevel;

public class ApsLog {
    private static String DEFAULT_TAG = "APSAndroidShared";
    static boolean isLoggable;
    private static ApsLogLevel logLevel;

    private ApsLog() {
    }

    static void initIsLoggable() {
        try {
            isLoggable = Log.isLoggable((String)"test", (int)7);
        }
        catch (Throwable t) {
            isLoggable = false;
        }
    }

    static boolean isOkToLog(ApsLogLevel levelFrom) {
        return isLoggable && logLevel.intValue() <= levelFrom.intValue() && logLevel != ApsLogLevel.Off;
    }

    public static ApsLogLevel getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(ApsLogLevel logLevel) {
        ApsLog.logLevel = logLevel;
    }

    public static void d(String tag, String message) {
        if (ApsLog.isOkToLog(ApsLogLevel.Debug)) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void d(String message) {
        ApsLog.d(DEFAULT_TAG, message);
    }

    public static void i(String tag, String message) {
        if (logLevel.intValue() >= ApsLogLevel.Warn.intValue()) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void i(String message) {
        ApsLog.i(DEFAULT_TAG, message);
    }

    public static void e(String tag, String message) {
        if (logLevel.intValue() != ApsLogLevel.Off.intValue()) {
            Log.e((String)tag, (String)message);
        }
    }

    public static void e(String message) {
        ApsLog.e(DEFAULT_TAG, message);
    }

    static {
        logLevel = ApsLogLevel.Warn;
        ApsLog.initIsLoggable();
    }
}

