/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import androidx.annotation.NonNull;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DtbDeviceDataRetriever;

public class ApsAdFormatUtils {
    static final int BANNER_HEIGHT = 50;
    static final int BANNER_WIDTH = 320;
    static final int MREC_HEIGHT = 250;
    static final int MREC_WIDTH = 300;
    static final int TABLET_BANNER_HEIGHT = 90;
    static final int TABLET_BANNER_WIDTH = 728;
    static final int DEFAULT_VIDEO_REQ_WIDTH = 320;
    static final int DEFAULT_VIDEO_REQ_HEIGHT = 480;
    static final int INTERSTITIAL_WIDTH_BY_AAX = 9999;
    static final int INTERSTITIAL_HEIGHT_BY_AAX = 9999;

    private ApsAdFormatUtils() {
    }

    public static int getHeight(@NonNull ApsAdFormat apsAdFormat) {
        ApsAdFormat format = apsAdFormat;
        if (format == ApsAdFormat.BANNER_SMART) {
            format = DtbDeviceDataRetriever.isTablet() ? ApsAdFormat.LEADERBOARD : ApsAdFormat.BANNER;
        }
        switch (format) {
            case BANNER: {
                return 50;
            }
            case MREC: {
                return 250;
            }
            case LEADERBOARD: {
                return 90;
            }
            case REWARDED_VIDEO: {
                return 480;
            }
        }
        return 9999;
    }

    public static ApsAdFormat getAdFormat(AdType adType, int height, int width) {
        if (adType != null) {
            switch (adType) {
                case DISPLAY: {
                    if (height == 50 && width == 320) {
                        return ApsAdFormat.BANNER;
                    }
                    if (height == 250 && width == 300) {
                        return ApsAdFormat.MREC;
                    }
                    if (height != 90 || width != 728) break;
                    return ApsAdFormat.LEADERBOARD;
                }
                case INTERSTITIAL: 
                case VIDEO: {
                    return ApsAdFormat.INTERSTITIAL;
                }
            }
        }
        return null;
    }

    public static int getWidth(@NonNull ApsAdFormat apsAdFormat) {
        ApsAdFormat format = apsAdFormat;
        if (format == ApsAdFormat.BANNER_SMART) {
            format = DtbDeviceDataRetriever.isTablet() ? ApsAdFormat.LEADERBOARD : ApsAdFormat.BANNER;
        }
        switch (format) {
            case BANNER: {
                return 320;
            }
            case MREC: {
                return 300;
            }
            case LEADERBOARD: {
                return 728;
            }
            case REWARDED_VIDEO: {
                return 320;
            }
        }
        return 9999;
    }
}

