/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.module;

import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.attributes.persistence.impl.DynamoDbPersistenceAdapter;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.module.SdkModule;
import com.amazon.ask.module.SdkModuleContext;
import com.amazon.ask.services.ApacheHttpApiClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.function.Function;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class StandardSdkModule
implements SdkModule {
    protected ApacheHttpApiClient apiClient;
    protected DynamoDbPersistenceAdapter persistenceAdapter;

    public StandardSdkModule(ApacheHttpApiClient apiClient, DynamoDbPersistenceAdapter persistenceAdapter) {
        this.apiClient = apiClient;
        this.persistenceAdapter = persistenceAdapter;
    }

    public void setupModule(SdkModuleContext context) {
        context.setApiClient((ApiClient)this.apiClient);
        context.setPersistenceAdapter((PersistenceAdapter)this.persistenceAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        protected CloseableHttpClient customHttpClient;
        protected AmazonDynamoDB customDynamoDBClient;
        protected String tableName;
        protected Boolean autoCreateTable;
        protected Function<RequestEnvelope, String> partitionKeyGenerator;

        private Builder() {
        }

        public Builder withHttpClient(CloseableHttpClient customHttpClient) {
            this.customHttpClient = customHttpClient;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withAutoCreateTable(boolean autoCreateTable) {
            this.autoCreateTable = autoCreateTable;
            return this;
        }

        public Builder withPartitionKeyGenerator(Function<RequestEnvelope, String> partitionKeyGenerator) {
            this.partitionKeyGenerator = partitionKeyGenerator;
            return this;
        }

        public Builder withDynamoDbClient(AmazonDynamoDB customDynamoDBClient) {
            this.customDynamoDBClient = customDynamoDBClient;
            return this;
        }

        public StandardSdkModule build() {
            DynamoDbPersistenceAdapter persistenceAdapter = null;
            if (this.tableName != null) {
                DynamoDbPersistenceAdapter.Builder persistenceAdapterBuilder = DynamoDbPersistenceAdapter.builder().withTableName(this.tableName);
                if (this.autoCreateTable != null) {
                    persistenceAdapterBuilder.withAutoCreateTable(this.autoCreateTable.booleanValue());
                }
                if (this.partitionKeyGenerator != null) {
                    persistenceAdapterBuilder.withPartitionKeyGenerator(this.partitionKeyGenerator);
                }
                if (this.customDynamoDBClient != null) {
                    persistenceAdapterBuilder.withDynamoDbClient(this.customDynamoDBClient);
                }
                persistenceAdapter = persistenceAdapterBuilder.build();
            }
            ApacheHttpApiClient apiClient = ApacheHttpApiClient.custom().withHttpClient(this.customHttpClient != null ? this.customHttpClient : HttpClients.createDefault()).build();
            return new StandardSdkModule(apiClient, persistenceAdapter);
        }
    }
}

