/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.builder.impl;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.builder.impl.AbstractSkillConfiguration;
import com.amazon.ask.request.exception.handler.GenericExceptionHandler;
import com.amazon.ask.request.exception.mapper.GenericExceptionMapper;
import com.amazon.ask.request.exception.mapper.impl.BaseExceptionMapper;
import com.amazon.ask.request.handler.GenericRequestHandler;
import com.amazon.ask.request.handler.chain.impl.BaseRequestHandlerChain;
import com.amazon.ask.request.interceptor.GenericRequestInterceptor;
import com.amazon.ask.request.interceptor.GenericResponseInterceptor;
import com.amazon.ask.request.mapper.impl.BaseRequestMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractSkillBuilder<Input, Output, Self extends AbstractSkillBuilder<Input, Output, Self>> {
    protected final List<GenericRequestHandler<Input, Output>> requestHandlers = new ArrayList<GenericRequestHandler<Input, Output>>();
    protected final List<GenericExceptionHandler<Input, Output>> exceptionHandlers = new ArrayList<GenericExceptionHandler<Input, Output>>();
    protected final List<GenericRequestInterceptor<Input>> requestInterceptors = new ArrayList<GenericRequestInterceptor<Input>>();
    protected final List<GenericResponseInterceptor<Input, Output>> responseInterceptors = new ArrayList<GenericResponseInterceptor<Input, Output>>();

    public Self addRequestHandler(GenericRequestHandler<Input, Output> handler) {
        this.requestHandlers.add(handler);
        return this.getThis();
    }

    public Self addRequestHandlers(List<GenericRequestHandler<Input, Output>> handlers) {
        this.requestHandlers.addAll(handlers);
        return this.getThis();
    }

    public Self addRequestHandlers(GenericRequestHandler<Input, Output> ... handlers) {
        this.requestHandlers.addAll(Arrays.asList(handlers));
        return this.getThis();
    }

    public Self addRequestInterceptor(GenericRequestInterceptor<Input> interceptor) {
        this.requestInterceptors.add(interceptor);
        return this.getThis();
    }

    public Self addRequestInterceptors(List<GenericRequestInterceptor<Input>> interceptors) {
        this.requestInterceptors.addAll(interceptors);
        return this.getThis();
    }

    public Self addRequestInterceptors(GenericRequestInterceptor<Input> ... interceptors) {
        this.requestInterceptors.addAll(Arrays.asList(interceptors));
        return this.getThis();
    }

    public Self addResponseInterceptor(GenericResponseInterceptor<Input, Output> interceptor) {
        this.responseInterceptors.add(interceptor);
        return this.getThis();
    }

    public Self addResponseInterceptors(List<GenericResponseInterceptor<Input, Output>> interceptors) {
        this.responseInterceptors.addAll(interceptors);
        return this.getThis();
    }

    public Self addResponseInterceptors(GenericResponseInterceptor<Input, Output> ... interceptors) {
        this.responseInterceptors.addAll(Arrays.asList(interceptors));
        return this.getThis();
    }

    public Self addExceptionHandler(GenericExceptionHandler<Input, Output> handler) {
        this.exceptionHandlers.add(handler);
        return this.getThis();
    }

    public Self addExceptionHandlers(List<GenericExceptionHandler<Input, Output>> handlers) {
        this.exceptionHandlers.addAll(handlers);
        return this.getThis();
    }

    public Self addExceptionHandlers(GenericExceptionHandler<Input, Output> ... handler) {
        this.exceptionHandlers.addAll(Arrays.asList(handler));
        return this.getThis();
    }

    private Self getThis() {
        return (Self)this;
    }

    protected <T extends AbstractSkillConfiguration.Builder<Input, Output, T>> void populateConfig(T config) {
        if (!this.requestHandlers.isEmpty()) {
            List requestHandlerChains = this.requestHandlers.stream().map(handler -> ((BaseRequestHandlerChain.Builder)BaseRequestHandlerChain.builder().withRequestHandler(handler)).build()).collect(Collectors.toList());
            config.withRequestMappers(Collections.singletonList(((BaseRequestMapper.Builder)BaseRequestMapper.builder().withRequestHandlerChains(requestHandlerChains)).build()));
        }
        if (!this.exceptionHandlers.isEmpty()) {
            GenericExceptionMapper exceptionMapper = ((BaseExceptionMapper.Builder)BaseExceptionMapper.builder().withExceptionHandlers(this.exceptionHandlers)).build();
            config.withExceptionMapper(exceptionMapper);
        }
        config.withRequestInterceptors(this.requestInterceptors);
        config.withResponseInterceptors(this.responseInterceptors);
    }

    protected abstract AlexaSkill build();
}

