/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.template;

import com.amazon.ask.util.ValidationUtils;

public class TemplateContentData {
    protected final String identifier;
    protected final byte[] templateContent;
    protected final String templateBaseDir;

    public TemplateContentData(String identifier, byte[] templateContent, String templateBaseDir) {
        this.identifier = ValidationUtils.assertNotNull(identifier, "identifier");
        this.templateContent = ValidationUtils.assertNotNull(templateContent, "templateContent");
        this.templateBaseDir = ValidationUtils.assertNotNull(templateBaseDir, "templateBaseDir");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public byte[] getTemplateContent() {
        return this.templateContent;
    }

    public String getTemplateBaseDir() {
        return this.templateBaseDir;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateContentData {\n");
        sb.append("    templateContent: ").append(this.toIndentedString(new String(this.templateContent))).append("\n");
        sb.append("    templateBaseDir: ").append(this.toIndentedString(this.templateBaseDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String identifier;
        private byte[] templateContent;
        private String templateBaseDir;

        public Builder withIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withTemplateContent(byte[] templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public Builder withTemplateBaseDir(String templateBaseDir) {
            this.templateBaseDir = templateBaseDir;
            return this;
        }

        public TemplateContentData build() {
            return new TemplateContentData(this.identifier, this.templateContent, this.templateBaseDir);
        }
    }
}

