/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.AuthenticationConfiguration;

public class DefaultAuthenticationConfiguration
implements AuthenticationConfiguration {
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;

    protected DefaultAuthenticationConfiguration(String clientId, String clientSecret, String refreshToken) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String refreshToken;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public DefaultAuthenticationConfiguration build() {
            return new DefaultAuthenticationConfiguration(this.clientId, this.clientSecret, this.refreshToken);
        }
    }
}

