/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.request.SkillRequest;
import com.amazon.ask.request.impl.BaseSkillRequest;
import com.amazon.ask.response.SkillResponse;
import com.amazon.ask.util.ValidationUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class SkillStreamHandler
implements RequestStreamHandler {
    private final List<AlexaSkill> skills;

    public SkillStreamHandler(AlexaSkill skill) {
        this.skills = Collections.singletonList(ValidationUtils.assertNotNull((Object)skill, (String)"skill"));
    }

    public SkillStreamHandler(AlexaSkill ... skills) {
        this.skills = Arrays.asList(ValidationUtils.assertNotEmpty((Object[])skills, (String)"skills"));
    }

    public final void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        byte[] inputBytes = IOUtils.toByteArray((InputStream)input);
        for (AlexaSkill skill : this.skills) {
            SkillResponse response = skill.execute((SkillRequest)new BaseSkillRequest(inputBytes), (Object)context);
            if (response == null) continue;
            if (response.isPresent()) {
                response.writeTo(output);
            }
            return;
        }
        throw new AskSdkException("Could not find a skill to handle the incoming request");
    }
}

