/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import java.util.List;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.util.StringUtils;

public class GitFlowVersionInfo
extends DefaultVersionInfo {
    public GitFlowVersionInfo(String version) throws VersionParseException {
        super(version);
    }

    public GitFlowVersionInfo digitsVersionInfo() throws VersionParseException {
        return new GitFlowVersionInfo(GitFlowVersionInfo.joinDigitString((List)this.getDigits()));
    }

    public static boolean isValidVersion(String version) {
        return StringUtils.isNotBlank((String)version) && (ALTERNATE_PATTERN.matcher(version).matches() || STANDARD_PATTERN.matcher(version).matches());
    }

    public String nextSnapshotVersion() {
        return this.nextSnapshotVersion(null);
    }

    public String nextSnapshotVersion(Integer index) {
        List digits = this.getDigits();
        String nextVersion = null;
        if (digits != null) {
            if (index != null && index >= 0 && index < digits.size()) {
                int origDigitsLength = GitFlowVersionInfo.joinDigitString((List)digits).length();
                digits.set(index, this.incrementVersionString((String)digits.get(index)));
                for (int i = index + 1; i < digits.size(); ++i) {
                    digits.set(i, "0");
                }
                String digitsStr = GitFlowVersionInfo.joinDigitString((List)digits);
                nextVersion = digitsStr + this.getSnapshotVersionString().substring(origDigitsLength);
            } else {
                nextVersion = this.getNextVersion().getSnapshotVersionString();
            }
        } else {
            nextVersion = this.getSnapshotVersionString();
        }
        return nextVersion;
    }

    public String featureVersion(String featureName) {
        String version = this.toString();
        if (featureName != null) {
            version = this.getReleaseVersionString() + "-" + featureName + (this.isSnapshot() ? "-SNAPSHOT" : "");
        }
        return version;
    }

    public String hotfixVersion(boolean preserveSnapshot) {
        return preserveSnapshot && this.isSnapshot() ? this.getNextVersion().getSnapshotVersionString() : this.getNextVersion().getReleaseVersionString();
    }
}

