/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.amap.api.mapcore.util.dl;
import com.amap.api.mapcore.util.dm;
import com.amap.api.mapcore.util.dn;
import com.amap.api.mapcore.util.gd;
import com.amap.api.maps.MapsInitializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String TAG = "FileUtil";
    private static final int BUFFER = 1024;
    private static final String FILE_PATH_ENTRY_BACK = "..";
    private static final String FILE_PATH_ENTRY_SEPARATOR1 = "\\";
    private static final String FILE_PATH_ENTRY_SEPARATOR2 = "%";

    public static boolean deleteFile(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isFile()) {
                    if (fileArray[i2].delete()) continue;
                    return false;
                }
                if (!FileUtil.deleteFile(fileArray[i2])) {
                    return false;
                }
                fileArray[i2].delete();
            }
        }
        file.delete();
        return true;
    }

    public static String getMapBaseStorage(Context context) {
        Object object;
        String string2;
        if (context == null) {
            return null;
        }
        int n2 = Build.VERSION.SDK_INT;
        String string3 = "map_base_path";
        if (n2 > 18) {
            string3 = "map_base_path_v44";
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("base_path", 0);
        if (MapsInitializer.sdcardDir != null && MapsInitializer.sdcardDir.trim().length() > 0) {
            string2 = MapsInitializer.sdcardDir + File.separatorChar;
        } else {
            string2 = sharedPreferences.getString(string3, "");
            object = FileUtil.getExternalStroragePath(context);
            if (string2 != null && !string2.contains((CharSequence)object)) {
                string2 = null;
            }
        }
        if (string2 != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory()) {
                if (FileUtil.checkCanWrite((File)object)) {
                    return string2;
                }
                string2 = context.getCacheDir().toString() + "/amap/";
                if (string2 != null && string2.length() > 2) {
                    object = new File(string2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdir();
                    }
                    if (((File)object).isDirectory()) {
                        return string2;
                    }
                }
            }
        }
        if ((string2 = FileUtil.getExternalStroragePath(context) + "/amap/") != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory() && ((File)object).canWrite()) {
                context = sharedPreferences.edit();
                context.putString(string3, string2);
                context.commit();
                FileUtil.createNoMediaFileIfNotExist(string2);
                return string2;
            }
        }
        if ((string2 = context.getCacheDir().toString() + "/amap/") != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory()) {
                return string2;
            }
        }
        return string2;
    }

    public static boolean checkCanWrite(File file) {
        if (file == null) {
            return false;
        }
        if (!file.canWrite()) {
            return false;
        }
        file = new File(file, "amap.tmp");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getExternalStroragePath(Context context) {
        if (context != null) {
            return context.getExternalFilesDir("").getAbsolutePath() + File.separatorChar;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDatasToFile(String object, byte[] byArray) {
        FileOutputStream fileOutputStream;
        ReentrantReadWriteLock.WriteLock writeLock;
        block8: {
            block7: {
                writeLock = new ReentrantReadWriteLock().writeLock();
                writeLock.lock();
                fileOutputStream = null;
                try {
                    try {
                        block10: {
                            block9: {
                                if (byArray == null) break block9;
                                if (byArray.length != 0) break block10;
                            }
                            object = null;
                            writeLock.unlock();
                            break block7;
                        }
                        if (((File)(object = new File((String)object))).exists()) {
                            ((File)object).delete();
                        }
                        ((File)object).createNewFile();
                        fileOutputStream = new FileOutputStream((File)object);
                        ((OutputStream)fileOutputStream).write(byArray);
                        fileOutputStream.flush();
                        break block8;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        object = null;
                        writeLock.unlock();
                        FileUtil.safelyCloseFile(fileOutputStream);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    object = null;
                    writeLock.unlock();
                    FileUtil.safelyCloseFile(fileOutputStream);
                    throw throwable;
                }
            }
            FileUtil.safelyCloseFile(fileOutputStream);
            return;
        }
        object = null;
        writeLock.unlock();
        FileUtil.safelyCloseFile(fileOutputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readFileContents(String object) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream fileInputStream;
        block6: {
            fileInputStream = null;
            byteArrayOutputStream = null;
            object = new File((String)object);
            if (((File)object).exists()) break block6;
            object = null;
            FileUtil.safelyCloseFile(byteArrayOutputStream);
            FileUtil.safelyCloseFile(fileInputStream);
            return null;
        }
        try {
            int n2;
            fileInputStream = new FileInputStream((File)object);
            object = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = fileInputStream.read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            object = null;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                gd.c(throwable, TAG, "readFileContents");
                dl.a((Throwable)object);
                dn.b(dm.f, "read file from disk failed " + ((Throwable)object).getMessage());
                object = null;
            }
            catch (Throwable throwable2) {
                object = null;
                FileUtil.safelyCloseFile(byteArrayOutputStream);
                FileUtil.safelyCloseFile(fileInputStream);
                throw throwable2;
            }
            FileUtil.safelyCloseFile(byteArrayOutputStream);
            FileUtil.safelyCloseFile(fileInputStream);
            return null;
        }
        FileUtil.safelyCloseFile(byteArrayOutputStream);
        FileUtil.safelyCloseFile(fileInputStream);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveFileContents(String object, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                object = new File((String)object);
                fileOutputStream = new FileOutputStream((File)object);
                fileOutputStream.write(byArray);
            }
            catch (Throwable throwable) {
                object = throwable;
                gd.c(throwable, TAG, "saveFileContents");
                dl.a((Throwable)object);
                dn.b(dm.f, "save file from disk failed " + ((Throwable)object).getMessage());
                object = null;
                FileUtil.safelyCloseFile(fileOutputStream);
                return;
            }
            object = null;
        }
        catch (Throwable throwable) {
            object = null;
            FileUtil.safelyCloseFile(fileOutputStream);
            throw throwable;
        }
        FileUtil.safelyCloseFile(fileOutputStream);
    }

    public static void createNoMediaFileIfNotExist(String string2) {
    }

    public static byte[] readFileContentsFromAssetsByPreName(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null) {
            return null;
        }
        String[] stringArray = context.getAssets();
        try {
            stringArray = stringArray.list(string2);
            if (stringArray == null) {
                return null;
            }
            for (String string4 : stringArray) {
                if (string4 == null || !string4.contains(string3)) continue;
                return FileUtil.readFileContentsFromAssets(context, string2 + "/" + string4);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFileContentsFromAssets(Context context, String object) {
        byte[] byArray;
        InputStream inputStream;
        block9: {
            block8: {
                context = context.getAssets();
                inputStream = null;
                try {
                    try {
                        byte[] byArray2;
                        inputStream = context.open((String)byArray2);
                        int n2 = inputStream.available();
                        if (n2 == 0) {
                            Object var0_2 = null;
                            break block8;
                        }
                        byArray2 = new byte[n2];
                        for (int i2 = 0; i2 < n2; i2 += inputStream.read(byArray2, i2, n2 - i2)) {
                        }
                        byArray = byArray2;
                        break block9;
                    }
                    catch (IOException iOException) {
                        dn.b(dm.f, "read file from assets failed " + iOException.getMessage());
                        context = null;
                        FileUtil.safelyCloseFile(inputStream);
                        return null;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        dn.b(dm.f, "read file from assets failed " + outOfMemoryError.getMessage());
                        context = null;
                        FileUtil.safelyCloseFile(inputStream);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    context = null;
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable;
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return null;
        }
        Object var0_3 = null;
        FileUtil.safelyCloseFile(inputStream);
        return byArray;
    }

    public static String getName(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FileUtil.indexOfLastSeparator(string2);
        return string2.substring(n2 + 1);
    }

    public static int indexOfLastSeparator(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.lastIndexOf(47);
        int n3 = string2.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static boolean isSafeEntryName(String string2) {
        return !string2.contains(FILE_PATH_ENTRY_BACK) && !string2.contains(FILE_PATH_ENTRY_SEPARATOR1) && !string2.contains(FILE_PATH_ENTRY_SEPARATOR2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(String string2, String string3) {
        if (string2 == null) return null;
        if (string2.length() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            try {
                gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(string2.getBytes(string3));
                gZIPOutputStream.close();
            }
            catch (IOException iOException) {
                Log.e((String)"gzip compress error.", (String)iOException.getMessage());
                Object var0_2 = null;
                FileUtil.safelyCloseFile(gZIPOutputStream);
                return byteArrayOutputStream.toByteArray();
            }
            string2 = null;
        }
        catch (Throwable throwable) {
            string2 = null;
            FileUtil.safelyCloseFile(gZIPOutputStream);
            throw throwable;
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] byArray) {
        if (byArray == null) return null;
        if (byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            try {
                gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.close();
            }
            catch (IOException iOException) {
                Log.e((String)"gzip compress error.", (String)iOException.getMessage());
                Object var0_2 = null;
                FileUtil.safelyCloseFile(gZIPOutputStream);
                return byteArrayOutputStream.toByteArray();
            }
            byArray = null;
        }
        catch (Throwable throwable) {
            byArray = null;
            FileUtil.safelyCloseFile(gZIPOutputStream);
            throw throwable;
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String uncompressToString(byte[] byArray) {
        return FileUtil.uncompressToString(byArray, "UTF-8");
    }

    public static String uncompressToString(byte[] byArray, String string2) {
        InputStream inputStream;
        block6: {
            String string3;
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = null;
            try {
                int n2;
                inputStream = FileUtil.getZipInputStream(byArray);
                if (inputStream == null) break block6;
                byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                string3 = byteArrayOutputStream.toString(string2);
                byArray = null;
            }
            catch (IOException iOException) {
                try {
                    Log.e((String)"gzip compress error.", (String)iOException.getMessage());
                    Object var0_2 = null;
                }
                catch (Throwable throwable) {
                    byArray = null;
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable;
                }
                FileUtil.safelyCloseFile(inputStream);
                {
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return string3;
        }
        byArray = null;
        FileUtil.safelyCloseFile(inputStream);
        return null;
    }

    private static InputStream getZipInputStream(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (FileUtil.isGzip(byArray)) {
            return new GZIPInputStream(byteArrayInputStream);
        }
        return new ZipInputStream(byteArrayInputStream);
    }

    private static void safelyCloseFile(InputStream inputStream) {
        try {
            if (inputStream != null) {
                if (inputStream instanceof ZipInputStream) {
                    ((ZipInputStream)inputStream).closeEntry();
                }
                inputStream.close();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static void safelyCloseFile(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static byte[] readByteByStream(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            return null;
        }
        byte[] byArray2 = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            while ((n2 = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            inputStream = null;
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                inputStream = null;
                FileUtil.safelyCloseFile(byteArrayOutputStream);
                throw throwable;
            }
        }
        FileUtil.safelyCloseFile(byteArrayOutputStream);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> uncompressToByteWithKeys(byte[] object, String[] stringArray) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (object == null) return hashMap;
        if (((Object)object).length == 0) {
            return hashMap;
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = FileUtil.getZipInputStream((byte[])object);
                if (inputStream instanceof ZipInputStream) {
                    Object object2;
                    object = (ZipInputStream)inputStream;
                    while ((object2 = ((ZipInputStream)object).getNextEntry()) != null) {
                        block16: {
                            if (!((ZipEntry)object2).isDirectory()) {
                                block15: {
                                    object2 = ((ZipEntry)object2).getName();
                                    if (FileUtil.isSafeEntryName((String)object2)) break block15;
                                    Log.e((String)"gzip compress error.", (String)"gzip name contains ../ ".concat(String.valueOf(object2)));
                                    object = null;
                                    FileUtil.safelyCloseFile(inputStream);
                                    return null;
                                }
                                try {
                                    Object[] objectArray;
                                    if (stringArray == null) {
                                        byte[] byArray = FileUtil.readByteByStream((InputStream)object);
                                        objectArray = byArray;
                                        if (byArray != null) {
                                            hashMap.put((String)object2, (byte[])objectArray);
                                        }
                                        break block16;
                                    }
                                    objectArray = stringArray;
                                    int n2 = stringArray.length;
                                    for (int i2 = 0; i2 < n2; ++i2) {
                                        String string2 = objectArray[i2];
                                        if (!((String)object2).equals(string2)) continue;
                                        byte[] byArray = FileUtil.readByteByStream((InputStream)object);
                                        object2 = byArray;
                                        if (byArray != null) {
                                            hashMap.put(string2, (byte[])object2);
                                        }
                                        break;
                                    }
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        }
                        ((ZipInputStream)object).closeEntry();
                    }
                }
                object = null;
            }
            catch (Throwable throwable) {
                Log.e((String)"gzip compress error.", (String)throwable.getMessage());
                Object var0_2 = null;
                FileUtil.safelyCloseFile(inputStream);
                return hashMap;
            }
            FileUtil.safelyCloseFile(inputStream);
            return hashMap;
        }
        catch (Throwable throwable) {
            object = null;
            FileUtil.safelyCloseFile(inputStream);
            throw throwable;
        }
    }

    public static Pair<String, byte[]> uncompressToByte(byte[] byArray) {
        InputStream inputStream;
        block8: {
            Pair pair;
            String string2;
            ByteArrayOutputStream byteArrayOutputStream;
            block7: {
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                inputStream = null;
                string2 = "";
                inputStream = FileUtil.getZipInputStream(byArray);
                if (!(inputStream instanceof ZipInputStream) || FileUtil.isSafeEntryName(string2 = ((ZipInputStream)inputStream).getNextEntry().getName())) break block7;
                Log.e((String)"gzip compress error.", (String)"gzip name contains ../ ".concat(String.valueOf(string2)));
                byArray = null;
                FileUtil.safelyCloseFile(inputStream);
                return null;
            }
            try {
                int n2;
                if (inputStream == null) break block8;
                byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                pair = new Pair((Object)string2, (Object)byteArrayOutputStream.toByteArray());
                byArray = null;
            }
            catch (Throwable throwable) {
                try {
                    Log.e((String)"gzip compress error.", (String)throwable.getMessage());
                    Object var0_2 = null;
                }
                catch (Throwable throwable2) {
                    byArray = null;
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable2;
                }
                FileUtil.safelyCloseFile(inputStream);
                {
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return pair;
        }
        byArray = null;
        FileUtil.safelyCloseFile(inputStream);
        return null;
    }

    public static byte[] uncompress(byte[] byArray) {
        InputStream inputStream;
        block6: {
            byte[] byArray2;
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = null;
            try {
                int n2;
                inputStream = FileUtil.getZipInputStream(byArray);
                if (inputStream == null) break block6;
                byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byArray2 = byteArrayOutputStream.toByteArray();
                byArray = null;
            }
            catch (Throwable throwable) {
                try {
                    Log.e((String)"gzip compress error.", (String)throwable.getMessage());
                    Object var0_2 = null;
                }
                catch (Throwable throwable2) {
                    byArray = null;
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable2;
                }
                FileUtil.safelyCloseFile(inputStream);
                {
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return byArray2;
        }
        byArray = null;
        FileUtil.safelyCloseFile(inputStream);
        return null;
    }

    public static boolean isGzip(byte[] byArray) {
        return (byArray[0] << 8 | byArray[1] & 0xFF) == 8075;
    }

    public static void decompress(InputStream inputStream, String string2) throws Exception {
        FileUtil.decompress(inputStream, string2, 0L, null);
    }

    private static void decompress(InputStream inputStream, String string2, long l2, ZipCompressProgressListener zipCompressProgressListener) throws Exception {
        inputStream = new CheckedInputStream(inputStream, new CRC32());
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        FileUtil.decompress(null, new File(string2), zipInputStream, l2, zipCompressProgressListener, null);
        zipInputStream.close();
        ((FilterInputStream)inputStream).close();
    }

    private static void decompress(File file, File file2, ZipInputStream zipInputStream, long l2, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        ZipEntry zipEntry;
        int n2 = 0;
        boolean bl2 = false;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                zipInputStream.closeEntry();
                return;
            }
            Object object = zipEntry.getName();
            if (TextUtils.isEmpty((CharSequence)object) || !FileUtil.isSafeEntryName((String)object)) {
                bl2 = true;
                break;
            }
            object = file2.getPath() + File.separator + (String)object;
            object = new File((String)object);
            FileUtil.fileProber((File)object);
            if (zipEntry.isDirectory()) {
                ((File)object).mkdirs();
            } else {
                int n3 = FileUtil.decompressFile((File)object, zipInputStream, n2, l2, zipCompressProgressListener, unZipFileBrake);
                n2 += n3;
            }
            zipInputStream.closeEntry();
        }
        if (bl2) {
            try {
                if (file != null) {
                    file.delete();
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void fileProber(File file) {
        if (!(file = file.getParentFile()).exists()) {
            FileUtil.fileProber(file);
            file.mkdir();
        }
    }

    private static int decompressFile(File object, ZipInputStream zipInputStream, long l2, long l3, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        int n2;
        int n3 = 0;
        object = new BufferedOutputStream(new FileOutputStream((File)object));
        byte[] byArray = new byte[1024];
        while ((n2 = zipInputStream.read(byArray, 0, 1024)) != -1) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                ((FilterOutputStream)object).close();
                return n3;
            }
            ((BufferedOutputStream)object).write(byArray, 0, n2);
            n3 += n2;
            if (l3 <= 0L || zipCompressProgressListener == null) continue;
            long l4 = (l2 + (long)n3) * 100L / l3;
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) continue;
            zipCompressProgressListener.onFinishProgress(l4);
        }
        ((FilterOutputStream)object).close();
        return n3;
    }

    public static class UnZipFileBrake {
        public boolean mIsAborted = false;
    }

    public static interface ZipCompressProgressListener {
        public void onFinishProgress(long var1);
    }
}

