/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import android.util.Log;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.amap.mapcore.MapConfig;
import com.autonavi.base.amap.mapcore.NativeBase;
import com.autonavi.base.amap.mapcore.annotations.ParameterIsClass;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JBindingInclude
public class AMapNativeGlOverlayLayer
extends NativeBase {
    @JBindingInclude
    protected long mNative = 0L;
    private NativeFunCallListener nativeFunCallListener;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    protected long getNative() {
        return this.mNative;
    }

    public void createOverlay(final String string2, final BaseOptions baseOptions) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    AMapNativeGlOverlayLayer.this.createOverlay(string2, baseOptions);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, baseOptions);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeCreateOverlay(string2, baseOptions);
            string2 = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            string2 = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    @ParameterIsClass
    public void removeOverlay(final String string2) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    AMapNativeGlOverlayLayer.this.removeOverlay(string2);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeRemoveOverlay(string2);
            string2 = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            string2 = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    @ParameterIsClass
    public void clear(final String ... stringArray) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    AMapNativeGlOverlayLayer.this.clear(stringArray);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunctionArray(aMapNativeGlOverlayLayer, runnable, stringArray);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeClear(stringArray);
            stringArray = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            stringArray = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    @ParameterIsClass
    public void setConfig(final MapConfig mapConfig, final Float f2) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    AMapNativeGlOverlayLayer.this.setConfig(mapConfig, f2);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, mapConfig, f2);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeUpdateConfig(mapConfig, f2.floatValue());
            mapConfig = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            mapConfig = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    @ParameterIsClass
    public void updateOptions(final String string2, final BaseOptions baseOptions) {
        try {
            if (!this.isReady()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        AMapNativeGlOverlayLayer.this.updateOptions(string2, baseOptions);
                        if (baseOptions != null) {
                            baseOptions.resetUpdateFlags();
                        }
                        AMapNativeGlOverlayLayer.this.setRunLowFrame(false);
                    }
                };
                AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
                aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, baseOptions);
                return;
            }
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeUpdateOptions(string2, baseOptions);
                if (baseOptions != null) {
                    baseOptions.resetUpdateFlags();
                }
                string2 = null;
                this.readWriteLock.readLock().unlock();
                return;
            }
            catch (Throwable throwable) {
                string2 = null;
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            Log.d((String)"amapApi", (String)("AMapNativeGlOverlayLayer updateOptions error:" + throwable2.getMessage()));
            return;
        }
    }

    public String contain(LatLng latLng, int n2) {
        String string2 = "";
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                string2 = this.nativeContain(latLng, n2);
                latLng = null;
                this.readWriteLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                latLng = null;
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
        }
        return string2;
    }

    public int getCurrentParticleNum(String string2) {
        int n2 = 0;
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                n2 = this.nativeGetCurrentParticleNum(string2);
                string2 = null;
                this.readWriteLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                string2 = null;
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
        }
        return n2;
    }

    public Object getNativeProperties(final String string2, final String string3, final Object[] objectArray) {
        block4: {
            if (!this.isReady() || string2 == null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        AMapNativeGlOverlayLayer.this.getNativeProperties(string2, string3, objectArray);
                    }
                };
                AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
                aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, string3, objectArray);
                return null;
            }
            try {
                this.readWriteLock.readLock().lock();
                if (!this.destroy) break block4;
                string2 = null;
                this.readWriteLock.readLock().unlock();
                return null;
            }
            catch (Throwable throwable) {
                string2 = null;
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
        }
        Object object = this.nativeGetNativeOverlayProperties(string2, string3, objectArray);
        string2 = null;
        this.readWriteLock.readLock().unlock();
        return object;
    }

    public void render(int n2, int n3, boolean bl2) {
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeRender(n2, n3, bl2);
            Object var1_2 = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    public void setNativeFunCallListener(NativeFunCallListener nativeFunCallListener) {
        this.nativeFunCallListener = nativeFunCallListener;
    }

    public void destroy() {
        try {
            super.destroy();
            this.readWriteLock.writeLock().lock();
            this.nativeDestroy();
            Object var2_1 = null;
            this.readWriteLock.writeLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.readWriteLock.writeLock().unlock();
            throw throwable;
        }
    }

    @JBindingInclude
    private void setRunLowFrame(boolean bl2) {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onSetRunLowFrame(bl2);
        }
    }

    @JBindingInclude
    private void redrawInfoWindow() {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onRedrawInfowindow();
        }
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindow(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindow(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoContents(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoContents(string2);
        }
        return null;
    }

    @JBindingInclude
    private long getInfoWindowUpdateOffsetTime(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowUpdateOffsetTime(string2);
        }
        return 0L;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindowClick(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowClick(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindow(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindow(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindowClick(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindowClick(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getBuildInImageData(int n2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getBuildInImageData(n2);
        }
        return null;
    }

    public void setAMapEngine(long l2) {
        try {
            this.readWriteLock.readLock().lock();
            this.nativeSetAMapEngine(l2);
            Object var1_2 = null;
            this.readWriteLock.readLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.readWriteLock.readLock().unlock();
            throw throwable;
        }
    }

    public void createNative() {
    }

    public void createNative(long l2) {
        try {
            if (this.mNative == 0L) {
                try {
                    try {
                        if (this.readWriteLock != null) {
                            this.readWriteLock.writeLock().lock();
                        }
                        this.nativeCreate(l2);
                    }
                    catch (Throwable throwable) {
                        Object var1_3 = null;
                        if (this.readWriteLock != null) {
                            this.readWriteLock.writeLock().unlock();
                        }
                        return;
                    }
                    Object var1_2 = null;
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Object var1_4 = null;
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                    }
                    throw throwable;
                }
            }
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Object[] objectArray = new Object[]{this.getClass().getSimpleName(), "execute error: ", unsatisfiedLinkError.toString()};
            return;
        }
    }

    protected void finalizeNative() {
        this.nativeFinalize();
    }

    private native void nativeCreateOverlay(String var1, Object var2);

    private native void nativeRemoveOverlay(String var1);

    private native void nativeUpdateConfig(Object var1, float var2);

    private native void nativeUpdateOptions(String var1, Object var2);

    private native void nativeRender(int var1, int var2, boolean var3);

    private native void nativeClear(String[] var1);

    private native String nativeContain(Object var1, int var2);

    private native int nativeGetCurrentParticleNum(String var1);

    private native Object nativeGetNativeOverlayProperties(String var1, String var2, Object[] var3);

    private native void nativeSetAMapEngine(long var1);

    private native void nativeDestroy();

    private native void nativeCreate(long var1);

    private native void nativeFinalize();

    public static interface NativeFunCallListener {
        public void onSetRunLowFrame(boolean var1);

        public void onRedrawInfowindow();

        public BitmapDescriptor getInfoWindow(String var1);

        public BitmapDescriptor getInfoContents(String var1);

        public long getInfoWindowUpdateOffsetTime(String var1);

        public BitmapDescriptor getInfoWindowClick(String var1);

        public BitmapDescriptor getOverturnInfoWindow(String var1);

        public BitmapDescriptor getOverturnInfoWindowClick(String var1);

        public BitmapDescriptor getBuildInImageData(int var1);
    }
}

