/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.maploader;

import android.content.Context;
import android.text.TextUtils;
import com.amap.api.col.3l.db;
import com.amap.api.col.3l.du;
import com.amap.api.col.3l.dx;
import com.amap.api.col.3l.dy;
import com.amap.api.col.3l.dz;
import com.amap.api.col.3l.fl;
import com.amap.api.col.3l.fn;
import com.amap.api.col.3l.ft;
import com.amap.api.col.3l.fw;
import com.amap.api.col.3l.ha;
import com.amap.api.col.3l.ia;
import com.amap.api.col.3l.if;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.base.ae.gmap.NetworkProxyManager;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AMapLoader
implements ia.a {
    private Context context;
    private ADataRequestParam mDataRequestParam;
    private static final int GET_METHOD = 0;
    private volatile boolean isCanceled = false;
    private boolean mRequestCancel = false;
    private ia downloadManager;
    private static final String NETWORK_RESPONSE_CODE_STRING = "\u7f51\u7edc\u5f02\u5e38\u72b6\u6001\u7801\uff1a";
    private long requestMapDataTimestamp = 0L;
    private long requestMapDataPackageSize = 0L;

    @Override
    public void onDownload(byte[] byArray, long l2) {
        if (byArray != null && this.mDataRequestParam != null) {
            NetworkProxyManager.getInstance().receiveNetData(this.mDataRequestParam.handler, byArray, byArray.length);
        }
    }

    @Override
    public void onStop() {
        if (this.mDataRequestParam != null) {
            NetworkProxyManager.getInstance().netStop(this.mDataRequestParam.handler, -1);
        }
        this.staticNetworkPerformance();
    }

    @Override
    public void onFinish() {
        if (this.mDataRequestParam != null) {
            NetworkProxyManager.getInstance().finishDownLoad(this.mDataRequestParam.handler);
        }
        this.staticNetworkPerformance();
    }

    @Override
    public void onException(Throwable throwable) {
        int n2 = -1;
        try {
            int n3;
            String string2 = new String(throwable.getMessage().getBytes("UTF-8"), "UTF-8");
            if (!TextUtils.isEmpty((CharSequence)string2) && (n3 = string2.indexOf(NETWORK_RESPONSE_CODE_STRING)) != -1) {
                n2 = Integer.parseInt(string2.substring(n3 + 8));
            }
            if (this.mDataRequestParam != null) {
                NetworkProxyManager.getInstance().netError(this.mDataRequestParam.handler, -1, n2);
            }
            du.a(this.context, this.hashCode(), NetworkProxyManager.getInstance().isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
        }
        catch (Throwable throwable2) {
            if (this.mDataRequestParam != null) {
                NetworkProxyManager.getInstance().netError(this.mDataRequestParam.handler, -1, -1);
            }
            du.a(this.context, this.hashCode(), NetworkProxyManager.getInstance().isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
        }
        catch (Throwable throwable3) {
            if (this.mDataRequestParam != null) {
                NetworkProxyManager.getInstance().netError(this.mDataRequestParam.handler, -1, -1);
            }
            du.a(this.context, this.hashCode(), NetworkProxyManager.getInstance().isNetworkConnected() ? 0 : 1, this.getNetworkFailedReason(throwable.getMessage()));
            throw throwable3;
        }
        ha.b(throwable, "AMapLoader", "download onException");
        dz.b(dy.e, "map loader exception " + throwable.getMessage());
    }

    public AMapLoader(Context context, ADataRequestParam aDataRequestParam) {
        this.context = context.getApplicationContext();
        this.mDataRequestParam = aDataRequestParam;
        this.mRequestCancel = false;
    }

    public void doRequest() {
        if (ft.a((Context)this.context, (fw)dx.a()).a != ft.c.a) {
            if (this.mDataRequestParam != null) {
                NetworkProxyManager.getInstance().netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        if (this.mRequestCancel) {
            if (this.mDataRequestParam != null) {
                NetworkProxyManager.getInstance().netError(this.mDataRequestParam.handler, -1, -1);
            }
            return;
        }
        Object object = this.mDataRequestParam.requestBaseUrl;
        Object object2 = this.mDataRequestParam.requestUrl;
        if (!((String)object).endsWith("?")) {
            object = (String)object + "?";
        }
        object2 = ((String)object2).replaceAll(";", this.getEncodeRequestParams(";").toString());
        boolean bl2 = false;
        if (object != null && ((String)object).contains("http://m5.amap.com/")) {
            bl2 = true;
        }
        object2 = this.getRequestParams((String)object2, bl2, this.mDataRequestParam.nRequestType);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mDataRequestParam.nRequestType == 0) {
            stringBuffer.append((String)object2);
            stringBuffer.append("&csid=" + UUID.randomUUID().toString());
        } else {
            stringBuffer.append("csid=" + UUID.randomUUID().toString());
        }
        try {
            AMapLoader aMapLoader = this;
            object = (String)object + aMapLoader.generateQueryString(aMapLoader.context, stringBuffer.toString());
            object = new AMapGridDownloadRequest(this.context, (String)object, NetworkProxyManager.getInstance().getUserAgent());
            ((if)object).setConnectionTimeout(30000);
            ((if)object).setSoTimeout(30000);
            if (this.mDataRequestParam.nRequestType != 0) {
                object2 = ((String)object2).getBytes("UTF-8");
                ((AMapGridDownloadRequest)object).setPostEntityBytes((byte[])object2);
            }
            this.requestMapDataTimestamp = System.currentTimeMillis();
            this.requestMapDataPackageSize = ((AMapGridDownloadRequest)object).getEntityBytes() == null ? 0L : (long)((AMapGridDownloadRequest)object).getEntityBytes().length;
            this.downloadManager = new ia((if)object, 0L, -1L, MapsInitializer.getProtocol() == 2);
            this.downloadManager.a(this);
            return;
        }
        catch (Throwable throwable) {
            this.onException(throwable);
            return;
        }
        finally {
            this.doCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        this.mRequestCancel = true;
        if (this.downloadManager != null && !this.isCanceled) {
            ia ia2 = this.downloadManager;
            synchronized (ia2) {
                try {
                    this.isCanceled = true;
                    this.downloadManager.a();
                }
                catch (Throwable throwable) {
                    ha.b(throwable, "AMapLoader", "doCancel");
                }
                return;
            }
        }
    }

    public void doCancelAndNotify() {
        this.onCancel();
        this.doCancel();
    }

    private void onCancel() {
        if (this.mDataRequestParam != null) {
            NetworkProxyManager.getInstance().netCancel(this.mDataRequestParam.handler, -1);
        }
    }

    private String getEncodeRequestParams(String string2) {
        String string3 = null;
        try {
            string3 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string3;
    }

    protected String getRequestParams(String charSequence, boolean bl2, int n2) {
        charSequence = new StringBuffer((String)charSequence);
        if (bl2) {
            ((StringBuffer)charSequence).append("&channel=amap7&div=GNaviMap");
        } else {
            ((StringBuffer)charSequence).append("&channel=amapapi");
            ((StringBuffer)charSequence).append("&div=GNaviMap");
        }
        return ((StringBuffer)charSequence).toString();
    }

    private String generateQueryString(Context context, String charSequence) {
        charSequence = new StringBuffer((String)charSequence);
        String string2 = fl.f(this.context);
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Throwable throwable) {}
        ((StringBuffer)charSequence).append("&key=").append(string2);
        string2 = this.sortReEncoderParams(((StringBuffer)charSequence).toString());
        String string3 = fn.a();
        ((StringBuffer)charSequence).append("&ts=".concat(String.valueOf(string3)));
        ((StringBuffer)charSequence).append("&scode=" + fn.a(context, string3, string2));
        ((StringBuffer)charSequence).append("&dip=16300");
        return ((StringBuffer)charSequence).toString();
    }

    private String sortReEncoderParams(String string2) {
        Object object = string2.split("&");
        Arrays.sort((Object[])object);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object2 : object) {
            object2 = this.strReEncoder((String)object2);
            stringBuffer.append((String)object2);
            stringBuffer.append("&");
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 1) {
            return (String)((String)object).subSequence(0, ((String)object).length() - 1);
        }
        return string2;
    }

    private String strReEncoder(String string2) {
        if (string2 == null) {
            return string2;
        }
        try {
            return URLDecoder.decode(string2, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ha.b(unsupportedEncodingException, "AbstractProtocalHandler", "strReEncoder");
        }
        catch (Exception exception) {
            ha.b(exception, "AbstractProtocalHandler", "strReEncoderException");
        }
        return "";
    }

    private String getNetworkFailedReason(String string2) {
        if (!NetworkProxyManager.getInstance().isNetworkConnected()) {
            return "\u65e0\u7f51\u7edc";
        }
        return string2;
    }

    private void staticNetworkPerformance() {
        du.a(this.context, this.hashCode(), System.currentTimeMillis() - this.requestMapDataTimestamp, this.requestMapDataPackageSize);
    }

    public static class AMapGridDownloadRequest
    extends db {
        private final Context mContext;
        private String sUrl;
        private byte[] postEntityBytes;
        private String userAgent;

        public AMapGridDownloadRequest(Context context, String string2, String string3) {
            this.mContext = context;
            this.sUrl = string2;
            this.userAgent = string3;
        }

        @Override
        public Map<String, String> getRequestHead() {
            Object object = dx.a();
            String string2 = null;
            if (object != null) {
                string2 = ((fw)object).b();
            }
            object = fl.f(this.mContext);
            try {
                object = URLEncoder.encode((String)object, "UTF-8");
            }
            catch (Throwable throwable) {}
            Hashtable<String, String> hashtable = new Hashtable<String, String>(16);
            hashtable.put("User-Agent", this.userAgent);
            hashtable.put("platinfo", String.format(Locale.US, "platform=Android&sdkversion=%s&product=%s", string2, "3dmap"));
            hashtable.put("x-INFO", fn.a(this.mContext));
            hashtable.put("key", (String)object);
            hashtable.put("logversion", "2.1");
            return hashtable;
        }

        @Override
        public Map<String, String> getParams() {
            return null;
        }

        @Override
        public String getURL() {
            return this.sUrl;
        }

        @Override
        public String getIPV6URL() {
            return dx.a(this.getURL());
        }

        @Override
        public boolean isSupportIPV6() {
            return true;
        }

        public void setPostEntityBytes(byte[] byArray) {
            this.postEntityBytes = byArray;
        }

        @Override
        public byte[] getEntityBytes() {
            return this.postEntityBytes;
        }
    }

    public static class ADataRequestParam {
        public String requestBaseUrl;
        public String requestUrl;
        public long handler;
        public int nRequestType;
        public byte[] enCodeString;
        public int nCompress;
    }
}

