/*
 * Decompiled with CFR 0.152.
 */
package org.vosk.android;

import android.os.Handler;
import android.os.Looper;
import java.io.IOException;
import java.io.InputStream;
import org.vosk.Recognizer;
import org.vosk.android.RecognitionListener;

public class SpeechStreamService {
    private final Recognizer recognizer;
    private final InputStream inputStream;
    private final int sampleRate;
    private static final float BUFFER_SIZE_SECONDS = 0.2f;
    private final int bufferSize;
    private Thread recognizerThread;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public SpeechStreamService(Recognizer recognizer, InputStream inputStream, float sampleRate) {
        this.recognizer = recognizer;
        this.sampleRate = (int)sampleRate;
        this.inputStream = inputStream;
        this.bufferSize = Math.round((float)this.sampleRate * 0.2f * 2.0f);
    }

    public boolean start(RecognitionListener listener) {
        if (null != this.recognizerThread) {
            return false;
        }
        this.recognizerThread = new RecognizerThread(listener);
        this.recognizerThread.start();
        return true;
    }

    public boolean start(RecognitionListener listener, int timeout) {
        if (null != this.recognizerThread) {
            return false;
        }
        this.recognizerThread = new RecognizerThread(listener, timeout);
        this.recognizerThread.start();
        return true;
    }

    public boolean stop() {
        if (null == this.recognizerThread) {
            return false;
        }
        try {
            this.recognizerThread.interrupt();
            this.recognizerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.recognizerThread = null;
        return true;
    }

    private final class RecognizerThread
    extends Thread {
        private int remainingSamples;
        private final int timeoutSamples;
        private static final int NO_TIMEOUT = -1;
        RecognitionListener listener;

        public RecognizerThread(RecognitionListener listener, int timeout) {
            this.listener = listener;
            this.timeoutSamples = timeout != -1 ? timeout * SpeechStreamService.this.sampleRate / 1000 : -1;
            this.remainingSamples = this.timeoutSamples;
        }

        public RecognizerThread(RecognitionListener listener) {
            this(listener, -1);
        }

        @Override
        public void run() {
            byte[] buffer = new byte[SpeechStreamService.this.bufferSize];
            while (!(RecognizerThread.interrupted() || this.timeoutSamples != -1 && this.remainingSamples <= 0)) {
                try {
                    int nread = SpeechStreamService.this.inputStream.read(buffer, 0, buffer.length);
                    if (nread < 0) break;
                    boolean isSilence = SpeechStreamService.this.recognizer.acceptWaveForm(buffer, nread);
                    if (isSilence) {
                        String result = SpeechStreamService.this.recognizer.getResult();
                        SpeechStreamService.this.mainHandler.post(() -> this.listener.onResult(result));
                    } else {
                        String partialResult = SpeechStreamService.this.recognizer.getPartialResult();
                        SpeechStreamService.this.mainHandler.post(() -> this.listener.onPartialResult(partialResult));
                    }
                    if (this.timeoutSamples == -1) continue;
                    this.remainingSamples -= nread;
                }
                catch (IOException e) {
                    SpeechStreamService.this.mainHandler.post(() -> this.listener.onError(e));
                }
            }
            if (this.timeoutSamples != -1 && this.remainingSamples <= 0) {
                SpeechStreamService.this.mainHandler.post(() -> this.listener.onTimeout());
            } else {
                String finalResult = SpeechStreamService.this.recognizer.getFinalResult();
                SpeechStreamService.this.mainHandler.post(() -> this.listener.onFinalResult(finalResult));
            }
        }
    }
}

