/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter.buffered;

import com.alkacon.simapi.filter.buffered.MotionBlurFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;

public class RaysFilter
extends MotionBlurFilter {
    private float opacity = 1.0f;
    private boolean shadowOnly = false;

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        float[][] extractAlpha = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {0.0f, 0.0f, 0.0f, this.opacity, 0.0f}};
        BufferedImage shadow = new BufferedImage(width, height, 2);
        new BandCombineOp(extractAlpha, null).filter(src.getRaster(), shadow.getRaster());
        shadow = super.filter(shadow, null);
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        Graphics2D g = dst.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, this.opacity));
        g.drawRenderedImage(shadow, null);
        if (!this.shadowOnly) {
            g.setComposite(AlphaComposite.SrcOver);
            g.drawRenderedImage(src, null);
        }
        g.dispose();
        return dst;
    }

    @Override
    public String toString() {
        return "Stylize/Rays...";
    }
}

