/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.GifWriter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;

public class Quantize {
    static final int MAX_CHILDREN = 16;
    static final int MAX_NODES = 266817;
    static final int MAX_RGB = 255;
    static final int MAX_TREE_DEPTH = 8;

    public static BufferedImage process(BufferedImage image, int maxColors, boolean alphaToBitmask) {
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        Cube cube = new Cube(image, pixels, maxColors, alphaToBitmask);
        cube.classification();
        cube.reduction();
        return cube.assignment();
    }

    private static class Cube {
        byte[][] colorMap;
        int depth;
        int m_numColors;
        int numNodes;
        private boolean addTransparency;
        private int firstColor = 0;
        private boolean m_alphaToBitmask;
        private int m_maxColors;
        private int[] m_pixels;
        private BufferedImage m_source;
        private Node root;

        Cube(BufferedImage source, int[] pixels, int maxColors, boolean alphaToBitmask) {
            this.m_source = source;
            this.m_pixels = pixels;
            this.m_maxColors = maxColors;
            this.m_alphaToBitmask = alphaToBitmask;
            int i = maxColors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        BufferedImage assignment() {
            int dep;
            this.colorMap = new byte[4][this.m_numColors];
            if (this.addTransparency) {
                this.colorMap[0][0] = 0;
                this.colorMap[1][0] = 0;
                this.colorMap[2][0] = 0;
                this.colorMap[3][0] = 0;
            }
            this.m_numColors = this.firstColor;
            this.root.mapColors();
            for (dep = 1; dep <= 8 && 1 << dep < this.m_numColors; ++dep) {
            }
            IndexColorModel icm = this.m_alphaToBitmask ? (this.addTransparency ? new IndexColorModel(dep, this.m_numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], 0) : new IndexColorModel(dep, this.m_numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2])) : new IndexColorModel(dep, this.m_numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], this.colorMap[3]);
            BufferedImage dest = new BufferedImage(this.m_source.getWidth(), this.m_source.getHeight(), 13, icm);
            Search search = new Search();
            byte[] dst = ((DataBufferByte)dest.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < this.m_pixels.length; ++i) {
                int id;
                int pixel = this.m_pixels[i];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel >> 0 & 0xFF;
                int alpha = pixel >> 24 & 0xFF;
                if (this.m_alphaToBitmask) {
                    int n = alpha = alpha < 128 ? 0 : 255;
                }
                if (i == 0) {
                    String.valueOf(alpha);
                }
                if (alpha == 0 && this.addTransparency) {
                    dst[i] = 0;
                    continue;
                }
                Node node = this.root;
                while (node.children[id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2 | (alpha > node.midAlpha ? 1 : 0) << 3] != null) {
                    node = node.children[id];
                }
                search.distance = Integer.MAX_VALUE;
                node.m_parent.closestColor(red, green, blue, alpha, search);
                dst[i] = (byte)search.colorIndex;
            }
            return dest;
        }

        void classification() {
            this.addTransparency = false;
            this.firstColor = 0;
            for (int i = 0; i < this.m_pixels.length; ++i) {
                int pixel = this.m_pixels[i];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel >> 0 & 0xFF;
                int alpha = pixel >> 24 & 0xFF;
                if (this.m_alphaToBitmask) {
                    int n = alpha = alpha < 128 ? 0 : 255;
                }
                if (alpha > 0) {
                    if (this.numNodes > 266817) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int level = 1; level <= this.depth; ++level) {
                        int id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2 | (alpha > node.midAlpha ? 1 : 0) << 3;
                        node = node.children[id] == null ? new Node(node, id, level) : node.children[id];
                        ++node.numPixels;
                    }
                    ++node.unique;
                    node.totalRed += red;
                    node.totalGreen += green;
                    node.totalBlue += blue;
                    node.totalAlpha += alpha;
                    continue;
                }
                if (this.addTransparency) continue;
                this.addTransparency = true;
                ++this.m_numColors;
                this.firstColor = 1;
            }
        }

        void reduction() {
            int threshold = 1;
            while (this.m_numColors > this.m_maxColors) {
                this.m_numColors = this.firstColor;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        static class Search {
            int colorIndex;
            int distance;

            Search() {
            }
        }

        static class Node {
            Node[] children;
            Node m_parent;
            int midAlpha;
            int midBlue;
            int midGreen;
            int midRed;
            int numPixels;
            int totalAlpha;
            int totalBlue;
            int totalGreen;
            int totalRed;
            int unique;
            private int colorIndex;
            private Cube m_cube;
            private int m_id;
            private int m_level;
            private int numChildren;

            Node(Cube cube) {
                this.m_cube = cube;
                this.m_parent = this;
                this.children = new Node[16];
                this.m_id = 0;
                this.m_level = 0;
                this.numPixels = Integer.MAX_VALUE;
                this.midRed = 128;
                this.midGreen = 128;
                this.midBlue = 128;
                this.midAlpha = 128;
            }

            Node(Node parent, int id, int level) {
                this.m_cube = parent.m_cube;
                this.m_parent = parent;
                this.children = new Node[16];
                this.m_id = id;
                this.m_level = level;
                ++this.m_cube.numNodes;
                if (level == this.m_cube.depth) {
                    ++this.m_cube.m_numColors;
                }
                ++parent.numChildren;
                parent.children[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.midRed = parent.midRed + ((id & 1) > 0 ? bi : -bi);
                this.midGreen = parent.midGreen + ((id & 2) > 0 ? bi : -bi);
                this.midBlue = parent.midBlue + ((id & 4) > 0 ? bi : -bi);
                this.midAlpha = parent.midAlpha + ((id & 8) > 0 ? bi : -bi);
            }

            private static final int distance(int r1, int g1, int b1, int a1, int r2, int g2, int b2, int a2) {
                int da = a1 - a2;
                int dr = r1 - r2;
                int dg = g1 - g2;
                int db = b1 - b2;
                return da * da + dr * dr + dg * dg + db * db;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                if (this.m_parent == this) {
                    buf.append("root");
                } else {
                    buf.append("node");
                }
                buf.append(' ');
                buf.append(this.m_level);
                buf.append(" [");
                buf.append(this.midRed);
                buf.append(',');
                buf.append(this.midGreen);
                buf.append(',');
                buf.append(this.midBlue);
                buf.append(',');
                buf.append(this.midAlpha);
                buf.append(']');
                return new String(buf);
            }

            void closestColor(int red, int green, int blue, int alpha, Search search) {
                int distance;
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].closestColor(red, green, blue, alpha, search);
                    }
                }
                if (this.unique != 0 && (distance = Node.distance(this.m_cube.colorMap[0][this.colorIndex] & 0xFF, this.m_cube.colorMap[1][this.colorIndex] & 0xFF, this.m_cube.colorMap[2][this.colorIndex] & 0xFF, this.m_cube.colorMap[3][this.colorIndex] & 0xFF, red, green, blue, alpha)) < search.distance) {
                    search.distance = distance;
                    search.colorIndex = this.colorIndex;
                }
            }

            void mapColors() {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].mapColors();
                    }
                }
                if (this.unique != 0) {
                    int add = this.unique >> 1;
                    this.m_cube.colorMap[0][this.m_cube.m_numColors] = (byte)((this.totalRed + add) / this.unique);
                    this.m_cube.colorMap[1][this.m_cube.m_numColors] = (byte)((this.totalGreen + add) / this.unique);
                    this.m_cube.colorMap[2][this.m_cube.m_numColors] = (byte)((this.totalBlue + add) / this.unique);
                    this.m_cube.colorMap[3][this.m_cube.m_numColors] = (byte)((this.totalAlpha + add) / this.unique);
                    this.colorIndex = this.m_cube.m_numColors++;
                }
            }

            void pruneChild() {
                --this.m_parent.numChildren;
                this.m_parent.unique += this.unique;
                this.m_parent.totalRed += this.totalRed;
                this.m_parent.totalGreen += this.totalGreen;
                this.m_parent.totalBlue += this.totalBlue;
                this.m_parent.totalAlpha += this.totalAlpha;
                this.m_parent.children[this.m_id] = null;
                --this.m_cube.numNodes;
                this.m_cube = null;
                this.m_parent = null;
            }

            void pruneLevel() {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].pruneLevel();
                    }
                }
                if (this.m_level == this.m_cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int threshold, int nextThreshold) {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        nextThreshold = this.children[id].reduce(threshold, nextThreshold);
                    }
                }
                if (this.numPixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.m_cube.m_numColors;
                    }
                    if (this.numPixels < nextThreshold) {
                        nextThreshold = this.numPixels;
                    }
                }
                return nextThreshold;
            }
        }
    }
}

