/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final long startPos;
    private final long length;

    public SubImageInputStream(ImageInputStream pStream, long pLength) throws IOException {
        Validate.notNull(pStream, "stream");
        Validate.isTrue(pLength >= 0L, pLength, "length < 0: %d");
        this.stream = pStream;
        this.startPos = pStream.getStreamPosition();
        this.length = pLength;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int read = this.stream.read();
        if (read >= 0) {
            ++this.streamPos;
        }
        return read;
    }

    @Override
    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int length = (int)Math.min((long)pLength, this.length - this.streamPos);
        int count = this.stream.read(pBytes, pOffset, length);
        if (count >= 0) {
            this.streamPos += (long)count;
        }
        return count;
    }

    @Override
    public long length() {
        try {
            long length = this.stream.length();
            return length < 0L ? -1L : Math.min(length - this.startPos, this.length);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void seek(long pPosition) throws IOException {
        if (pPosition < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("pos < flushedPosition");
        }
        this.stream.seek(this.startPos + pPosition);
        this.streamPos = pPosition;
    }

    @Override
    protected void finalize() throws Throwable {
    }
}

