/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.AbstractTokenIterator;
import java.util.NoSuchElementException;

public class StringTokenIterator
extends AbstractTokenIterator {
    private final String string;
    private final char[] delimiters;
    private int position;
    private final int maxPosition;
    private String next;
    private String nextDelimiter;
    private final boolean includeDelimiters;
    private final boolean includeEmpty;
    private final boolean reverse;
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    private final char maxDelimiter;

    public StringTokenIterator(String pString) {
        this(pString, " \t\n\r\f".toCharArray(), 1, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), 1, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, int pDirection) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), pDirection, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, boolean pIncludeDelimiters) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), 1, pIncludeDelimiters, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, int pDirection, boolean pIncludeDelimiters, boolean pIncludeEmpty) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), pDirection, pIncludeDelimiters, pIncludeEmpty);
    }

    private StringTokenIterator(String pString, char[] pDelimiters, int pDirection, boolean pIncludeDelimiters, boolean pIncludeEmpty) {
        if (pString == null) {
            throw new IllegalArgumentException("string == null");
        }
        this.string = pString;
        this.maxPosition = pString.length();
        this.delimiters = pDelimiters;
        this.includeDelimiters = pIncludeDelimiters;
        this.reverse = pDirection == -1;
        this.includeEmpty = pIncludeEmpty;
        this.maxDelimiter = StringTokenIterator.initMaxDelimiter(pDelimiters);
        this.reset();
    }

    private static char[] toCharArray(String pDelimiters) {
        if (pDelimiters == null) {
            throw new IllegalArgumentException("delimiters == null");
        }
        return pDelimiters.toCharArray();
    }

    private static char initMaxDelimiter(char[] pDelimiters) {
        if (pDelimiters == null) {
            return '\u0000';
        }
        char max = '\u0000';
        for (char c : pDelimiters) {
            if (max >= c) continue;
            max = c;
        }
        return max;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.next = null;
        this.nextDelimiter = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.fetchNext() != null;
    }

    private String fetchNext() {
        if (this.nextDelimiter != null) {
            this.next = this.nextDelimiter;
            this.nextDelimiter = null;
            return this.next;
        }
        if (this.position >= this.maxPosition) {
            return null;
        }
        return this.reverse ? this.fetchReverse() : this.fetchForward();
    }

    private String fetchReverse() {
        int prevPos = this.scanForPrev();
        this.next = this.string.substring(prevPos + 1, this.maxPosition - this.position);
        if (this.includeDelimiters && prevPos >= 0 && prevPos < this.maxPosition) {
            this.nextDelimiter = this.string.substring(prevPos, prevPos + 1);
        }
        this.position = this.maxPosition - prevPos;
        if (this.next.length() == 0 && !this.includeEmpty) {
            return this.fetchNext();
        }
        return this.next;
    }

    private String fetchForward() {
        int nextPos = this.scanForNext();
        this.next = this.string.substring(this.position, nextPos);
        if (this.includeDelimiters && nextPos >= 0 && nextPos < this.maxPosition) {
            this.nextDelimiter = this.string.substring(nextPos, nextPos + 1);
        }
        this.position = ++nextPos;
        if (this.next.length() == 0 && !this.includeEmpty) {
            return this.fetchNext();
        }
        return this.next;
    }

    private int scanForNext() {
        int position;
        for (position = this.position; position < this.maxPosition; ++position) {
            char c = this.string.charAt(position);
            if (c > this.maxDelimiter) continue;
            for (char delimiter : this.delimiters) {
                if (c != delimiter) continue;
                return position;
            }
        }
        return position;
    }

    private int scanForPrev() {
        int position;
        for (position = this.maxPosition - 1 - this.position; position >= 0; --position) {
            char c = this.string.charAt(position);
            if (c > this.maxDelimiter) continue;
            for (char delimiter : this.delimiters) {
                if (c != delimiter) continue;
                return position;
            }
        }
        return position;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String next = this.next;
        this.next = this.fetchNext();
        return next;
    }
}

