/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.ExpiringMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V>
implements ExpiringMap<K, V> {
    private int maxSize = 1000;
    private float trimFactor = 0.01f;

    public LRUHashMap() {
        super(16, 0.75f, true);
    }

    public LRUHashMap(int pMaxSize) {
        super(16, 0.75f, true);
        this.setMaxSize(pMaxSize);
    }

    public LRUHashMap(Map<? extends K, ? extends V> pContents) {
        super(16, 0.75f, true);
        this.putAll(pContents);
    }

    public LRUHashMap(Map<? extends K, ? extends V> pContents, int pMaxSize) {
        super(16, 0.75f, true);
        this.setMaxSize(pMaxSize);
        this.putAll(pContents);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int pMaxSize) {
        if (pMaxSize < 0) {
            throw new IllegalArgumentException("max size must be positive");
        }
        this.maxSize = pMaxSize;
        while (this.size() > this.maxSize) {
            this.removeLRU();
        }
    }

    public float getTrimFactor() {
        return this.trimFactor;
    }

    public void setTrimFactor(float pTrimFactor) {
        if (pTrimFactor < 0.0f || pTrimFactor >= 1.0f) {
            throw new IllegalArgumentException("trim factor must be between 0 and 1");
        }
        this.trimFactor = pTrimFactor;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> pEldest) {
        if (this.size() >= this.maxSize) {
            this.removeLRU();
        }
        return false;
    }

    @Override
    public void processRemoved(Map.Entry<K, V> pRemoved) {
    }

    public void removeLRU() {
        int removeCount = (int)Math.max((float)this.size() * this.trimFactor, 1.0f);
        Iterator entries = this.entrySet().iterator();
        while (removeCount-- > 0 && entries.hasNext()) {
            entries.next();
            entries.remove();
        }
    }
}

